/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.stress;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.poi.hdgf.HDGFDiagram;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hdgf.streams.Stream;
import org.apache.poi.hdgf.streams.TrailerStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;

public class HDGFFileHandler extends POIFSFileHandler {
	@Override
	public void handleFile(InputStream stream) throws Exception {
		HDGFDiagram diagram = new HDGFDiagram(new POIFSFileSystem(stream));
		Stream[] topLevelStreams = diagram.getTopLevelStreams();
		assertNotNull(topLevelStreams);
		for(Stream str : topLevelStreams) {
			assertTrue(str.getPointer().getLength() >= 0);
		}
		
		TrailerStream trailerStream = diagram.getTrailerStream();
		assertNotNull(trailerStream);
		assertTrue(trailerStream.getPointer().getLength() >= 0);
		
		// writing is not yet implemented... handlePOIDocument(diagram);
	}
	
	// a test-case to test this locally without executing the full TestAllFiles
	@Test
	public void test() throws Exception {
		File file = new File("test-data/diagram/44501.vsd");

		InputStream stream = new FileInputStream(file);
		try {
			handleFile(stream);
		} finally {
			stream.close();
		}
		
		handleExtracting(file);
		
		stream = new FileInputStream(file);
		try {
			VisioTextExtractor extractor = new VisioTextExtractor(stream);
			try {
				assertNotNull(extractor.getText());
			} finally {
				extractor.close();
			}
		} finally {
			stream.close();
		}
	}
}
