/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.ValueEval;

/**
 * Implementation of the DGet function:
 * Finds the value of a column in an area with given conditions.
 * 
 * TODO:
 * - wildcards ? and * in string conditions
 * - functions as conditions
 */
public final class DGet implements IDStarAlgorithm {
    private ValueEval result;
    
    public void reset() {
        result = null;
    }

    public boolean processMatch(ValueEval eval) {
        if(result == null) // First match, just set the value.
        {
            result = eval;
        }
        else // There was a previous match, since there is only exactly one allowed, bail out.
        {
            result = ErrorEval.NUM_ERROR;
            return false;
        }

        return true;
    }

    public ValueEval getResult() {
        if(result == null) {
            return ErrorEval.VALUE_INVALID;
        } else {
            return result;
        }
    }
}
