#!/usr/bin/perl -w
#
#  Test that DropMethod works correctly.
#
# $Id: drop-method.t,v 1.4 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';



cleanConf();

my $conf = <<EOF;
DropAction status=403
DropMethod HEAD
EOF
writeConf( $conf );

restart();


#
#  Get a random path
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );

#
#  Now we make some requests.
#
is( makeHEADRequest( "/$path" ),
    403, "Random access blocked as expected - HEAD" );
is( makeGETRequest( "/$path" ),
    404, "Random allowed as expected - GET /$path" );
is( makePOSTRequest( "/$path" ),
    404, "Random allowed as expected - POST /$path" );

$conf = <<EOF;
DropAction status=403
DropMethod HEAD status=500
EOF
writeConf( $conf );
restart();


is( makeHEADRequest( "/$path" ),
    500, "Random request blocked as expected - HEAD per-rule action" );
is( makeGETRequest( "/$path" ),
    404, "Random request allowed as expected - GET  /$path" );
is( makePOSTRequest( "/$path" ),
    404, "Random request allowed as expected - POST /$path" );

#
#  Cleanup
#
cleanConf();
restart();
