#!/usr/bin/perl -w
#
#  Test that DropParamValues works as expected
#
# $Id: drop-param-values.t,v 1.4 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

    my $conf = <<EOF;
DropAction status=403

DropParamValues wget
DropParamValues /tmp status=500
EOF

writeConf( $conf );
restart();



#
#  Now we make some requests.
#
is( makeGETRequest( "/" ),
    200, "/ allowed as expected" );

is( makeGETRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: GET" );
is( makeHEADRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: HEAD" );
is( makePOSTRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: POST" );


is( makeGETRequest( "/?foo=wget" ),
    403, "foo paramater matched as expected: GET" );
is( makeHEADRequest( "/?foo=wget" ),
    403, "foo parameter matched as expected: HEAD" );
is( makePOSTRequest( "/?foo=wget" ),
    403, "foo parameter matched as expected: POST" );

is( makeGETRequest( "/?foo=cd%/tmp" ),
    500, "Custom rule matched as expected: GET" );
is( makeHEADRequest( "/?foo=cd%/tmp" ),
    500, "Custom rule matched as expected: HEAD" );
is( makePOSTRequest( "/?foo=cd%/tmp" ),
    500, "Custom rule matched as expected: POST" );

#
#  Cleanup
#
cleanConf();
restart();
