#!/usr/bin/perl -w
#
#  Test that DropReferer works as expected
#
# $Id: drop-referer.t,v 1.4 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );


#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';

cleanConf();

my $conf = <<EOF;
DropAction status=403
DropReferer profile.(livejournal|myspace).com

# Per-rule match
DropReferer bloglines.com status=500
EOF

writeConf( $conf );
restart();


#
#  Get a random path, so we can be sure we'll get a 404 code.
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );

#
#  Now we make some requests.
#
is( makeGETRequest( "/$path" ),
    404, "/$path allowed as expected" );

is( makeGETRequest( "/$path", referer => 'steve.org.uk' ),
    404, "Referer steve.org.uk allowed as expected: GET" );
is( makeHEADRequest( "/$path", referer => 'steve.org.uk' ),
    404, "Referer steve.org.uk allowed as expected: HEAD" );
is( makePOSTRequest( "/$path", referer => 'steve.org.uk' ),
    404, "Referer steve.org.uk allowed as expected: POST" );


is( makeGETRequest( "/$path", referer => 'profile.myspace.com' ),
    403, "Referer profile.myspace dropped as expected" );
is( makeGETRequest( "/$path", referer => 'profile.livejournal.com' ),
    403, "Referer profile.livejournal dropped as expected" );


is( makeGETRequest( "/$path", referer => 'bloglines.com' ),
    500, "Per-rule action worked: GET" );
is( makeHEADRequest( "/$path", referer => 'bloglines.com' ),
    500, "Per-rule action worked: HEAD" );
is( makePOSTRequest( "/$path", referer => 'bloglines.com' ),
    500, "Per-rule action worked: POST" );



#
#  Cleanup
#
cleanConf();
restart();
