#!/usr/bin/perl -w
#
#  Test that DropWhitelist works as expected
#
# $Id: drop-whitelist.t,v 1.3 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

my $conf = <<EOF;
DropAction status=403
DropAgent "web stripper"
EOF

writeConf( $conf );
restart();


#
#  Now we make some requests.
#
is( makeGETRequest( "/", agent => 'web stripper' ),
    403, "Request dropped as expected - not whitelisted: GET" );

is( makeHEADRequest( "/", agent => 'web stripper' ),
    403, "Request dropped as expected - not whitelisted: HEAD" );

is( makePOSTRequest( "/", agent => 'web stripper' ),
    403, "Request dropped as expected - not whitelisted: POST" );


cleanConf();

$conf .= "\nDropWhitelist 127.0.0.1\n" ;
writeConf( $conf );
restart();


is( makeGETRequest( "/", agent => 'web stripper' ),
    200, "Request allowed as expected - whitelisted: GET" );

is( makeHEADRequest( "/", agent => 'web stripper' ),
    200, "Request allowed as expected - whitelisted: HEAD" );

is( makePOSTRequest( "/", agent => 'web stripper' ),
    200, "Request allowed as expected- whitelisted: POST" );


#
#  Cleanup
#
cleanConf();
restart();
