/***************************************************************************
 $RCSfile: hbci_p.h,v $
                             -------------------
    cvs         : $Id: hbci_p.h,v 1.10 2004/09/23 05:06:18 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef GWHBCI_HBCI_P_H
#define GWHBCI_HBCI_P_H

#include "hbci_l.h"
#include <aqhbci/message.h>


struct AH_HBCI {
  GWEN_INHERIT_ELEMENT(AH_HBCI);

  AB_BANKING *banking;
  AB_PROVIDER *provider;

  char *productName;
  char *productVersion;

  GWEN_XMLNODE *defs;

  AH_MEDIUMPROVIDER_LIST *mediumProviders;
  AH_MEDIUM_LIST *activeMedia;

  AH_MSG_LIST *incomingMsgs;

  AH_BANK_LIST *banks;

  AH_DIALOG_LIST *dialogs;

  AH_HBCI_DIALOGUPFN dialogUpFn;
  AH_HBCI_DIALOGDOWNFN dialogDownFn;

  GWEN_TYPE_UINT32 libId;

  GWEN_TYPE_UINT32 counter;
  AH_MEDIUM *currentMedium;

  GWEN_DB_NODE *sharedRuntimeData;
};



AH_MEDIUMPROVIDER *AH_HBCI_LoadMediumPlugin(AH_HBCI *hbci,
                                            const char *mtype);

AH_MEDIUMPROVIDER *AH_HBCI_GetMediumProvider(AH_HBCI *hbci,
                                             const char *mtype);



AH_MEDIUM *AH_HBCI__FindMedium(AH_HBCI *hbci,
                               int country,
                               const char *bankId,
                               const char *userId);


void AH_HBCI__CollectMessages(AH_HBCI *hbci);


int AH_HBCI_AddObjectPath(const AH_HBCI *hbci,
                          int country,
                          const char *bankId,
                          const char *accountId,
                          const char *userId,
                          const char *customerId,
                          GWEN_BUFFER *nbuf);

int AH_HBCI_SaveSettings(const char *path, GWEN_DB_NODE *db);
GWEN_DB_NODE *AH_HBCI_LoadSettings(const char *path);


int AH_HBCI_AddDefinitions(AH_HBCI *hbci, GWEN_XMLNODE *node);
GWEN_XMLNODE *AH_HBCI_LoadDefaultXmlFiles(const AH_HBCI *hbci);


#endif /* GWHBCI_HBCI_P_H */



