/***************************************************************************
 $RCSfile: mediumpintan.c,v $
                             -------------------
    cvs         : $Id: mediumpintan.c,v 1.6 2005/03/28 02:04:33 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "mediumpintan_p.h"
#include "aqhbci_l.h"
#include <gwenhywfar/debug.h>
#include <gwenhywfar/misc.h>

#include <stdlib.h>
#include <assert.h>
#include <string.h>


GWEN_INHERIT(AH_MEDIUM, AH_MEDIUMPINTAN);


AH_MEDIUM *AH_MediumPINTAN_new(AH_HBCI *hbci,
                               const char *mtn,
                               const char *mediumName){
  AH_MEDIUM *m;
  AH_MEDIUMPINTAN *mpt;

  m=AH_Medium_new(hbci, AH_MediumTypePINTAN, mtn, mediumName);
  GWEN_NEW_OBJECT(AH_MEDIUMPINTAN, mpt);
  GWEN_INHERIT_SETDATA(AH_MEDIUM, AH_MEDIUMPINTAN,
                       m, mpt,
                       AH_MediumPINTAN_freeData);
  return m;
}



void AH_MediumPINTAN_freeData(void *bp, void *p) {
  AH_MEDIUMPINTAN *mpt;

  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Destroying AH_MEDIUMPINTAN");
  mpt=(AH_MEDIUMPINTAN*)p;
  GWEN_FREE_OBJECT(mpt);
}



int AH_MediumPINTAN_GetPin(AH_MEDIUM *m,
                           char *buffer,
                           int minSize,
                           int maxSize,
                           int crea){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  assert(mpt->getPinFn);
  return mpt->getPinFn(m, buffer, minSize, maxSize, crea);
}



int AH_MediumPINTAN_GetTan(AH_MEDIUM *m,
                           char *buffer,
                           int minSize,
                           int maxSize){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  assert(mpt->getTanFn);
  return mpt->getTanFn(m, buffer, minSize, maxSize);
}



int AH_MediumPINTAN_SetTanStatus(AH_MEDIUM *m,
                                 const char *buffer,
                                 AH_MEDIUMPINTAN_TANSTATUS tst){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  assert(mpt->setTanStatusFn);
  return mpt->setTanStatusFn(m, buffer, tst);
}



void AH_MediumPINTAN_SetGetPinFn(AH_MEDIUM *m, AH_MEDIUMPINTAN_GETPINFN f){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  mpt->getPinFn=f;
}



void AH_MediumPINTAN_SetGetTanFn(AH_MEDIUM *m, AH_MEDIUMPINTAN_GETTANFN f){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  mpt->getTanFn=f;
}



void AH_MediumPINTAN_SetSetTanStatusFn(AH_MEDIUM *m,
                                       AH_MEDIUMPINTAN_SETTANSTATUSFN f){
  AH_MEDIUMPINTAN *mpt;

  assert(m);
  mpt=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMPINTAN, m);
  assert(mpt);

  mpt->setTanStatusFn=f;
}




















