/***************************************************************************
 $RCSfile: mediumrdh.h,v $
                             -------------------
    cvs         : $Id: mediumrdh.h,v 1.6 2004/11/04 18:47:45 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AH_MEDIUMRDH_H
#define AH_MEDIUMRDH_H

#include <aqhbci/medium.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/crypt.h>
#include <gwenhywfar/keyspec.h>

#ifdef __cplusplus
extern "C" {
#endif


/** @defgroup AQHBCI_MOD_HBCI_MEDIUM_RDH HBCI RDH Medium
 * @ingroup AQHBCI_MOD_HBCI_MEDIUM
 * @short Security Medium For HBCI in RDH Mode
 * @author Martin Preuss<martin@libchipcard.de>
 *
 */
/*@{*/

/** @name Prototypes For Virtual Functions
 *
 */
/*@{*/

typedef int (*AH_MEDIUMRDH_SETPUBSIGNKEYFN)(AH_MEDIUM *m,
                                            const GWEN_CRYPTKEY *key);
typedef int (*AH_MEDIUMRDH_SETPUBCRYPTKEYFN)(AH_MEDIUM *m,
                                             const GWEN_CRYPTKEY *key);


typedef GWEN_CRYPTKEY*
  (*AH_MEDIUMRDH_GETLOCALPUBSIGNKEYFN)(AH_MEDIUM *m);
typedef GWEN_CRYPTKEY*
  (*AH_MEDIUMRDH_GETLOCALPUBCRYPTKEYFN)(AH_MEDIUM *m);

typedef GWEN_CRYPTKEY* (*AH_MEDIUMRDH_GETPUBSIGNKEYFN)(AH_MEDIUM *m);
typedef GWEN_CRYPTKEY* (*AH_MEDIUMRDH_GETPUBCRYPTKEYFN)(AH_MEDIUM *m);

typedef GWEN_CRYPTKEY* (*AH_MEDIUMRDH_GETLOCALTMPSIGNKEYFN)(AH_MEDIUM *m);
typedef GWEN_CRYPTKEY* (*AH_MEDIUMRDH_GETLOCALTMPCRYPTKEYFN)(AH_MEDIUM *m);

typedef int (*AH_MEDIUMRDH_CREATEKEYSFN)(AH_MEDIUM *m);
typedef int (*AH_MEDIUMRDH_ACTIVATEKEYSFN)(AH_MEDIUM *m);
/*@}*/




/** @name Constructor And Destructor
 *
 */
/*@{*/
AH_MEDIUM *AH_MediumRDH_new(AH_HBCI *hbci,
                            const char *mtn,
                            const char *mediumName);

/*@}*/


/** @name Virtual Functions
 *
 */
/*@{*/

GWEN_CRYPTKEY *AH_MediumRDH_GetLocalPubSignKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumRDH_GetLocalPubCryptKey(AH_MEDIUM *m);

GWEN_CRYPTKEY *AH_MediumRDH_GetLocalTmpSignKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumRDH_GetLocalTmpCryptKey(AH_MEDIUM *m);

GWEN_CRYPTKEY *AH_MediumRDH_GetPubSignKey(AH_MEDIUM *m);
int AH_MediumRDH_SetPubSignKey(AH_MEDIUM *m,
                               const GWEN_CRYPTKEY *key);
GWEN_CRYPTKEY *AH_MediumRDH_GetPubCryptKey(AH_MEDIUM *m);
int AH_MediumRDH_SetPubCryptKey(AH_MEDIUM *m,
                                const GWEN_CRYPTKEY *key);
int AH_MediumRDH_CreateKeys(AH_MEDIUM *m);

/**
 * The implementation of this function must update the medium's keyspecs.
 */
int AH_MediumRDH_ActivateKeys(AH_MEDIUM *m);
/*@}*/



/** @name Setters For Virtual Functions
 *
 */
/*@{*/
void AH_MediumRDH_SetGetLocalPubSignKeyFn(AH_MEDIUM *m,
                                          AH_MEDIUMRDH_GETLOCALPUBSIGNKEYFN f);
void AH_MediumRDH_SetGetLocalPubCryptKeyFn(AH_MEDIUM *m,
                                           AH_MEDIUMRDH_GETLOCALPUBCRYPTKEYFN f);

void AH_MediumRDH_SetGetLocalTmpSignKeyFn(AH_MEDIUM *m,
                                          AH_MEDIUMRDH_GETLOCALTMPSIGNKEYFN f);
void AH_MediumRDH_SetGetLocalTmpCryptKeyFn(AH_MEDIUM *m,
                                           AH_MEDIUMRDH_GETLOCALTMPCRYPTKEYFN f);


void AH_MediumRDH_SetSetPubSignKeyFn(AH_MEDIUM *m,
                                         AH_MEDIUMRDH_SETPUBSIGNKEYFN f);
void AH_MediumRDH_SetGetPubSignKeyFn(AH_MEDIUM *m,
                                         AH_MEDIUMRDH_GETPUBSIGNKEYFN f);
void
  AH_MediumRDH_SetSetPubCryptKeyFn(AH_MEDIUM *m,
                                       AH_MEDIUMRDH_SETPUBCRYPTKEYFN f);
void
  AH_MediumRDH_SetGetPubCryptKeyFn(AH_MEDIUM *m,
                                       AH_MEDIUMRDH_GETPUBCRYPTKEYFN f);
void AH_MediumRDH_SetCreateKeysFn(AH_MEDIUM *m,
                                      AH_MEDIUMRDH_CREATEKEYSFN f);
void AH_MediumRDH_SetActivateKeysFn(AH_MEDIUM *m,
                                        AH_MEDIUMRDH_ACTIVATEKEYSFN f);

/*@}*/


AH_MEDIUM_RESULT AH_MediumRDH_EncryptKey(AH_MEDIUM *m,
                                         GWEN_CRYPTKEY *remoteCryptKey,
                                         GWEN_BUFFER *srckey,
                                         GWEN_BUFFER *encKey);
AH_MEDIUM_RESULT AH_MediumRDH_DecryptKey(AH_MEDIUM *m,
                                         GWEN_CRYPTKEY *localCryptKey,
                                         GWEN_BUFFER *srckey,
                                         GWEN_BUFFER *deckey);





/*@}*/ /* defgroup */

#ifdef __cplusplus
}
#endif


#endif /* AH_MEDIUM_H */


