/***************************************************************************
 $RCSfile: rdhkeyfile_p.h,v $
                             -------------------
    cvs         : $Id: rdhkeyfile_p.h,v 1.12 2005/01/30 13:04:31 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AH_MEDIUMRDHKEYFILE_P_H
#define AH_MEDIUMRDHKEYFILE_P_H

#define AH_MEDIUMRDHKEYFILE_NAME "RDHKeyFile"
#define AH_MEDIUMRDHKEYFILE_VMAJOR 1
#define AH_MEDIUMRDHKEYFILE_VMINOR 0


#define AH_MEDIUMRDHKEYFILE_KEYLEN 768
#define AH_MEDIUMRDHKEYFILE_PINMINLENGTH 6

#include "rdhkeyfile.h"
#include <time.h>


typedef struct AH_MEDIUMRDHKEYFILE AH_MEDIUMRDHKEYFILE;
struct AH_MEDIUMRDHKEYFILE {
  char password[16];
  int passWordIsSet;

  int country;
  char *bankId;
  char *userId;
  char *systemId;

  int selected;

  unsigned int localSignSeq;
  unsigned int remoteSignSeq;

  GWEN_CRYPTKEY *localSignKey;
  GWEN_CRYPTKEY *localCryptKey;

  GWEN_CRYPTKEY *remoteSignKey;
  GWEN_CRYPTKEY *remoteCryptKey;

  GWEN_CRYPTKEY *localSignKeyBak;
  GWEN_CRYPTKEY *localCryptKeyBak;

  time_t ctime;
  time_t mtime;
};


AH_MEDIUMRDHKEYFILE *AH_MediumRDHKeyFile_Data_new();
void AH_MediumRDHKeyFile_Data_free(AH_MEDIUMRDHKEYFILE *mrdh);

void AH_MediumRDHKeyFile_FreeData(void *bp, void *p);


GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetLocalPubSignKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetLocalPubCryptKey(AH_MEDIUM *m);

GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetPubSignKey(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_SetPubSignKey(AH_MEDIUM *m,
                                      const GWEN_CRYPTKEY *key);
GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetPubCryptKey(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_SetPubCryptKey(AH_MEDIUM *m,
                                       const GWEN_CRYPTKEY *key);
int AH_MediumRDHKeyFile_CreateKeys(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_ActivateKeys(AH_MEDIUM *m);

int AH_MediumRDHKeyFile_Mount(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_Create(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_Unmount(AH_MEDIUM *m, int force);

AH_MEDIUM_RESULT AH_MediumRDHKeyFile_Sign(AH_MEDIUM *m,
                                          GWEN_BUFFER *msgbuf,
                                          GWEN_BUFFER *signbuf);
int AH_MediumRDHKeyFile_GetNextSignSeq(AH_MEDIUM *m);
int AH_MediumRDHKeyFile_SetLocalSignSeq(AH_MEDIUM *m, int i);

AH_MEDIUM_RESULT AH_MediumRDHKeyFile_EncryptKey(AH_MEDIUM *m,
                                                GWEN_BUFFER *srckey,
                                                GWEN_BUFFER *encKey);
AH_MEDIUM_RESULT AH_MediumRDHKeyFile_DecryptKey(AH_MEDIUM *m,
                                                GWEN_BUFFER *srckey,
                                                GWEN_BUFFER *decKey);
GWEN_BUFFER *AH_MediumRDHKeyFile_GenerateMsgKey(AH_MEDIUM *m);



AH_MEDIUM_RESULT AH_MediumRDHKeyFile_Verify(AH_MEDIUM *m,
                                            GWEN_BUFFER *msgbuf,
                                            GWEN_BUFFER *signbuf,
                                            int signseq);

int AH_MediumRDHKeyFile_SelectContext(AH_MEDIUM *m, int idx);

int AH_MediumRDHKeyFile_CreateContext(AH_MEDIUM *m,
                                      int country,
                                      const char *bankId,
                                      const char *userId);

int AH_MediumRDHKeyFile_RemoveContext(AH_MEDIUM *m, int idx);


int AH_MediumRDHKeyFile_ReadContext(AH_MEDIUM *m,
                                    int idx,
                                    int *country,
                                    GWEN_BUFFER *bankId,
                                    GWEN_BUFFER *userId,
                                    GWEN_BUFFER *server,
                                    int *port);

int AH_MediumRDHKeyFile_WriteContext(AH_MEDIUM *m,
                                     int idx,
                                     int country,
                                     const char *bankId,
                                     const char *userId,
                                     const char *server,
                                     int port);



int AH_MediumRDHKeyFile__ReadFile(AH_MEDIUM *m, int fd);
int AH_MediumRDHKeyFile__WriteFile(AH_MEDIUM *m, int fd);
int AH_MediumRDHKeyFile__ReloadIfNeeded(AH_MEDIUM *m, int fd);
AH_MEDIUM_CHECKRESULT AH_MediumRDHKeyFile__CheckFile(AH_MEDIUM *m, int fd);

int AH_MediumRDHKeyFile__OpenFile(AH_MEDIUM *m, int wr);
int AH_MediumRDHKeyFile__CloseFile(AH_MEDIUM *m, int fd);


GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetLocalTmpCryptKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumRDHKeyFile_GetLocalTmpSignKey(AH_MEDIUM *m);




AH_MEDIUM*
  AH_MediumRDHKeyFileProvider_Factory(AH_MEDIUMPROVIDER *mp,
                                      AH_HBCI *hbci,
                                      const char *mediumName);

AH_MEDIUM_CHECKRESULT
  AH_MediumRDHKeyFileProvider_Check(AH_MEDIUMPROVIDER *mp,
                                    AH_HBCI *hbci,
                                    GWEN_BUFFER *mediumName);


#endif /* AH_MEDIUMRDHKEYFILE_H */







