// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id$
//------------------------------------------------------------------------------
//                            MixerTest.cpp
//------------------------------------------------------------------------------
//  Copyright (c) YEAR by YOUR-NAME 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Thu Oct 20 22:41:21 2005
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   Your application program name                                            \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Short description to give general feeling                                \n"
"   of what its main purpose is.                                             \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  app_name [OPTIONS]                                               \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
" -b, --daemon BOOL       - Run process as true UNIX daemon                  \n"
" -l, --pidfile PATH      - The process ID is written to the lockfile PATH   \n"
"                           instead of default ~/.{procname}.pid             \n"
" -L, --ommit-pidfile BOOL- Do not create PID lockfile                       \n"
"                                                                            \n"
" -D, --log-file NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout BOOL   - Write debug to standard output                   \n"
" -z, --log-size NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -c, --log-level NUM     - Log verbosity                                    \n"
" -s, --with-log-server BOOL - Redirect log messages to the log server          \n"
" -S, --log-server NAME   - Define assa-logd server address                  \n"
"                                                                            \n"
" -m, --mask MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
" -p, --port NAME         - The tcp/ip port NAME (default - procname)        \n"
" -n, --instance NUM      - Process instance NUM (default - none)            \n"
" -f, --config-file NAME  - Alternative configuration file NAME              \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                            \n";
//------------------------------------------------------------------------------

#include <assa/Assure.h>


#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif
#include <string>
using std::string;

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>

class MixerTest :
    public ASSA::GenServer,
    public ASSA::Singleton<MixerTest>
{
public:
    MixerTest ();

    virtual void init_service ();
    virtual void process_events ();


private:
};


/* Useful definitions */

#define MIXERTEST  MixerTest::get_instance()
#define REACTOR MIXERTEST->get_reactor()


// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(MixerTest);

MixerTest::
MixerTest (){

    // Following list removes all predefined options.
    // Remove only those that you won't use.
    // Don't forget to update your help message in 'main.cpp'!
    //

    // ---General---
    // rm_opt ('h', "help"         );
    // rm_opt ('v', "version"      );

    // ---Debugging---
    // rm_opt ('m', "mask"         );
    // rm_opt ('d', "log-stdout"   );
    // rm_opt ('D', "log-file"     );
    // rm_opt ('z', "log-size"     );

    // ---Configuration---
    // rm_opt ('f', "config-file"  );
    // rm_opt ('n', "instance"     );
    // rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    // rm_opt ('b', "daemon"       );
    // rm_opt ('l', "pidfile"      );
    // rm_opt ('L', "ommit-pidfile");

    /*---
     * By defauil disable all debugging
     *---*/
    m_mask = ASSA::APP | ASSA::ERROR;
    m_log_file = "MixerTest.log";
}


void
MixerTest::
init_service ()
{
    trace("MixerTest::init_service");

    //
    // Insert initialization code here
    //

    DL((ASSA::APP,"Service has been initialized\n"));
}

void
MixerTest::
process_events ()
{
    trace("MixerTest::process_events");

    while (service_is_active ()) {
        m_reactor.waitForEvents ();
    }

    // Shut the service down
    m_reactor.stopReactor ();
    DL((ASSA::APP,"Service stopped!\n"));
}



int
main (int argc, char* argv[])
{
    static const char release[] = "VERSION";
    int patch_level = 0;

    MIXERTEST->set_version (release, patch_level);
    MIXERTEST->set_author  ("YOUR-NAME");
    MIXERTEST->set_flags   (ASSA::GenServer::RMLOG);

    MIXERTEST->init (&argc, argv, help_msg);
 
    MIXERTEST->init_service ();
    MIXERTEST->process_events ();


    return MIXERTEST->get_exit_value ();
}

