#ifndef BUFFYCONFIG_H
#define BUFFYCONFIG_H

#pragma interface

#include <buffy/Exception.h>
#include <buffy/MailProgram.h>
#include <libxml++/libxml++.h>

class Config
{
protected:
	xmlpp::DomParser _xmlparser;

	// Cached elements
	xmlpp::Document* doc_conf;
	xmlpp::Element* _view_empty;
	xmlpp::Element* _view_read;
	xmlpp::Element* _view_important;
	xmlpp::Element* _interval;

	// State directory
	std::string rcfile;

	xmlpp::Element* el_root() const throw ();
	xmlpp::Element* el_general() const throw ();
	xmlpp::Element* el_view() const throw ();
	xmlpp::Element* el_view_empty() throw ();
	xmlpp::Element* el_view_read() throw ();
	xmlpp::Element* el_view_important() throw ();
	xmlpp::Element* el_locations() const throw ();
	xmlpp::Element* el_interval() throw ();
	xmlpp::Element* el_programs() const throw ();
	xmlpp::Element* el_mailboxes() const throw ();
	xmlpp::Element* el_applications() const throw ();
	xmlpp::Element* el_folders() const throw ();
	xmlpp::Element* el_app(const std::string& appname) const throw ();
	xmlpp::Element* el_folder(const MailFolder& folder) const throw ();

	void loadConfiguration(const std::string& fname) throw (SystemException, ConsistencyCheckException);

public:
	Config() throw (SystemException, ConsistencyCheckException);
	Config(const std::string& fname) throw (SystemException, ConsistencyCheckException);
	~Config() throw ();

	bool get_view_read() throw ();
	bool get_view_empty() throw ();
	bool get_view_important() throw ();

	void set_view_read(bool val) throw ();
	void set_view_empty(bool val) throw ();
	void set_view_important(bool val) throw ();

	/*
	bool get_view_read(const MailFolder& mf) throw ();
	bool get_view_empty(const MailFolder& mf) throw ();
	bool get_view_important(const MailFolder& mf) throw ();

	void set_view_read(const MailFolder& mf, bool val) throw ();
	void set_view_empty(const MailFolder& mf, bool val) throw ();
	void set_view_important(const MailFolder& mf, bool val) throw ();
	*/

	int get_update_interval() throw ();
	void set_update_interval(int val) throw ();

	std::vector<std::string> get_folder_locations() throw ();
	void set_folder_locations(const std::vector<std::string>& locations) throw ();

	std::vector<MailProgram> get_mail_programs() throw ();
	void set_mail_programs(const std::vector<MailProgram>& programs) throw ();
	MailProgram get_selected_mail_program() throw ();

	std::string get_application_data(
			const std::string& app,
			const std::string& key,
			const std::string& def="") throw ();

	void set_application_data(
			const std::string& app,
			const std::string& key,
			const std::string& val) throw ();

	std::string get_folder_data(
			const MailFolder& folder,
			const std::string& key,
			const std::string& def="") throw ();

	void set_folder_data(
			const MailFolder& folder,
			const std::string& key,
			const std::string& val) throw ();

	void save() throw (ConsistencyCheckException);
	void save(const std::string& file) throw (ConsistencyCheckException);
};


// vim:set ts=4 sw=4:
#endif
