/**
 * @file test-utils.h
 * @author Peter Rockai (mornfall) <mornfall@danill.sk>
 * @brief Utility functions for the unit tests
 */
#include <tut.h>

#include <string>
#include <buffy/stringf.h>
#include <iostream>

#define TESTGRP(name) \
typedef test_group<name ## _shar> tg; \
typedef tg::object to; \
tg name ## _tg (#name);


namespace tut_buffy {
using namespace std;
using namespace stringf;
using namespace buffy;
using namespace tut;

inline static std::string __ensure_errmsg(std::string f, int l, std::string msg)
{
    char buf[64];
    snprintf(buf, 63, "%d", l);
    buf[63] = 0;
    std::string ln = buf;
    f.append(":");
    f.append(ln);
    f.append(": '");
    f.append(msg);
    f.append("'");
    return f;
}
#define gen_ensure(x) ensure (__ensure_errmsg(__FILE__, __LINE__, #x).c_str(), (x))

inline static std::string __tc_ensure_errmsg(std::string f, int l, std::string f1, int l1, std::string msg)
{
    return f + ":" + fmt(l) + ": '" + f1 + ":" + fmt(l1) + ": " + msg + "'";
}

}

/*
namespace tut {
    static void aptInit () {
        pkgInitConfig (*_config);
        _config->Set("Dir", CACHE_DIR);
        _config->Set("Dir::Cache", "cache");
        _config->Set("Dir::State", "state");
        _config->Set("Dir::Etc", "etc");
        _config->Set("Dir::State::status", CACHE_DIR "dpkg-status");
        pkgInitSystem (*_config, _system);
        // _config -> Set ("Capture::Cache::UseExtState", extstate);
    }
}
*/
