%define name libchipcard2
%define version 1.9.15beta
%define rpm_cxxflags \"-O2 -march=i486 -mcpu=i586\"
%define rpm_cflags \"-O2 -march=i486 -mcpu=i586\"

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")

# Note: There is not yet a special symbol for the rpm release
# version. We set it to one here.
%define release 1.%{disttag}%{distver}

Summary: A library for easy access to smart cards (chipcards).
Name: %{name}
Version: %{version}
Release: %{release}
Source: http://download.sourceforge.net/libchipcard/%{name}-%{version}.tar.gz
Requires: gwenhywfar
Group: Libraries/System
Copyright: GPL
Packager: Martin Preuss <martin@libchipcard.de>
URL: http://www.libchipcard.de
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: /sbin/ldconfig
Prefix: %{_prefix}
BuildRequires: gwenhywfar-devel >= 1.15.0
Provides: aqhbci-ddvcard

%description
Libchipcard allows easy access to smart cards. It provides basic access
to memory and processor cards and has special support for German medical
cards, German "Geldkarten" and HBCI (homebanking) cards (both type 0 and 
type 1).
It accesses the readers via CTAPI or PC/SC interfaces and has successfully
been tested with Towitoko, Kobil and Reiner-SCT readers.
This package contains the chipcard2-daemon needed to access card readers.

%package devel
Summary: LibChipCard server development kit
Group: Development/Libraries
%description devel
This package contains chipcard2-server-config and header files for writing 
drivers, services or even your own chipcard daemon for LibChipCard.


%prep
%setup -q

%build
%{configure}
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir} make DESTDIR=$RPM_BUILD_ROOT \
  install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root,0755)
%doc README COPYING ChangeLog
%{_libdir}/*.so
%{_libdir}/*.so.*
%{_libdir}/chipcard2-server
%{_libdir}/gwenhywfar/plugins
%{_sysconfdir}/chipcard2-client
%{_sysconfdir}/chipcard2-server
%{_bindir}/cardcommander2
%{_bindir}/chipcard-tool
%{_bindir}/geldkarte2
%{_bindir}/kvkcard2
%{_bindir}/memcard2
%{_bindir}/rsacard2
%{_sbindir}/chipcardd2
%{_sbindir}/chipcardrd

%files devel
%defattr(-,root,root,0755)
%doc README COPYING ChangeLog
%{_bindir}/chipcard2-server-config
%{_bindir}/chipcard2-client-config
%{_includedir}/*
%{_libdir}/*.*a
%{_datadir}/aclocal/chipcard2-server.m4
%{_datadir}/aclocal/chipcard2-client.m4


%changelog

