/***************************************************************************
 $RCSfile: chipcard2.h.in,v $
                             -------------------
    cvs         : $Id: chipcard2.h.in,v 1.4 2005/08/04 05:02:32 aquamaniac Exp $
    begin       : Tue Dec 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef CHIPCARD_CHIPCARD2_H
#define CHIPCARD_CHIPCARD2_H

#ifdef __declspec
# if BUILDING_LIBCHIPCARD2_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* BUILDING_LIBCHIPCARD2_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_LIBCHIPCARD2_DLL */
#else
# define CHIPCARD_API
#endif

#ifndef CHIPCARD_NOWARN_DEPRECATED
# ifdef __GNUC__
#  define CHIPCARD_DEPRECATED __attribute((__deprecated__))
# else
#  define CHIPCARD_DEPRECATED
# endif
# else
#  define CHIPCARD_DEPRECATED
#endif


/* APIDOC stuff for Doxygen */
/** @defgroup MOD_TUTORIALS Tutorials */


#define LC_DEFAULT_PORT 7392 /* FIXME: make this adjustable by configure */
#define LC_DEFAULT_UDS_SOCK "/var/run/chipcard2d.sock"

#define LC_ERROR_NONE               0x00000000
#define LC_ERROR_GENERIC            0x00000001
#define LC_ERROR_INVALID            0x00000002
#define LC_ERROR_CARD_REMOVED       0x00000003
#define LC_ERROR_CARD_NOT_OWNED     0x00000004
#define LC_ERROR_NOT_SUPPORTED      0x00000005
#define LC_ERROR_SETUP              0x00000006
#define LC_ERROR_NO_DATA            0x00000007

#define LC_LOGDOMAIN "ccclient"

/** Reader flags */
#define LC_READER_FLAGS_KEYPAD  0x00010000
#define LC_READER_FLAGS_DISPLAY 0x00020000
#define LC_READER_FLAGS_NOINFO  0x00040000
#define LC_READER_FLAGS_REMOTE  0x00080000
#define LC_READER_FLAGS_AUTO    0x00100000


#endif /* CHIPCARD_CHIPCARD2_H */
