#include "ws.h"
#include "node.h"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#define CM_TYPE_DRAWABLE_NODE            (cm_drawable_node_get_type ())
#define CM_DRAWABLE_NODE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_DRAWABLE_NODE, CmDrawableNode))
#define CM_DRAWABLE_NODE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_DRAWABLE_NODE, CmDrawableNodeClass))
#define CM_IS_DRAWABLE_NODE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_DRAWABLE_NODE))
#define CM_IS_DRAWABLE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_DRAWABLE_NODE))
#define CM_DRAWABLE_NODE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_DRAWABLE_NODE, CmDrawableNodeClass))
	    
typedef struct _CmDrawableNode CmDrawableNode;
typedef struct _CmDrawableNodeClass CmDrawableNodeClass;
typedef void (*DrawableDamageFunc)      (CmDrawableNode *node,
					 gpointer      data);

typedef void (*CmDeformFunc) (int u, int v,
			      int x, int y, int width, int height,
			      int *deformed_x, int *deformed_y,
			      void *p);


typedef struct _CmPoint CmPoint;
struct _CmPoint
{
  double x, y;
};

struct _CmDrawableNode
{
    CmNode			parent_instance;
    
    WsDrawable *		drawable;
    WsPixmap *			pixmap;
    
    gboolean			viewable;
    
    CmDeformFunc		deform_func;
    gpointer			deform_data;
    
    GTimer *			timer;
    
    int				real_x;
    int				real_y;
    int				real_width;
    int				real_height;

    DrawableDamageFunc	damage_func;
    gpointer		damage_data;

    double			alpha;
    
    double			user_x;
    double			user_y;
    double			user_width;
    double			user_height;

    CmPoint                     patch_points[4][4];
};

struct _CmDrawableNodeClass
{
    CmNodeClass parent_class;
};

void
cm_identity_deform (int u, int v,
		    int x, int y, int width, int height,
		    int *deformed_x, int *deformed_y,
		    void *p);

void
cm_user_geometry_deform (int u, int v,
			 int x, int y, int width, int height,
			 int *deformed_x, int *deformed_y,
			 void *p);

void
cm_wavy_deform (int u, int v,
		int x, int y, int width, int height,
		int *deformed_x, int *deformed_y,
		void *p);

void
cm_patch_deform (int u, int v,
		 int x, int y, int width, int height,
		 int *deformed_x, int *deformed_y,
		 void *p);

GType cm_drawable_node_get_type (void);

CmDrawableNode *cm_drawable_node_new (WsDrawable *drawable);
void	      cm_drawable_node_set_viewable (CmDrawableNode *node,
					     gboolean viewable);

/* Called whenever the drawable is damaged */
void	      cm_drawable_node_set_damage_func (CmDrawableNode *node,
						DrawableDamageFunc cb,
						gpointer data);
/* This function must be called whenever the named pixmap becomes state
 * (and you want to make it non-stale. Ie., after map/unmap and configure
 * notify. 
 *
 * (DrawableNode doesn't do this automatically, since you might want to
 *  do stuff with the stale pixmap, such as fading it out).
 */
void cm_drawable_node_set_geometry (CmDrawableNode *node,
				    double x,
				    double y,
				    double width,
				    double height);
void cm_drawable_node_set_patch (CmDrawableNode *node,
				 CmPoint points[][4]);
void cm_drawable_node_set_alpha (CmDrawableNode *node,
				 double alpha);
void cm_drawable_node_update_pixmap (CmDrawableNode *node);

