#include "ws.h"
#include "wsint.h"

#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xcomposite.h>
#include <X11/extensions/Xdamage.h>

G_DEFINE_TYPE (WsScreen, ws_screen, G_TYPE_OBJECT);

static void
ws_screen_finalize (GObject *object)
{
    G_OBJECT_CLASS (ws_screen_parent_class)->finalize (object);
}

static void
ws_screen_class_init (WsScreenClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    object_class->finalize = ws_screen_finalize;
}

static void
ws_screen_init (WsScreen *screen)
{
    
}

WsWindow *
ws_screen_get_gl_window (WsScreen *screen)
{
    if (!screen->gl_window)
    {
	int attrib[] = { GLX_RGBA,
			 GLX_RED_SIZE, 0,
			 GLX_GREEN_SIZE, 0,
			 GLX_BLUE_SIZE, 0,
			 GLX_DOUBLEBUFFER,
			 GLX_DEPTH_SIZE, 4,
			 None };
	XVisualInfo *visinfo;
	Display *xdisplay = screen->display->xdisplay;
	GLXContext context;
	XSetWindowAttributes attr;
	WsRegion *region;
	Window xwindow;
	Window xroot;
	
	visinfo = glXChooseVisual (
	    xdisplay, ws_screen_get_number (screen), attrib);
	
	/* FIXME: report an error instead of asserting */
	g_assert (visinfo);
	
	context = glXCreateContext (xdisplay, visinfo, NULL, True);
	
	/* FIXME: report an error instead of asserting */
	g_assert (context);

	xroot = WS_RESOURCE_XID (ws_screen_get_root_window (screen));
	
	attr.colormap = XCreateColormap (
	    xdisplay, xroot,
	    visinfo->visual, AllocNone);

	g_print ("depth: %d\n", visinfo->depth);
	
	xwindow = XCreateWindow (xdisplay, xroot,
				 0, 0,
				 screen->xscreen->width,
				 screen->xscreen->height, 0,
				 visinfo->depth, InputOutput, visinfo->visual,
				 CWColormap, &attr);
	
	glXMakeCurrent (xdisplay, xwindow, context);
	
	XSelectInput (xdisplay, xwindow, ExposureMask | PointerMotionMask);
	
	region = ws_region_new (screen->display);
	
	screen->gl_window = _ws_window_ensure (screen->display,
					       xwindow);
	
	ws_window_set_input_shape (screen->gl_window, region);
	
	g_object_unref (G_OBJECT (region));
    }
    
    return screen->gl_window;
}    

WsScreen *
_ws_screen_new (WsDisplay *display,
		Screen    *xscreen)
{
    WsScreen *screen = g_object_new (WS_TYPE_SCREEN, NULL);
    
    screen->display = display;
    screen->xscreen = xscreen;
    
    return screen;
}

WsWindow *
ws_screen_get_root_window (WsScreen *screen)
{
    Window root = RootWindowOfScreen (screen->xscreen);
    
    return _ws_window_ensure (screen->display, root);
}

int
ws_screen_get_number (WsScreen *screen)
{
    int i;
    
    g_return_val_if_fail (screen != NULL, -1);
    
    for (i = 0; i < screen->display->n_screens; ++i)
	if (screen->display->screens[i] == screen)
	    return i;
    
    return -1;
}

void
ws_screen_graphics_sync (WsScreen *screen)
{
    WsWindow *root = ws_screen_get_root_window (screen);
    XImage *tmp_image;
    
    tmp_image = XGetImage (WS_RESOURCE_XDISPLAY (screen),
			   WS_RESOURCE_XID (root),
			   0, 0, 1, 1, (unsigned)-1, ZPixmap);
    
    XDestroyImage (tmp_image);
}

gint
ws_screen_get_width (WsScreen *screen)
{
    return screen->xscreen->width;
}

gint
ws_screen_get_height (WsScreen *screen)
{
    return screen->xscreen->height;
}

