/*
* Copyright (c) 2006 Rudi Cilibrasi, Rulers of the RHouse
* All rights reserved.     cilibrar@cilibrar.com
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the RHouse nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE RULERS AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __COMPADAPTOR_H
#define __COMPADAPTOR_H

struct StringWithDistance {
  const char *str;
  double distance;
};

struct SearchSettings {
  int minTermLength;  // 3
  int maxTerms;       // 10
  int maxChars;       // 80
  double fullStringWeighting; // 0.25, single term is 1-this
  double substringBenefit;  // 0.25 bonus for exact substring match
  double exactBenefit;  // 0.25 bonus for exact string match of "word"
  char transTable[256]; // translate char x to transTable[x] for each char
  char wordChar[256];  // words are grouped into chars x where wordChar[x] != 0
};

struct SearchSettings *clSearchSettingsFoldCase(void);
struct SearchSettings *clSearchSettingsKeepCase(void);

int clFindClosestMatchCB(struct CompressionBase *cb, struct SearchSettings *sparm, char *target,  char **str, int count, struct StringWithDistance *res);

#endif

