# -*- cperl -*-

use ExtUtils::testlib;
use Test::More ;
use Test::Memory::Cycle;
use Test::Differences;
use Config::Model ;
use Config::Model::Value ;
use Log::Log4perl qw(:easy) ;
use File::Path ;
use File::Copy ;
use Test::Warn ;
use Path::Tiny;
use 5.10.0;

use warnings;
use strict;

my $arg = shift || '';
my $log = 0;

my $trace = $arg =~ /t/ ? 1 : 0 ;
$log                = 1 if $arg =~ /l/;
Config::Model::Exception::Any->Trace(1) if $arg =~ /e/;

use Log::Log4perl qw(:easy) ;
my $home = $ENV{HOME} || "";
my $log4perl_user_conf_file = "$home/.log4config-model";

if ($log and -e $log4perl_user_conf_file ) {
    Log::Log4perl::init($log4perl_user_conf_file);
}
else {
    Log::Log4perl->easy_init($ERROR);
}

my $model = Config::Model -> new ( ) ;

ok(1,"compiled");

# pseudo root where config files are written by config-model
my $wr_root = path('wr_root');

# cleanup before tests
$wr_root->remove_tree( { safe => 0 } );
$wr_root->mkpath ( { mode => 0755 }) ;

my $wr_dir = $wr_root->child('test') ;
$wr_dir->child("debian")->mkpath( { mode => 0755 }) ;

# instance to check one dependency at a time
my $unit = $model->instance (
    root_class_name => 'Dpkg::Copyright',
    root_dir        => $wr_dir->stringify,
    # skip_read       => 1,
    instance_name   => "unittest",
)->config_root;

is($unit->instance->initial_load,0,"initial load is done");

my $pan = path('t/scanner/examples/pan.in') ;
$unit->update(in => $pan);

my $gpl_text = $unit->grab("License:GPL-2 text");

# should be undef
my $default = $gpl_text->fetch() ;
like($default,qr/GNU/,"check license text brought by Software::License");
is($gpl_text->fetch(mode => 'custom'),undef,'check lic text');
is($gpl_text->fetch_custom,undef,'check lic text');

# store identical text
$unit->instance->initial_load_start;
$gpl_text->store($default);
$unit->instance->initial_load_stop;
# custom text should still be undef
is($gpl_text->fetch_custom,undef,'check lic text');

# re-test with a debian/pan.copyright-tweak file
# re-check som

memory_cycle_ok($model, "memory cycles");

done_testing;
