/*--------------------------------------------------------------------------+
$Id: DateUtils.java 29593 2010-08-09 16:01:20Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.date;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;

/**
 * Utility methods for working on date objects.
 * 
 * @author juergens
 * @author $Author: hummelb $
 * @version $Rev: 29593 $
 * @levd.rating GREEN Hash: A327B6CB6CF8E826F60F8D16EBA23DEC
 */
public class DateUtils {

	/** Returns the latest date in a collection of dates */
	public static Date getLatest(Collection<Date> dates) {
		if (dates.isEmpty()) {
			return null;
		}
		return Collections.max(dates);
	}

	/** Returns the earliest date in a collection of dates */
	public static Date getEarliest(Collection<Date> dates) {
		if (dates.isEmpty()) {
			return null;
		}
		return Collections.min(dates);
	}

	/** Returns the earlier of two dates, or null, if one of the dates is null */
	public static Date min(Date d1, Date d2) {
		if (d1 == null || d2 == null) {
			return null;
		}

		if (d1.compareTo(d2) < 0) {
			return d1;
		}
		return d2;
	}

	/** Returns the later of two dates or null, if one of the dates is null. */
	public static Date max(Date d1, Date d2) {
		if (d1 == null || d2 == null) {
			return null;
		}

		if (d2.compareTo(d1) > 0) {
			return d2;
		}
		return d1;
	}

}