/*--------------------------------------------------------------------------+
$Id: FilenameComparator.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.File;
import java.util.Comparator;

/**
 * Compares files based on the lexical order of their fully qualified names.
 * Files must not be null.
 * 
 * @author juergens
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 58C92A2D888E51D9684AE5394A7D3FDF
 */
public class FilenameComparator implements Comparator<File> {

	/** {@inheritDoc} */
	public int compare(File file1, File file2) {
		if (file1 == null || file2 == null) {
			throw new IllegalArgumentException("Files must not be null");
		}

		return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
	}

}