/*--------------------------------------------------------------------------+
$Id: EAggregationStrategy.java 27961 2010-05-28 11:26:40Z deissenb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.math;

/**
 * Enumeration for different aggregation strategies.
 * 
 * @author deissenb
 * @author $Author: deissenb $
 * @version $Rev: 27961 $
 * @levd.rating GREEN Hash: C8D121A18760092443B22D4224237E46
 */
public enum EAggregationStrategy {
	/** Sum aggregation, see {@link SumAggregator}. */
	SUM(new SumAggregator()),

	/** Maximum aggregation, see {@link MaxAggregator}. */
	MAX(new MaxAggregator()),

	/** Minimum aggregation, see {@link MinAggregator}. */
	MIN(new MinAggregator()),

	/** Mean aggregation, see {@link MeanAggregator}. */
	MEAN(new MeanAggregator()),

	/** Median aggregation, see {@link MedianAggregator}. */
	MEDIAN(new MedianAggregator());

	/** The aggregator used fro this strategy. */
	private final IAggregator aggregator;

	/** Create strategy. */
	private EAggregationStrategy(IAggregator aggregator) {
		this.aggregator = aggregator;
	}

	/** Get aggregator. */
	public IAggregator getAggregator() {
		return aggregator;
	}
}