/*--------------------------------------------------------------------------+
$Id: ConstantNamespaceContext.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml;

import java.util.Iterator;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;

/**
 * A minimalistic implementation of {@link NamespaceContext} to be used with
 * {@link XPath}. Method {@link #getNamespaceURI(String)} always returns the
 * string provided to the constructor. All other methods throw
 * {@link UnsupportedOperationException}s. These methods are not needed for
 * XPath resolution.
 * <p>
 * Implementation is inspired by snippet on <a
 * href="http://www.ibm.com/developerworks/library/x-javaxpathapi.html">http://www.ibm.com/developerworks/library/x-javaxpathapi.html</a>.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: E9195A8DBCE2646387CB5388F9C332D6
 */
public class ConstantNamespaceContext implements NamespaceContext {

	/** The URI */
	private final String namesspaceURI;

	/** Create new context. */
	public ConstantNamespaceContext(String namesspaceURI) {
		this.namesspaceURI = namesspaceURI;
	}

	/**
	 * Always returns the string provided to the constructor.
	 */
	public String getNamespaceURI(String prefix) {
		return namesspaceURI;
	}

	/**
	 * Throws {@link UnsupportedOperationException}. This method isn't
	 * necessary for XPath processing.
	 */
	public String getPrefix(String uri) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Throws {@link UnsupportedOperationException}. This method isn't
	 * necessary for XPath processing.
	 */
	@SuppressWarnings("unchecked")
	public Iterator getPrefixes(String uri) {
		throw new UnsupportedOperationException();
	}

}