/*--------------------------------------------------------------------------+
$Id: SortedCounterSetTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import junit.framework.TestCase;

/**
 * JUnit test for <code>OrderedCounterArray</code> class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 6FACDAA85290A8C8997320D333FE3638
 */
public class SortedCounterSetTest extends TestCase {

	/** Array under test. */
	private final SortedCounterSet<Integer> array = new SortedCounterSet<Integer>();

	/**
	 * Set up test fixture.
	 */
	@Override
	public void setUp() {
		array.inc(1, 1);
		array.inc(3, 1);
		array.inc(5, 1);
		array.inc(7, 1);
		array.inc(9, 1);
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray. getRangeSum()'
	 */
	public void testGetRangeSum() {

		// proper range
		int sum = array.getRangeSum(3, 7);
		assertEquals(3, sum);

		// single elemet
		sum = array.getRangeSum(3, 3);
		assertEquals(1, sum);

		// non-present first element
		sum = array.getRangeSum(-1, 5);
		assertEquals(3, sum);

		// non-present last element
		sum = array.getRangeSum(3, 100);
		assertEquals(4, sum);

		// non-present first and last element
		sum = array.getRangeSum(-1, 100);
		assertEquals(5, sum);

		// last element is not present but smaller than greatest
		sum = array.getRangeSum(3, 8);
		assertEquals(3, sum);

		// first element is not present but greater than samllest
		sum = array.getRangeSum(2, 9);
		assertEquals(4, sum);

		// single element which ist not stored
		sum = array.getRangeSum(2, 2);
		assertEquals(0, sum);
	}
}