/*--------------------------------------------------------------------------+
$Id: RegionTest.java 27314 2010-03-31 07:06:11Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.region;

import edu.tum.cs.commons.region.Region;
import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link Region}
 * 
 * @author juergens
 * @author $Author: juergens $
 * @version $Rev: 27314 $
 * @levd.rating GREEN Hash: D43D34222AEA256BE295CF7FF99E5B4A
 */
public class RegionTest extends CCSMTestCaseBase {

	/** Tests {@link Region#adjacent(Region)} */
	public void testAdjacent() {
		Region r1 = new Region(2, 6, null);
		Region r2 = new Region(7, 9, null);
		Region r3 = new Region(11, 12, null);

		assertTrue(r1.adjacent(r2));
		assertTrue(r2.adjacent(r1));

		assertFalse(r1.adjacent(r3));
		assertFalse(r3.adjacent(r1));
	}

	/** Tests {@link Region#overlaps(Region)} */
	public void testOverlaps() {
		Region r1 = new Region(2, 6, null);
		Region r2 = new Region(7, 9, null);
		Region r3 = new Region(3, 4, null);
		Region r4 = new Region(3, 8, null);

		assertTrue(r1.overlaps(r3));
		assertTrue(r1.overlaps(r4));
		assertTrue(r3.overlaps(r4));
		assertTrue(r2.overlaps(r4));

		assertTrue(r3.overlaps(r1));
		assertTrue(r4.overlaps(r1));
		assertTrue(r4.overlaps(r3));
		assertTrue(r4.overlaps(r2));

		assertFalse(r1.overlaps(r2));
	}

}