/*--------------------------------------------------------------------------+
$Id: SmokeTest.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.targetlink;

import java.io.File;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import edu.tum.cs.commons.filesystem.FileExtensionFilter;
import edu.tum.cs.commons.filesystem.FileSystemUtils;

/**
 * The smoke test suite inspects this package's test data directory. For each
 * MDL file the test defined in {@link MDLSmokeTestlet} is executed. For each
 * TXT file the test defined in {@link TXTSmokeTestlet} is executed.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: E40AEDA8BB284D3A70B79A7CD7204462
 */
public class SmokeTest {

	/**
	 * Create a smoke test suite.
	 */
	public static Test suite() {

		File dir = new File("test-data/"
				+ SmokeTest.class.getPackage().getName());

		List<File> mdlFiles = FileSystemUtils.listFilesRecursively(dir,
				new FileExtensionFilter("mdl"));

		List<File> txtFiles = FileSystemUtils.listFilesRecursively(dir,
				new FileExtensionFilter("txt"));

		TestSuite suite = new TestSuite("SmokeTest");
		suite.setName("Smoke Test [" + (mdlFiles.size() + txtFiles.size())
				+ " test files]");
		for (File file : mdlFiles) {
			suite.addTest(new MDLSmokeTestlet(file.getName()));
		}

		for (File file : txtFiles) {
			suite.addTest(new TXTSmokeTestlet(file.getName()));
		}
		return suite;
	}
}