/* 
 * $Id: ctknotebook.h,v 1.11 2000/07/13 01:02:49 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKNOTEBOOK_H__
#define __CTKNOTEBOOK_H__

typedef struct CtkNotebookTab_S
{
	CtkWidget* page;
	CtkWidget* label;
	gboolean selected;
} CtkNotebookTab;

struct CtkNotebook_S
{	
	CtkContainer container;
	
	CtkPositionType tab_pos;
	
	gint tab_width;
	gint tab_height;
	gint tab_row;
	gint tab_col;
	
	gint page_width;
	gint page_height;
	gint page_row;
	gint page_col;
	
	GSList* tab_labels;
	gboolean show_tabs;
};

typedef struct CtkNotebook_S CtkNotebook;

CtkWidget *ctk_notebook_new();
void ctk_notebook_set_tab_label(CtkNotebook *notebook,
				CtkWidget *child,
				CtkWidget *tab_label);
void ctk_notebook_set_page(CtkNotebook *notebook, gint page_num);
gint ctk_notebook_page_num(CtkNotebook *notebook, CtkWidget *child);
CtkWidget* ctk_notebook_get_nth_page(CtkNotebook* notebook, gint page_num);
void ctk_notebook_next_page(CtkNotebook *notebook);
void ctk_notebook_prev_page(CtkNotebook *notebook);
void ctk_notebook_set_tab_pos(CtkNotebook *notebook, CtkPositionType pos);
void ctk_notebook_append_page(CtkNotebook *notebook, CtkWidget *child, 
			      CtkWidget *tab_label);
void ctk_notebook_prepend_page(CtkNotebook *notebook, CtkWidget *child, 
			      CtkWidget *tab_label);
void ctk_notebook_insert_page(CtkNotebook *notebook, CtkWidget *child,
			      CtkWidget *tab_label, gint position);
void ctk_notebook_remove_page(CtkNotebook *notebook, gint page_num);
void ctk_notebook_set_show_tabs(CtkNotebook *notebook, gboolean show_tabs);
void ctk_notebook_set_show_border(CtkNotebook *notebook, gboolean show_border);

#define CTK_NOTEBOOK(obj)	CTK_CHECK_CAST((obj),CtkNotebook,CtkTypeNotebook)

void ctk_notebook_set_default_child_flags(CtkContainer* container, CtkWidget* child);
void ctk_notebook_lost_child(CtkContainer* container, CtkWidget* child);

void ctk_notebook_min_size (CtkWidget* widget);
void ctk_notebook_real_size(CtkWidget* widget);

void ctk_notebook_set_scrollable(CtkNotebook* notebook, gboolean scrollable);

#endif
