// $Header: /cvsroot/libcwd/libcwd/strerrno.cc,v 1.11 2004/05/27 03:03:44 libcw Exp $
//
// Copyright (C) 2000 - 2003, by
// 
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This file may be distributed under the terms of the Q Public License
// version 1.0 as appearing in the file LICENSE.QPL included in the
// packaging of this file.
//

#include "sys.h"
#include <libcwd/config.h>
#include <libcwd/strerrno.h>

namespace libcwd {

  namespace {

  // {anonymous}::
  char const* const strerrno_table_c[] = {
	  "0",		/* No error */
	  "EPERM",		/* Operation not permitted */
	  "ENOENT",		/* No such file or directory */
	  "ESRCH",		/* No such process */
	  "EINTR",		/* Interrupted system call */
	  "EIO",		/* I/O error */
	  "ENXIO",		/* No such device or address */
	  "E2BIG",		/* Arg list too long */
	  "ENOEXEC",		/* Exec format error */
	  "EBADF",		/* Bad file number */
	  "ECHILD",		/* No child processes */
	  "EAGAIN",		/* Try again */
	  "ENOMEM",		/* Out of memory */
	  "EACCES",		/* Permission denied */
	  "EFAULT",		/* Bad address */
	  "ENOTBLK",		/* Block device required */
	  "EBUSY",		/* Device or resource busy */
	  "EEXIST",		/* File exists */
	  "EXDEV",		/* Cross-device link */
	  "ENODEV",		/* No such device */
	  "ENOTDIR",		/* Not a directory */
	  "EISDIR",		/* Is a directory */
	  "EINVAL",		/* Invalid argument */
	  "ENFILE",		/* File table overflow */
	  "EMFILE",		/* Too many open files */
	  "ENOTTY",		/* Not a typewriter */
	  "ETXTBSY",		/* Text file busy */
	  "EFBIG",		/* File too large */
	  "ENOSPC",		/* No space left on device */
	  "ESPIPE",		/* Illegal seek */
	  "EROFS",		/* Read-only file system */
	  "EMLINK",		/* Too many links */
	  "EPIPE",		/* Broken pipe */
	  "EDOM",		/* Math argument out of domain of func */
	  "ERANGE",		/* Math result not representable */
	  "EDEADLK",		/* Resource deadlock would occur */
	  "ENAMETOOLONG",	/* File name too long */
	  "ENOLCK",		/* No record locks available */
	  "ENOSYS",		/* Function not implemented */
	  "ENOTEMPTY",	/* Directory not empty */
	  "ELOOP",		/* Too many symbolic links encountered */
	  "EWOULDBLOCK",	/* Operation would block */
	  "ENOMSG",		/* No message of desired type */
	  "EIDRM",		/* Identifier removed */
	  "ECHRNG",		/* Channel number out of range */
	  "EL2NSYNC",		/* Level 2 not synchronized */
	  "EL3HLT",		/* Level 3 halted */
	  "EL3RST",		/* Level 3 reset */
	  "ELNRNG",		/* Link number out of range */
	  "EUNATCH",		/* Protocol driver not attached */
	  "ENOCSI",		/* No CSI structure available */
	  "EL2HLT",		/* Level 2 halted */
	  "EBADE",		/* Invalid exchange */
	  "EBADR",		/* Invalid request descriptor */
	  "EXFULL",		/* Exchange full */
	  "ENOANO",		/* No anode */
	  "EBADRQC",		/* Invalid request code */
	  "EBADSLT",		/* Invalid slot */
	  "EDEADLOCK",
	  "EBFONT",		/* Bad font file format */
	  "ENOSTR",		/* Device not a stream */
	  "ENODATA",		/* No data available */
	  "ETIME",		/* Timer expired */
	  "ENOSR",		/* Out of streams resources */
	  "ENONET",		/* Machine is not on the network */
	  "ENOPKG",		/* Package not installed */
	  "EREMOTE",		/* Object is remote */
	  "ENOLINK",		/* Link has been severed */
	  "EADV",		/* Advertise error */
	  "ESRMNT",		/* Srmount error */
	  "ECOMM",		/* Communication error on send */
	  "EPROTO",		/* Protocol error */
	  "EMULTIHOP",	/* Multihop attempted */
	  "EDOTDOT",		/* RFS specific error */
	  "EBADMSG",		/* Not a data message */
	  "EOVERFLOW",	/* Value too large for defined data type */
	  "ENOTUNIQ",		/* Name not unique on network */
	  "EBADFD",		/* File descriptor in bad state */
	  "EREMCHG",		/* Remote address changed */
	  "ELIBACC",		/* Can not access a needed shared library */
	  "ELIBBAD",		/* Accessing a corrupted shared library */
	  "ELIBSCN",		/* .lib section in a.out corrupted */
	  "ELIBMAX",		/* Attempting to link in too many shared libraries */
	  "ELIBEXEC",		/* Cannot exec a shared library directly */
	  "EILSEQ",		/* Illegal byte sequence */
	  "ERESTART",		/* Interrupted system call should be restarted */
	  "ESTRPIPE",		/* Streams pipe error */
	  "EUSERS",		/* Too many users */
	  "ENOTSOCK",		/* Socket operation on non-socket */
	  "EDESTADDRREQ",	/* Destination address required */
	  "EMSGSIZE",		/* Message too long */
	  "EPROTOTYPE",	/* Protocol wrong type for socket */
	  "ENOPROTOOPT",	/* Protocol not available */
	  "EPROTONOSUPPORT",	/* Protocol not supported */
	  "ESOCKTNOSUPPORT",	/* Socket type not supported */
	  "EOPNOTSUPP",	/* Operation not supported on transport endpoint */
	  "EPFNOSUPPORT",	/* Protocol family not supported */
	  "EAFNOSUPPORT",	/* Address family not supported by protocol */
	  "EADDRINUSE",	/* Address already in use */
	  "EADDRNOTAVAIL",	/* Cannot assign requested address */
	  "ENETDOWN",		/* Network is down */
	  "ENETUNREACH",	/* Network is unreachable */
	  "ENETRESET",	/* Network dropped connection because of reset */
	  "ECONNABORTED",	/* Software caused connection abort */
	  "ECONNRESET",	/* Connection reset by peer */
	  "ENOBUFS",		/* No buffer space available */
	  "EISCONN",		/* Transport endpoint is already connected */
	  "ENOTCONN",		/* Transport endpoint is not connected */
	  "ESHUTDOWN",	/* Cannot send after transport endpoint shutdown */
	  "ETOOMANYREFS",	/* Too many references: cannot splice */
	  "ETIMEDOUT",	/* Connection timed out */
	  "ECONNREFUSED",	/* Connection refused */
	  "EHOSTDOWN",	/* Host is down */
	  "EHOSTUNREACH",	/* No route to host */
	  "EALREADY",		/* Operation already in progress */
	  "EINPROGRESS",	/* Operation now in progress */
	  "ESTALE",		/* Stale NFS file handle */
	  "EUCLEAN",		/* Structure needs cleaning */
	  "ENOTNAM",		/* Not a XENIX named type file */
	  "ENAVAIL",		/* No XENIX semaphores available */
	  "EISNAM",		/* Is a named type file */
	  "EREMOTEIO",	/* Remote I/O error */
	  "EDQUOT"		/* Quota exceeded */
  };

  } // namespace {anonymous}

    /**
     * \brief Returns a pointer to a string literal that contains the usual macro name of \a err.
     *
     * For example, <code>strerrno(EAGAIN)</code> returns <code>"EAGAIN"</code>.&nbsp;
     * When \p err is unknown then the string <code>"UNKNOWN ERROR"</code> is returned.
     */
    char const* strerrno(unsigned int err)
    {
      if (err >= (sizeof(strerrno_table_c) / sizeof(char const*)))
	return "UNKNOWN ERROR";
      return strerrno_table_c[err];
    }

} // namespace libcwd
