/***************************************************************************
                          cclient.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>

#ifndef WIN32
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/clist.h>
#include <dclib/dcobject.h>
#include <dclib/cquerymanager.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cconnectionmanager.h>
#include <dclib/cencrypt.h>
#include <dclib/cmessagehandler.h>
#include <dclib/core/cstringlist.h>
#include <dclib/cconfig.h>
#include <dclib/csearchmanager.h>

#include "cclient.h"

CClient::CClient()
{
	m_pCallback = 0;
	
	m_sBuffer          = "";
	m_sHubName         = "";
	m_sHubTopic        = "";
	m_sVersion         = "";
	m_bHandshake       = TRUE;
	m_bHandleUserList  = TRUE;
	m_bHandleSearch    = TRUE;
	m_bHandleMyinfo    = TRUE;
	m_bHandleForceMove = TRUE;
	m_bHandleTransfer  = TRUE;
	m_bUpdateMyinfo    = FALSE;
	m_bSendMyinfo      = TRUE;
	m_bSSLMode         = FALSE;
	m_nNickListHandler = 0;
	m_nOpListHandler   = 0;
	m_bUsedPassword    = FALSE;

	// set reconnect parameter
	m_eReconnectState      = ersNONE;
	m_nReconnectCount      = 0;
	m_timeReconnectTimeout = 0;
	m_timeMyinfoTimeout    = 0;
}

CClient::~CClient()
{
	SetCallBackFunction(0);
}

/** */
void CClient::ConnectionState( eConnectionState state )
{
	int err = -1;

	CMessageConnectionState *Object = new CMessageConnectionState();

	if (!Object)
	{
		return;
	}

	if ( (state == estCONNECTED) ||
	     (state == estDISCONNECTED) )
	{
		// reset all values
		m_sBuffer           = "";
		m_bHandshake        = TRUE;
		m_timeMyinfoTimeout = time(0);
		m_nNickListHandler  = 0;
		m_nOpListHandler    = 0;

		m_UserList.Clear();
#ifdef HAVE_SSL
		m_pMessageSSL.Init();
#endif
		// update reconnect state
		if ( state == estCONNECTED )
		{
			UpdateReconnect( ersNONE );

			if ( m_bSSLMode == TRUE )
			{
				if ( ChangeSocketMode(esmSSLCLIENT) == FALSE )
				{
					printf("change ssl mode failed\n");
				}
			}
		}
		else
		{
			if ( m_eReconnectState == ersFORCEMOVE )
			{
				UpdateReconnect( ersNONE );
			}
			else
			{
				UpdateReconnect( ersENABLED );
			}
		}
	}

	Object->m_eState   = state;
	Object->m_sMessage = GetSocketError();

	if ( m_pCallback != 0 )
	{
		err = m_pCallback->notify( this, Object );
	}
	else
	{
		err = DC_CallBack( Object );
	}

	// callback failed
	if ( err == -1 )
	{
		delete Object;
	}

	// update myinfo
	if ( m_bHandleMyinfo && CConnectionManager::Instance() )
	{
		CConnectionManager::Instance()->SendMyInfoToConnectedServers();
	}
}

/** */
void CClient::DataAvailable( const char * buffer, int len )
{
	CString s;
	int i;

	if ( len <= 0 )
	{
		return;
	}

	// add traffic control
	CSocket::m_Traffic.AddTraffic(ettCONTROLRX,len);

	i = 0;

	s = m_sBuffer + CString().Set(buffer,len);

	// search last '|'
	i = s.FindRev('|');
	i++;

	if ( i > 0 )
	{
		m_sBuffer = s.Mid(0,i);
		HandleMessage( m_sBuffer );
	}

	if ( i == s.Length() )
	{
		m_sBuffer = "";
	}
	else
	{
		m_sBuffer = s.Mid( i, s.Length()-i );
	}
}

/** */
void CClient::DataTimeout()
{
	SendString("|");
}

/** */
void CClient::Notify()
{
	if ( !CConfig::Instance() )
		return;

	// check away mode
	if ( (m_bHandshake == FALSE) && ((time(0)-m_timeMyinfoTimeout) >= 30) )
	{
		if ( CConfig::Instance()->GetAwayMode() != m_MyInfo.m_eAwayMode)
		{
			m_MyInfo.m_eAwayMode = CConfig::Instance()->GetAwayMode();
			m_bUpdateMyinfo = TRUE;
		}
	}

	if ( (m_bHandshake == FALSE) && (m_bUpdateMyinfo == TRUE) && ((time(0)-m_timeMyinfoTimeout) >= 30) )
	{
		m_bUpdateMyinfo     = FALSE;
		m_timeMyinfoTimeout = time(0);

		if ( m_bSendMyinfo )
			SendMyInfo( m_MyInfo.m_sNick, m_MyInfo.m_sComment, m_MyInfo.m_sUserSpeed, m_MyInfo.m_eAwayMode, m_MyInfo.m_sEMail, CString().setNum(m_MyInfo.m_nShared) );
	}

	if ( m_eReconnectState == ersENABLED )
	{
		if ( m_nReconnectCount >= CConfig::Instance()->GetReconnectCount() )
		{
			UpdateReconnect( ersNONE, 0 );
		}
		else
		{
			if ( GetConnectionState() != estNONE )
			{
				printf("warning, wrong reconnect state, you are connected !\n");
			}

			// init timer
			if ( m_timeReconnectTimeout == 0 )
			{
				m_timeReconnectTimeout = time(0);
			}

			if ( (time(0)-m_timeReconnectTimeout) >= CConfig::Instance()->GetReconnectTimeout() )
			{
				UpdateReconnect( ersNONE );

				if ( CConfig::Instance()->GetReconnectCount() != 9999 )
				{
					m_nReconnectCount++;
				}

				Connect();
			}
		}
	}
}

/** */
void CClient::UpdateReconnect( eReconnectState state, int count )
{
	if ( !CConfig::Instance() )
		return;

	// reconnect disabled
	if ( CConfig::Instance()->GetReconnectCount() == 0 )
	{
		m_eReconnectState = ersNONE;
		return;
	}

	// don't change state if reconnect disables
	if ( (m_eReconnectState == ersDISABLED) && (state != ersNONE) )
	{
		return;
	}

	// update state
	m_eReconnectState      = state;
	// reset timeout
	m_timeReconnectTimeout = 0;
	// update counter
	if ( count != -1 )
	{
		m_nReconnectCount = count;
	}
}

/** */
int CClient::HandleMessage( const CString & message )
{
	int err;
	int pointer;
	eDCMessage type;
	CObject * Object;
	CMessageHandler MessageHandler;
	CString sAnswer,s;
	CEncrypt Encrypt;

	if ( message == "" )
	{
		return 0;
	}

	pointer = 0;

	while( (type=MessageHandler.Parse(&message,pointer,Object=0)) != DC_MESSAGE_PARSE_ERROR )
	{
		if ( !Object )
		{
			continue;
		}

		switch (type)
		{
			case DC_MESSAGE_LOCK:
			{
				CMessageLock * msg = (CMessageLock*)Object;

				// only handle the first lock in handshake mode
				if ( m_bHandshake == TRUE )
				{
					Encrypt.Encrypt(msg->m_sData,sAnswer);

					if ( msg->m_bExtProtocol == TRUE )
					{
						s = "";
#ifdef HAVE_SSL
						if ( CConfig::Instance() &&
						     (CConfig::Instance()->GetTransferCert() != "") &&
						     (CConfig::Instance()->GetTransferKey() != "") )
						{
							s += "SSL ";
						}
#endif
						// HubTopic
						s += "HubTopic ";
						// No $Hellos
						s += "NoHello ";
						// No $GetINFO
						s += "NoGetINFO ";

						if ( s != "" )
						{
							SendSupports(s);
						}
						// quicklist ??? http://forum.dcstats.net/showthread.php?s=&threadid=802
					}

					SendKey( sAnswer );

					SendValidateNick( m_MyInfo.m_sNick );
				}

				break;
			}

			case DC_MESSAGE_LOGEDIN:
			{
				// update myinfo
//				if ( m_bHandleMyinfo )
//					CConnectionManager::Instance()->SendMyInfoToConnectedServers();

				break;
			}

			case DC_MESSAGE_HUBNAME:
			{
				CMessageHubName * msg = (CMessageHubName*)Object;

				// set the old hubname in this message
				if ( GetHubName() != msg->m_sHubName )
					msg->m_sOldHubName = GetHubName();
				SetHubName(msg->m_sHubName);

				break;
			}

			case DC_MESSAGE_HUB_TOPIC:
			{
				CMessageHubTopic * msg = (CMessageHubTopic*) Object;

				SetHubTopic(msg->m_sTopic);

				break;
			}

			case DC_MESSAGE_HELLO:
			{
				CMessageHello * msg = (CMessageHello*)Object;

				if ( (msg->m_sNick == m_MyInfo.m_sNick) && (m_bHandshake == TRUE) )
				{
					SendVersion( m_sVersion );

					// get nicklist
					if ( m_bHandleUserList == TRUE )
						RequestNickList();

					if ( m_bSendMyinfo )
						SendMyInfo( m_MyInfo.m_sNick, m_MyInfo.m_sComment, m_MyInfo.m_sUserSpeed, m_MyInfo.m_eAwayMode, m_MyInfo.m_sEMail, CString().setNum(m_MyInfo.m_nShared) );

					m_bHandshake = FALSE;

					// update myinfo
					if ( m_bHandleMyinfo && CConnectionManager::Instance() )
						CConnectionManager::Instance()->SendMyInfoToConnectedServers();
				}
				else if ( m_bHandleUserList == TRUE )
				{
					if ( (m_UserList.AppendUser(msg->m_sNick) == TRUE) && (!m_bHandshake) && (m_MessageSupports.m_bNoGetInfo == FALSE) )
						SendGetInfo(msg->m_sNick,GetNick());
#ifdef HAVE_SSL
					m_pMessageSSL.JoinHub(this,msg->m_sNick);
#endif
				}

				break;
			}

			case DC_MESSAGE_MYINFO:
			{
				CMessageMyInfo * msg = (CMessageMyInfo*)Object;

				if( m_bHandleUserList == TRUE )
				{
					if ( m_UserList.UpdateUser(msg) == FALSE )
					{
						delete Object;
						Object = 0;
					}
				}

				break;
			}

			case DC_MESSAGE_QUIT:
			{
				CMessageQuit * msg = (CMessageQuit*)Object;

				if ( m_bHandleUserList == TRUE )
				{
					m_UserList.RemoveUser(msg->m_sNick);
#ifdef HAVE_SSL
					m_pMessageSSL.LeaveHub(this,msg->m_sNick);
#endif
				}

				break;
			}

			case DC_MESSAGE_NICKLIST:
			{
				CString *nick;
				
				CMessageNickList * msg = (CMessageNickList*)Object;

				if( m_bHandleUserList == TRUE )
				{
					// 0: update nicklist 1: requested nicklist
					if ( m_nNickListHandler == 1 )
					{
						m_UserList.Clear();

						m_nNickListHandler = 0;
					}

					m_UserList.InitUserList(msg);
					
					if (m_MessageSupports.m_bNoGetInfo == TRUE)
					{
						break;
					}
					
					for(nick=0;(nick=msg->m_NickList.Next(nick))!=0;)
					{
						SendGetInfo(*nick,GetNick());
					}
				}

				break;
			}

			case DC_MESSAGE_OPLIST:
			{
				CMessageNickList * msg = (CMessageNickList*)Object;

				// operators allready in the userlist
				if( m_bHandleUserList == TRUE )
				{
					// init operator list
					m_UserList.InitOperatorList(msg);
					
					m_nOpListHandler = 0;
				}
				break;
			}

			case DC_MESSAGE_SEARCH:
			{
				bool search = TRUE;
				CMessageSearch * msg = (CMessageSearch*)Object;

				if ( m_bHandleSearch == TRUE )
				{
					// check for loopback search
					if ( msg->m_bLocal )
					{
						if ( msg->m_sSource == GetNick() )
						{
							search = FALSE;
						}
					}
					else
					{
						// disable global search, compare search with own ip and port
						if ( CConfig::Instance() &&
						     (msg->m_nPort == CConfig::Instance()->GetUDPListenPort()) &&
						     (msg->m_sSource == CConfig::Instance()->GetUDPHostString(FALSE)) )
						{
							search = FALSE;
						}
					}

					if ( (search == TRUE) && (CQueryManager::Instance() != 0) )
					{
						CQueryManager::Instance()->SearchQuery( GetHubName(), GetHost(), GetNick(), msg );
					}
				}

				break;
			}

			case DC_MESSAGE_SEARCHRESULT:
			{
				if( m_bHandleUserList == TRUE )
				{
					UpdateUserSlots( (CMessageSearchResult *) Object );
				}

				if ( CSearchManager::Instance() )
					if ( CSearchManager::Instance()->HandleSearch( (CMessageSearchResult *) Object ) == TRUE )
						Object = 0;
				break;
			}

			case DC_MESSAGE_CONNECTTOME:
			{
				CMessageConnectToMe * msg = (CMessageConnectToMe*) Object;

				if ( m_bHandleTransfer == TRUE )
				{
					if ( CDownloadManager::Instance() )
						CDownloadManager::Instance()->DLM_AddTransferRequest( msg->m_sHost, msg->m_nPort, GetHubName(), GetHost() );
				}

				break;
			}

			case DC_MESSAGE_REVCONNECTTOME:
			{
				CMessageRevConnectToMe * msg = (CMessageRevConnectToMe*) Object;

				if ( CConfig::Instance() && (GetMode() == ecmACTIVE) && (m_bHandleTransfer == TRUE) )
				{
					CString s = CConfig::Instance()->GetTCPHostString();

					if ( s != "" )
					{
						if ( CDownloadManager::Instance() &&
						     (CDownloadManager::Instance()->DLM_AddTransferRequest( msg->m_sDstNick, "", GetHubName(), GetHost() ) == TRUE) )
						{
							SendConnectToMe(msg->m_sDstNick,s);
						}
					}
				}

				break;
			}

			case DC_MESSAGE_FORCEMOVE:
			{
				CMessageForceMove * msg = (CMessageForceMove*) Object;

				if ( CConfig::Instance() &&
				     (CConfig::Instance()->GetForceMoveEnabled() == TRUE) && (m_bHandleForceMove == TRUE) )
				{
					SetHubName(msg->m_sHost);

					UpdateReconnect( ersFORCEMOVE, 0 );

					Connect(msg->m_sHost,msg->m_nPort);
				}

				break;
			}

			case DC_MESSAGE_PRIVATECHAT:
			{
				CMessagePrivateChat * msg = (CMessagePrivateChat*) Object;

				if ( CConfig::Instance() &&
				     (CConfig::Instance()->GetChatRecvOfflineMessages() == TRUE) && (m_UserList.IsUserOnline(msg->m_sSrcNick) == FALSE) )
				{
					delete Object;
					Object = 0;
					msg = 0;
				}
#ifdef HAVE_SSL
				if ( msg )
				{
					m_pMessageSSL.PrivateChat(this,msg);
				}
#endif
				break;
			}

			case DC_MESSAGE_CAPABILITIES:
			{
				m_MessageCapabilities = *((CMessageCapabilities*) Object);
				break;
			}

			case DC_MESSAGE_SUPPORTS:
			{
				m_MessageSupports = *((CMessageSupports*) Object);
				break;
			}
			
			default:
			{
				break;
			}
		}

		if (Object)
		{
			((CDCMessage*)Object)->m_eType = type;

			if ( m_pCallback != 0 )
			{
				err = m_pCallback->notify( this, Object );
			}
			else
			{
				err = DC_CallBack( Object );
			}

			if ( err == -1 )
			{
				delete Object;
			}
		}
	}

	return 0;
}

/** */
void CClient::UpdateUserSlots( CMessageSearchResult * pSearchResult )
{
	int err;
	CMessageMyInfo myinfo,*mi;
	
	if ( m_UserList.UpdateUserSlots(pSearchResult) == TRUE )
	{
		if ( m_UserList.GetUserMyInfo( pSearchResult->m_sNick, &myinfo ) == TRUE )
		{
			mi = new CMessageMyInfo();
			*mi = myinfo;

			if ( m_pCallback != 0 )
			{
				err = m_pCallback->notify( this, mi );
			}
			else
			{
				err = DC_CallBack( mi );
			}

			if ( err == -1 )
			{
				delete mi;
			}
		}
	}
}

/** */
bool CClient::SetUserTransferInfo( CString nick, CDCMessage * msg )
{
	int err;
	bool res = FALSE;
	CMessageMyInfo myinfo,*mi;

	if ( m_UserList.SetUserTransferInfo(nick,msg) == TRUE )
	{
		if ( m_UserList.GetUserMyInfo( nick, &myinfo ) == TRUE )
		{
			mi = new CMessageMyInfo();
			*mi = myinfo;

			if ( m_pCallback != 0 )
			{
				err = m_pCallback->notify( this, mi );
			}
			else
			{
				err = DC_CallBack( mi );
			}

			if ( err == -1 )
			{
				delete mi;
			}
			
			res = TRUE;
		}
	}
	
	return res;
}

/** send private message */
int CClient::SendPrivateMessage( CString sNick, CString sTo, CString sMsg, CString sFromNick )
{
	int i=-1;
	CString s;

	if ( m_UserList.IsUserOnline( sTo ) || 
	     (CConfig::Instance() && CConfig::Instance()->GetChatSendOfflineMessages()) )
	{
#ifdef HAVE_SSL
		s = m_pMessageSSL.EncryptMessage( this, sTo, sMsg );

		if ( s != "" )
		{
			sMsg = s;
		}
#endif

		i = CDCProto::SendPrivateMessage( sNick, sTo, sMsg, sFromNick );
	}

	return i;
}

/** */
int CClient::RequestNickList()
{
	int res = 0;
	
	if ( m_nNickListHandler == 0 )
	{
		res = CDCProto::RequestNickList();
		
		// if set, we will never recv a nicklist
		if ( m_MessageSupports.m_bNoGetInfo == FALSE )
			m_nNickListHandler = 1;
		m_nOpListHandler = 1;
	}
	else
	{
		printf("We are still waiting for a NickList.\n");
	}
	
	return res;
}

/** */
int CClient::Disconnect( bool force )
{
	UpdateReconnect( ersDISABLED );
	
	SetUsedPassword(FALSE);

	return CConnection::Disconnect(force);
}
