/***************************************************************************
                          cconfig.cpp  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002-2005 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define DCLIB_CONFIG		"dclib.cfg"
#define DCTRA_CONFIG		"dctra.cfg"
#define DCHUB_CONFIG		"dchub.cfg"
#define DCPROF_CONFIG		"dcprof.cfg"
#define DCBOOKHUB_CONFIG	"dcbookhub.cfg"
#define DCSHARE_CONFIG		"dcshare.cfg"

#define XML_DCLIB_CONFIG	"dclib"
#define XML_DCHUB_CONFIG	"dchub"
#define XML_DCBOOKHUB_CONFIG	"dcbookhub"
#define XML_DCTRA_CONFIG	"dctra"
#define XML_DCSHARE_CONFIG	"dcshare"
#define XML_DCPROF_CONFIG	"dcprof"

#define XML_IDENTIFY		"identify"
#define XML_NICK		"nick"
#define XML_SEARCHNICK		"searchnick"
#define XML_AWAYMESSAGE		"awaymessage"
#define XML_EMAIL		"email"
#define XML_ANTISPAM		"antispam"
#define XML_SPEED		"speed"
#define XML_DESCRIPTION_TAG	"descriptiontag"
#define XML_EXTENDED_HUB_COUNT	"extendedhubcount"
#define XML_SUPPRESSED_NICKS	"suppressednicks"
#define XML_AWAY_PREFIX		"awayprefix"

#define XML_EMAIL_ENABLED	"emailenabled"
#define XML_DESCRIPTION_ENABLED	"descriptionenabled"

#define XML_LOGFILE		"logfile"
#define XML_LOGFILEON		"logfileon"
#define XML_LOGFILENAME		"logfilename"
#define XML_LOGDOWNLOADS	"logdownloads"
#define XML_LOGUPLOADS		"loguploads"
#define XML_LOGDETAILS		"logdetails"

#define XML_SECURITY		"security"
#define XML_FLOODOPKICKMESSAGE	"floodopkickmessage"

#define XML_TRANSFER		"transfer"
#define XML_DOWNLOADFOLDER	"downloadfolder"
#define XML_DOWNLOADFINISHEDFOLDER	"downloadfinishedfolder"
#define XML_SHAREDFOLDER	"sharedfolder"
#define XML_MAXUPLOAD		"maxupload"
#define XML_MAXUPLOADRATE	"maxuploadrate"
#define XML_MAXDOWNLOADRATE	"maxdownloadrate"
#define XML_AUTORECREATESHARELIST	"autorecreatesharelist"
#define XML_SENDMESSAGEONACTIVEMODEREQUEST "sendmessageonactivemoderequest"

#define XML_CONNECTION		"connection"
#define XML_MODE		"mode"
#define XML_TCPLISTENPORT	"tcplistenport"
#define XML_UDPLISTENPORT	"udplistenport"
#define XML_IP			"ip"
#define XML_EXTERNALIP		"externalip"

#define XML_SERVER		"server"
#define XML_HOST		"host"
#define XML_PORT		"port"
#define XML_LISTENHOST		"listenhost"
#define XML_BOOKMARK		"bookmark"
#define XML_PUBLIC		"public"
#define XML_USERCOUNT		"usercount"
#define XML_PROFILE_NAME	"profilename"
#define XML_PROFILE		"profile"
#define XML_PASSWORD		"password"
#define XML_AUTO_CONNECT	"autoconnect"
#define XML_SSL			"ssl"
#define XML_ID			"id"
#define XML_TIME		"time"
#define XML_FILE		"file"
#define XML_FILEENTRY		"fileentry"
#define XML_TYPE		"type"
#define XML_PATH		"path"
#define XML_ALIAS		"alias"
#define XML_ATIME		"atime"
#define XML_CTIME		"ctime"
#define XML_MTIME		"mtime"
#define XML_LOCALFILE		"localfile"
#define XML_LOCALPATH		"localpath"
#define XML_LOCALFILENAME	"localfilename"
#define XML_SIZE		"size"
#define XML_STATE		"state"
#define XML_PRIORITY		"priority"
#define XML_REMOTEFILE		"remotefile"
#define XML_MEDIUM		"medium"
#define XML_MEDIUM_FILE		"file"
#define XML_MEDIUM_BUFFER	"buffer"
#define XML_HASH		"hash"

#define XML_FILECHUNK		"filechunk"
#define XML_REFCOUNT		"refcount"
#define XML_CHUNK		"chunk"
#define XML_TEMPHASH		"temphash"
#define XML_MD5HASH		"md5hash"
#define XML_MD4HASH		"md4hash"
#define XML_MD4HASHLIST		"md4hashlist"

#define XML_SIZEDONE		"sizedone"
#define XML_MULTI		"multi"

#define XML_START		"start"
#define XML_END			"end"

#define XML_HUB			"hub"
#define XML_ACTIVE		"active"
#define XML_REMOTEHOST		"remotehost"

#define XML_HUBLISTURL		"hublisturl"
#define XML_URL			"url"
#define XML_ENABLED		"enabled"

#define XML_OTHER			"other"
#define XML_HUBLISTSTORELOCAL		"hubliststorelocal"
#define XML_RECONNECTCOUNT		"reconnectcount"
#define XML_RECONNECTTIMEOUT		"reconnecttimeout"
#define XML_TRANSFERRESPONSETIMEOUT 	"transferresponsetimeout"
#define XML_TRANSFERRESENDTIMEOUT 	"transferresendtimeout"
#define XML_FORCEMOVEENABLED		"forcemoveenabled"
#define XML_DOWNLOADQUEUETIME		"downloadqueuetime"
#define XML_CHECKPRIVATEADDRESSSPACE	"checkprivateaddressspace"

#define XML_SEARCH_HISTORY		"searchhistory"
#define XML_DCLIB_DATAPATH		"dclibdatapath"
#define XML_DYNAMICUPLOADRATE		"dynamicuploadrate"

#define XML_CHATSENDOFFLINEMESSAGES	"chatsendofflinemessages"
#define XML_CHATRECVOFFLINEMESSAGES	"chatrecvofflinemessages"

#define XML_DC				"dc"
#define XML_VERSION			"version"
#define XML_RELEASE			"release"

#define XML_MODE_ACTIVE			"active"
#define XML_MODE_PASSIVE		"passive"

#define XML_USER_UPLOAD_SLOTS		"useruploadslots"
#define XML_TRANSFER_CERT		"transfercert"
#define XML_TRANSFER_KEY		"transferkey"

#define XML_HUBOFFLINE_TRANSFERCLOSE	"hubofflinetransferclose"
#define XML_TRANSFER_AUTOSEARCH		"transferautosearch"
#define XML_RELOAD_HUBLIST_TIME		"reloadhublisttime"
#define XML_RECREATE_SHARELIST_TIME	"recreatesharelisttime"

#define XML_DISABLEHASHLIST		"disablehashlist"
#define XML_COMPRESSEDTRANSFERS		"enablecompressedtransfers"

#define XML_TRAFFIC_RX			"trafficrx"
#define XML_TRAFFIC_TX			"traffictx"
#define XML_TRAFFIC_DATA_RX		"trafficdatarx"
#define XML_TRAFFIC_DATA_TX		"trafficdatatx"
#define XML_TRAFFIC_CONTROL_RX		"trafficcontrolrx"
#define XML_TRAFFIC_CONTROL_TX		"trafficcontroltx"

#define XML_AUTOSEARCHINTERVAL		"autosearchinterval"
#define XML_SMALLFILESIZE		"smallfilesize"

#define XML_DONTSHAREDOTFILES		"dontsharedotfiles"

#define XML_REMOTE_ENCODING		"remote_encoding"

#ifdef WIN32
#define DCGUI_CONFIG_PATH	"\\dc"
#else
#define DCGUI_CONFIG_PATH	"/.dc"
#endif

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/che3.h>
#include <dclib/core/cbz.h>
#include <dclib/core/cxml.h>
#include <dclib/core/cdir.h>
#include <dclib/core/csocket.h>
#include <dclib/dcobject.h>
#include <dclib/cquerymanager.h>
#include <dclib/cfilemanager.h>
#include <dclib/core/cstringlist.h>
#include <dclib/cconnectionmanager.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cdownloadqueue.h>
#include <dclib/clistenmanager.h>

#include <dclib/core/ciconv.h>

#include "cconfig.h"

/** default hub url list */
const char * huburl_list[] = {
	"http://dchublist.com/hublist.config.bz2",
	"http://dreamland.gotdns.org/PublicHubList.config.bz2",
	"http://hublist.awenet.info/PublicHubList.config.bz2",
	"http://www.hublist.org/PublicHubList.config.bz2",
//	"http://www.neo-modus.com/PublicHubList.config",
//	"http://dcplusplus.sourceforge.net/PublicHubList.config.bz2",
//	"http://axljab.homelinux.org:8080/PublicHubList.config.bz2",
//	"http://dreamland.gotdns.org/PublicHubList.config",
//	"http://dc-dreamland.dhs.org/PublicHubList.config",
//	"http://web.njit.edu/~cjm3//PublicHubList.config",
//	"http://ld.yi.org/dc/PublicHubList.config",
//	"http://www.p2pitalia.com/dclist/Publichublist.config",
//	"http://www.team-ppm.com/~dawson/PublicHubList.config",
//	"http://finhublist.no-ip.org/PublicHubList.config",
//	"http://freespace.morat.net/WUKY/PublicHubList.config",
//	"http://www.1stleg.com/PublicHubList.config",
	0	   
};
/** */
CConfig::CConfig( CString configpath )
{
	CDir d;

	if ( configpath == "" )
	{
		sConfigPath = CDir::HomeDirPath();
	}
	else
	{
		sConfigPath = configpath;
	}

	// create the configpath
	d.SetPath(sConfigPath);
	d.CreatePath(DCGUI_CONFIG_PATH);
	sConfigPath += DCGUI_CONFIG_PATH;
	sConfigPath += DIRSEPARATOR;

	// create chatlog path
	d.SetPath(sConfigPath);
	d.CreatePath(DCGUI_CHATLOG_PATH);

	// create plugin config path
	d.CreatePath(DCGUI_PLUGINCONFIG_PATH);

	// create image path
	d.CreatePath(DCGUI_IMAGE_PATH);

	// create filellist path
	d.CreatePath(DCGUI_FILELIST_PATH);
	
	// default settings
	sEMail         = "email";
	sNick          = "nick";
	sSearchNick    = "nick_search";
	sAwayMessage   = "";
	sDescription   = "http://wxdcgui.sourceforge.net";
	sSpeed         = "28.8Kbps";
	m_sHost        = "ppp0";
	m_bExternalIP  = FALSE;	
	m_sHostCache   = "";
	m_tHostTimeout = time(0);
	m_sListenHost  = "";
	
	eMode     = ecmPASSIVE;
	eAwayMode = euamNORMAL;

	iTCPListenPort     = 9176;
	iUDPListenPort     = 9176;
	iMaxUpload         = 3;
	lMaxUploadRate     = 0;
	iUserUploadSlots   = 1;
	lMaxDownloadRate   = 0;
	iDownloadQueueTime = 0;
	iReconnectCount    = 3;
	iReconnectTimeout  = 60;

	bSendMessageOnActiveModeRequest = FALSE;
	bHubListStoreLocal              = TRUE;
	bForceMoveEnabled               = TRUE;
	bAntiSpam                       = TRUE;
	bDescriptionTag                 = TRUE;
	bCheckPrivateAddressSpace       = FALSE;
	bDynamicUploadRate              = FALSE;
	bChatSendOfflineMessages 	= FALSE;
	bChatRecvOfflineMessages 	= TRUE;
	bTransferAutoSearch             = FALSE;

	iTransferResendTimeout   = 100;
	iTransferResponseTimeout = 60;
	eHubOfflineTransferClose = ectNONE;
	
	sDownloadFolder         = "";
	sDownloadFinishedFolder = "";

	bAutoRecreateShareList = FALSE;

	bLogFile = 0;
	bLogFinishedDownloads = TRUE;
	bLogFinishedUploads = TRUE;
	bLogDetails = FALSE;
	sLogFile = "";

	pBookmarkHubList = new CStringList();
	pPublicHubList   = new CStringList();
	pHubProfileList  = new CStringList();
	pSearchHistory   = new CList<CString>();

	pPublicHubList_HostIndex   = new CStringList();
	pBookmarkHubList_HostIndex = new CStringList();

	sFloodOpKickMessage = "Flooding";

	m_nPublicHubID = 0;
	m_nBookHubID   = 0;

#ifndef WIN32
	m_sDCLibDataPath  = DCLIB_DATAPATH;
	m_sDCLibDataPath += "/dclib";
#else
	// read datapath from registrie
	LONG Status;
	HKEY regdcgui;
	UCHAR buffer[1024];
	DWORD dim = 1024;

	m_sDCLibDataPath = "";

	// load from HKLM
	Status = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
		TEXT("Software\\VALKNUT"),
		0,
		KEY_READ,
		&regdcgui);

	if ( Status != ERROR_SUCCESS )
	{
		// load from HKCU
		Status = RegOpenKeyEx(HKEY_CURRENT_USER,
			TEXT("Software\\VALKNUT"),
			0,
			KEY_READ,
			&regdcgui);
	}
	
	if ( Status == ERROR_SUCCESS )
	{
		Status = RegQueryValueEx(regdcgui,"Path",NULL,NULL,buffer,&dim);

		if ( Status == ERROR_SUCCESS )
		{
			m_sDCLibDataPath = (char*)buffer;
		}

		RegCloseKey(regdcgui);
	}
#endif
	m_sTransferCert = "";
	m_sTransferKey  = "";
	m_nReloadHubListTime = 0;
	m_nRecreateShareListTime = 0;
	m_bCreateFile = FALSE;
	m_bDisableHashList = FALSE;
	m_bCompressedTransfers = TRUE;

	/* The previous hard coded interval was 10 minutes */
	m_nAutoSearchInterval = 600;
	/* Previous valknut value was 16KiB, DC++ increased it to 64KiB */
	m_nSmallFileSize = 65536;
	
	/** Default to false, share dot files (previous behaviour) */
	m_bDontShareDotFiles = FALSE;
	
	/** Default to ISO-8859-1 (previous behaviour) */
	m_sRemoteEncoding = "ISO-8859-1";
	
	SetInstance(this);
}

/** */
CConfig::~CConfig()
{
	SetInstance(0);
	
	if ( pPublicHubList )
	{
		delete pPublicHubList;
	}

	if ( pBookmarkHubList )
	{
		delete pBookmarkHubList;
	}

	if ( pHubProfileList )
	{
		delete pHubProfileList;
	}

	if ( pSearchHistory )
	{
		delete pSearchHistory;
	}

	if ( pPublicHubList_HostIndex )
	{
		delete pPublicHubList_HostIndex;
		pPublicHubList_HostIndex = 0;
	}

	if ( pBookmarkHubList_HostIndex )
	{
		delete pBookmarkHubList_HostIndex;
		pBookmarkHubList_HostIndex = 0;
	}
}

/** */
int CConfig::LoadDCLib()
{
	int err = 0;
	CString s;
	CXml * xml;
	xmlNodePtr node;

	s = sConfigPath + DCLIB_CONFIG;

	xml = new CXml();

	if ( xml->ParseFile(s) == TRUE )
	{
		for(node=xml->doc()->children;node!=0;node=node->next)
		{
			if ( xml->name(node) == XML_DCLIB_CONFIG )
			{
				ParseDCLibConfig(node->xmlChildrenNode);
			}
		}
	}
	else
	{
		err = -1;
	}

	// add missing urls
	DCConfigHubListUrl * hublisturl;
	int i;

	for(i=0;huburl_list[i]!=0;i++)
	{
		hublisturl = 0;

		while ( (hublisturl=pHubListUrlList.Next(hublisturl)) != 0 )
		{
			if ( hublisturl->sUrl == huburl_list[i] )
			{
				break;
			}
		}

		if ( hublisturl == 0 )
		{
			hublisturl = new DCConfigHubListUrl();
			hublisturl->sUrl = huburl_list[i];
			hublisturl->bEnabled = TRUE;
			pHubListUrlList.Add(hublisturl);
		}
	}

	delete xml;

	return err;
}

/** */
int CConfig::SaveDCLib()
{
	int err=0;
	CString s;
	CString *ps;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	CXml * xml;

	xml = new CXml();

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCLIB_CONFIG,0);

	// identify
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_IDENTIFY, 0 );

	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_NICK,        sNick );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_SEARCHNICK,  sSearchNick );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_AWAYMESSAGE, sAwayMessage );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_EMAIL,       sEMail );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DESCRIPTION, sDescription );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_AWAY_PREFIX, sAwayPrefix );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_SPEED,       sSpeed );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_ANTISPAM, bAntiSpam );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DESCRIPTION_TAG, bDescriptionTag );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_EXTENDED_HUB_COUNT, m_bUseExtendedHubCount );

	// logfile
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_LOGFILE, 0 );

	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_LOGFILEON, bLogFile );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_LOGFILENAME, sLogFile );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_LOGDOWNLOADS, bLogFinishedDownloads );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_LOGUPLOADS, bLogFinishedUploads );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_LOGDETAILS, bLogDetails );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_FLOODOPKICKMESSAGE, sFloodOpKickMessage);
	
	// transfer
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_TRANSFER, 0 );

	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DOWNLOADFOLDER, sDownloadFolder );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DOWNLOADFINISHEDFOLDER, sDownloadFinishedFolder );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_TRANSFER_AUTOSEARCH, bTransferAutoSearch );

	DCConfigShareFolder * csf = 0;

	while( (csf=SharedFolders.Next(csf)) != 0 )
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)XML_SHAREDFOLDER, 0 );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_PATH, csf->m_sPath );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_ALIAS, csf->m_sAlias );
	}

	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_AUTORECREATESHARELIST, bAutoRecreateShareList);
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_RECREATE_SHARELIST_TIME, CString().setNum(m_nRecreateShareListTime) );

	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_MAXUPLOAD, CString().setNum(iMaxUpload) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_USER_UPLOAD_SLOTS, CString().setNum(iUserUploadSlots) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_MAXUPLOADRATE, CString().setNum(lMaxUploadRate) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_MAXDOWNLOADRATE, CString().setNum(lMaxDownloadRate) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DOWNLOADQUEUETIME, CString().setNum(iDownloadQueueTime) );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DYNAMICUPLOADRATE, bDynamicUploadRate );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRANSFER_CERT, m_sTransferCert );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRANSFER_KEY, m_sTransferKey );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_HUBOFFLINE_TRANSFERCLOSE, CString().setNum(eHubOfflineTransferClose) );
	
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_RX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettRX)) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_TX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettTX)) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_DATA_RX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettDATARX)) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_DATA_TX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettDATATX)) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_CONTROL_RX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettCONTROLRX)) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRAFFIC_CONTROL_TX, CString().setNum(CSocket::m_Traffic.GetTraffic(ettCONTROLTX)) );

	// connection
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_CONNECTION, 0 );

	if ( eMode == ecmPASSIVE )
		s = XML_MODE_PASSIVE;
	else
		s = XML_MODE_ACTIVE;
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_MODE, s.Data() );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TCPLISTENPORT, CString().setNum(iTCPListenPort) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_UDPLISTENPORT, CString().setNum(iUDPListenPort) );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_EXTERNALIP, m_bExternalIP );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_IP, m_sHost );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_LISTENHOST, m_sListenHost );	
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_SENDMESSAGEONACTIVEMODEREQUEST, bSendMessageOnActiveModeRequest );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_CHECKPRIVATEADDRESSSPACE, bCheckPrivateAddressSpace );

	// hublisturl
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_HUBLISTURL, 0 );

	DCConfigHubListUrl *hublisturl = 0;

	while( (hublisturl=pHubListUrlList.Next(hublisturl)) != 0 )
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)XML_URL, 0 );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_NAME, hublisturl->sUrl );
		xml->xmlNewBoolChild( node1, 0, (const xmlChar*)XML_ENABLED, hublisturl->bEnabled );
	}

	// other
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_OTHER, 0 );

	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_RECONNECTCOUNT, CString().setNum(iReconnectCount) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_RECONNECTTIMEOUT, CString().setNum(iReconnectTimeout) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRANSFERRESPONSETIMEOUT, CString().setNum(iTransferResponseTimeout) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TRANSFERRESENDTIMEOUT, CString().setNum(iTransferResendTimeout) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DCLIB_DATAPATH, m_sDCLibDataPath );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_CHATSENDOFFLINEMESSAGES, bChatSendOfflineMessages );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_CHATRECVOFFLINEMESSAGES, bChatRecvOfflineMessages );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_HUBLISTSTORELOCAL, bHubListStoreLocal );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_RELOAD_HUBLIST_TIME, CString().setNum(m_nReloadHubListTime) );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_FORCEMOVEENABLED, bForceMoveEnabled );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DISABLEHASHLIST, m_bDisableHashList );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_COMPRESSEDTRANSFERS, m_bCompressedTransfers );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_AUTOSEARCHINTERVAL, CString().setNum(m_nAutoSearchInterval) );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_SMALLFILESIZE, CString().setNum(m_nSmallFileSize) );
	xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DONTSHAREDOTFILES, m_bDontShareDotFiles );
	xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_REMOTE_ENCODING, m_sRemoteEncoding );

	// search history
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_SEARCH_HISTORY, 0 );

	ps = 0;

	while( (ps = pSearchHistory->Next(ps)) != 0 )
	{
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_NAME, *ps );
	}

	// save file
	s = sConfigPath + DCLIB_CONFIG;

	if ( SaveConfigXmlViaTemp(s,doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	delete xml;

	return err;
}

/** */
int CConfig::LoadDCHub()
{
	CString s;
	CXml * xml;
	xmlNodePtr node;

	// load public hub list
	s = sConfigPath + DCHUB_CONFIG;

	xml = new CXml();

	if ( xml->ParseFile(s) == TRUE )
	{
		for(node=xml->doc()->children;node!=0;node=node->next)
		{
			if ( !xmlStrcmp( node->name, (const xmlChar*)XML_DCHUB_CONFIG ) )
			{
				ParseDCHubConfig(node->xmlChildrenNode);
			}
		}
	}

	delete xml;

	// load bookmark hub list
	s = sConfigPath + DCBOOKHUB_CONFIG;

	xml = new CXml();

	if ( xml->ParseFile(s) == TRUE )
	{
		for(node=xml->doc()->children;node!=0;node=node->next)
		{
			if ( !xmlStrcmp( node->name, (const xmlChar*)XML_DCBOOKHUB_CONFIG ) )
			{
				ParseDCBookHubConfig(node->xmlChildrenNode);
			}
		}
	}

	delete xml;

	// add default hub entry
	if ( pBookmarkHubList->Count() == 0 )
	{
		DCConfigHubItem *hubitem = new DCConfigHubItem();

		hubitem->m_nID          = 1;
		hubitem->m_sName        = "Valknut/DCLib Chat";
		hubitem->m_sHost        = "valknut.dyndns.info:59176";
		hubitem->m_sDescription = "Valknut/DCLib Chat";

		pBookmarkHubList->Add(hubitem->m_sName,hubitem);
		pBookmarkHubList_HostIndex->Add(hubitem->m_sHost.ToUpper(),new CString(hubitem->m_sName));

		// save bookmark list
		SaveDCBookHub();
	}

	return 0;
}

/** */
int CConfig::SaveDCHub()
{
	int err=0;

	SaveDCPublicHub();

	SaveDCBookHub();

	return err;
}

/** */
int CConfig::SaveDCPublicHub()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	CXml * xml;
	DCConfigHubItem *hubitem;

	xml = new CXml();
	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCHUB_CONFIG,0);

	// bookmarks
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_SERVER, 0 );

	// store public hub list
	if ( bHubListStoreLocal == TRUE )
	{
		hubitem = 0;

		while( pPublicHubList->Next((CObject*&)hubitem) != 0 )
		{
			node1 = xmlNewChild( node, 0, (const xmlChar*)XML_PUBLIC, 0 );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_ID,	   CString().setNum(hubitem->m_nID) );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_NAME,        hubitem->m_sName );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_HOST,        hubitem->m_sHost );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_PORT,        CString().setNum(hubitem->m_nPort) );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_DESCRIPTION, hubitem->m_sDescription );
			xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_USERCOUNT,   hubitem->m_sUserCount );
		}
	}

	// save file
	s = sConfigPath + DCHUB_CONFIG;

	if ( SaveConfigXmlViaTemp(s,doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	delete xml;

	return err;
}

/** */
int CConfig::SaveDCBookHub()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	CXml * xml;
	DCConfigHubItem *hubitem;

	xml = new CXml();
	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCBOOKHUB_CONFIG,0);

	// bookmarks
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_SERVER, 0 );

	hubitem = 0;

	while( pBookmarkHubList->Next((CObject*&)hubitem) != 0 )
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)XML_PUBLIC, 0 );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_ID,	    CString().setNum(hubitem->m_nID) );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_NAME,         hubitem->m_sName );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_HOST,         hubitem->m_sHost );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_PORT,         CString().setNum(hubitem->m_nPort) );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_DESCRIPTION,  hubitem->m_sDescription );
		xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_PROFILE_NAME, hubitem->m_sProfile );
	}

	// save file
	s = sConfigPath + DCBOOKHUB_CONFIG;

	if ( SaveConfigXmlViaTemp(s,doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);
	delete xml;

	return err;
}

/** */
int CConfig::LoadDCTra( CStringList * queue, CStringList * chunks )
{
	CXml * xml;
	xmlNodePtr node,c1,c2,c3;
	CString s, xml_name1, xml_name2;
	CStringList * sl1,*sl2;
	DCHubObject * HubObject;

	s = sConfigPath + DCTRA_CONFIG;

	xml = new CXml();

	if ( xml->ParseFile(s) == FALSE )
	{
		delete xml;
		return -1;
	}

	for(node=xml->doc()->children;node!=0;node=node->next)
	{
		if ( xml->name(node) == XML_DCTRA_CONFIG )
		{
			for(c1=node->xmlChildrenNode;c1!=0;c1=c1->next)
			{
				if ( xml->name(c1) == XML_TRANSFER )
				{
					DCTransferQueueObject * TransferObject = new DCTransferQueueObject();
					TransferObject->eState = etwsIDLE;
					TransferObject->iConnections = 0;

					for(c2=c1->xmlChildrenNode;c2!=0;c2=c2->next)
					{
						xml_name1 = xml->name(c2);
						if ( xml_name1 == XML_NICK )
							TransferObject->sNick = xml->content(c2);
						else if ( xml_name1 == XML_HUBNAME )
							TransferObject->sHubName = xml->content(c2);
						else if ( xml_name1 == XML_HUBHOST )
							TransferObject->sHubHost = xml->content(c2);
						else if ( xml_name1 == XML_HUB )
						{
							HubObject = new DCHubObject();

							for(c3=c2->xmlChildrenNode;c3!=0;c3=c3->next)
							{
								xml_name2 = xml->name(c3);
								if ( xml_name2 == XML_HUBNAME )
									HubObject->m_sHubName = xml->content(c3);
								else if ( xml_name2 == XML_HUBHOST )
									HubObject->m_sHubHost = xml->content(c3);
								else if ( xml_name2 == XML_ACTIVE )
									HubObject->m_bActive = xml->getBoolChild(c3);
							}

							TransferObject->pHubList.Add(HubObject);
						}
						else if ( xml_name1 == XML_FILE )
						{
							DCTransferFileObject * TransferFileObject = new DCTransferFileObject();

							for(c3=c2->xmlChildrenNode;c3!=0;c3=c3->next)
							{
								xml_name2 = xml->name(c3);
								if ( xml_name2 == XML_ID )
									TransferFileObject->m_nID = xml->content(c3).asULL();
								else if ( xml_name2 == XML_TIME )
									TransferFileObject->m_nTime = xml->content(c3).asULL();
								else if ( xml_name2 == XML_REMOTEFILE )
									TransferFileObject->m_sRemoteFile = xml->content(c3);
								else if ( xml_name2 == XML_LOCALFILENAME )
									TransferFileObject->m_sLocalFileName = xml->content(c3);
								else if ( xml_name2 == XML_SIZE )
									TransferFileObject->m_nSize = xml->content(c3).asULL();
								else if ( xml_name2 == XML_PRIORITY )
									TransferFileObject->m_nPriority = xml->content(c3).asINT();
								else if ( xml_name2 == XML_STATE )
									TransferFileObject->m_eState = (eTransferFileState)xml->content(c3).asINT();
								else if ( xml_name2 == XML_LOCALPATH )
									TransferFileObject->m_sLocalPath = xml->content(c3);
								else if ( xml_name2 == XML_LOCALFILE )
									TransferFileObject->m_sLocalFile = xml->content(c3);
								else if ( xml_name2 == XML_TEMPHASH )
									TransferFileObject->m_stHash = xml->content(c3);
								else if ( xml_name2 == XML_HASH )
									TransferFileObject->m_sHash = xml->content(c3);
								else if ( xml_name2 == XML_MEDIUM )
								{
									if ( xml->content(c3) == XML_MEDIUM_BUFFER )
										TransferFileObject->m_eMedium = eltBUFFER;
									else
										TransferFileObject->m_eMedium = eltFILE;
								}
								else if ( xml_name2 == XML_MULTI )
									TransferFileObject->m_bMulti = xml->getBoolChild(c3);
							}

							// fix state
							if ( TransferFileObject->m_eState == etfsTRANSFER )
								TransferFileObject->m_eState = etfsNONE;
							TransferObject->pTransferFileList.Add( TransferFileObject->m_sRemoteFile, TransferFileObject );
						}
					}

					if ( TransferObject->pTransferFileList.Count() == 0 )
					{
						delete TransferObject;
					}
					else
					{
						if ( queue->Get( TransferObject->sNick, (CObject*&)sl1 ) == 0 )
						{
							if ( sl1->Get( TransferObject->sHubName, (CObject*&)sl2 ) == 0 )
							{
								printf("load queue: error double entrys !!!!\n");
							}
							else
							{
								sl1->Add( TransferObject->sHubName, TransferObject );
							}
						}
						else
						{
							sl1 = new CStringList();
							sl1->Add( TransferObject->sHubName, TransferObject );
							queue->Add( TransferObject->sNick, sl1 );
						}
					}
				}
				else if ( xml->name(c1) == XML_FILECHUNK )
				{
					DCFileChunkObject * FileChunkObject = new DCFileChunkObject();

					for(c2=c1->xmlChildrenNode;c2!=0;c2=c2->next)
					{
						xml_name2 = xml->name(c2);
						if ( xml_name2 == XML_LOCALFILE )
							FileChunkObject->m_sLocalFile = xml->content(c2);
						else if ( xml_name2 == XML_TEMPHASH )
							FileChunkObject->m_stHash = xml->content(c2);
						else if ( xml_name2 == XML_HASH )
							FileChunkObject->m_sHash = xml->content(c2);
						else if ( xml_name2 == XML_SIZE )
							FileChunkObject->m_nSize = xml->content(c2).asULL();
						else if ( xml_name2 == XML_SIZEDONE )
							FileChunkObject->m_nSizeDone = xml->content(c2).asULL();
						else if ( xml_name2 == XML_REFCOUNT )
							FileChunkObject->m_nReferenceCount = xml->content(c2).asINT();
						else if ( xml_name2 == XML_MULTI )
							FileChunkObject->m_bMulti = xml->getBoolChild(c2);
						else if ( xml_name2 == XML_CHUNK )
						{
							DCChunkObject * ChunkObject = new DCChunkObject();

							for(c3=c2->xmlChildrenNode;c3!=0;c3=c3->next)
							{
								if ( xml->name(c3) == XML_START )
									ChunkObject->m_nStart = xml->content(c3).asULL();
								else if ( xml->name(c3) == XML_END )
									ChunkObject->m_nEnd = xml->content(c3).asULL();
							}

							FileChunkObject->m_Chunks.Add(ChunkObject);
						}
					}

					chunks->Add( FileChunkObject->m_sLocalFile, FileChunkObject );
				}
			}
		}
	}

	delete xml;

	return 0;
}

/** */
int CConfig::SaveDCTra( CStringList * queue, CStringList * chunks )
{
	int err;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	DCTransferQueueObject * TransferObject;
	DCFileChunkObject * FileChunkObject;
	DCChunkObject * ChunkObject;
	DCHubObject * HubObject;

	CStringList * sl1;

	CXml * xml;

	err = 0;

	xml = new CXml();
	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCTRA_CONFIG,0);

	// nick,stringlist
	sl1 = 0;
	while(queue->Next((CObject*&)sl1))
	{
		// hubname,transferobject
		TransferObject = 0;
		while(sl1->Next((CObject*&)TransferObject))
		{
			if ( TransferObject->pTransferFileList.Count() == 0 )
			{
				continue;
			}

			node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_TRANSFER, 0 );

			// store nick,hubhost and hubname
			xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_NICK,      TransferObject->sNick);
			xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_HUBNAME,   TransferObject->sHubName);
			xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_HUBHOST,   TransferObject->sHubHost);

			HubObject = 0;

			while( (HubObject=TransferObject->pHubList.Next(HubObject)) != 0 )
			{
				node1 = xmlNewChild( node, 0, (const xmlChar*)XML_HUB, 0 );

				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_HUBNAME, HubObject->m_sHubName);
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_HUBHOST, HubObject->m_sHubHost);
				xml->xmlNewBoolChild( node1, 0, (const xmlChar*)XML_ACTIVE, HubObject->m_bActive );
			}

			// save files
			DCTransferFileObject * TransferFileObject = 0;
			while(TransferObject->pTransferFileList.Next((CObject*&)TransferFileObject))
			{
				node1 = xmlNewChild( node, 0, (const xmlChar*)XML_FILE, 0 );

				xmlNewChild( node1, 0, (const xmlChar*)XML_ID, (const xmlChar*) CString().setNum(TransferFileObject->m_nID).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_TIME, (const xmlChar*) CString().setNum(TransferFileObject->m_nTime).Data());				
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_REMOTEFILE, TransferFileObject->m_sRemoteFile);
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_LOCALFILENAME, TransferFileObject->m_sLocalFileName);
				xmlNewChild( node1, 0, (const xmlChar*)XML_SIZE,(const xmlChar*) CString().setNum(TransferFileObject->m_nSize).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_PRIORITY,(const xmlChar*) CString().setNum(TransferFileObject->m_nPriority).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_STATE,(const xmlChar*) CString().setNum(TransferFileObject->m_eState).Data());
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_LOCALFILE, TransferFileObject->m_sLocalFile);
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_LOCALPATH, TransferFileObject->m_sLocalPath);

				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_TEMPHASH, TransferFileObject->m_stHash, FALSE );
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_HASH, TransferFileObject->m_sHash, FALSE );
				
				if(TransferFileObject->m_eMedium==eltBUFFER)
					s = XML_MEDIUM_BUFFER;
				else
					s = XML_MEDIUM_FILE;			
				xml->xmlNewStringChild( node1, 0, (const xmlChar*)XML_MEDIUM, s );

				xml->xmlNewBoolChild( node1, 0, (const xmlChar*)XML_MULTI, TransferFileObject->m_bMulti );
			}
		}
	}

	FileChunkObject = 0;
	while( chunks->Next((CObject*&)FileChunkObject) )
	{
		node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_FILECHUNK, 0 );

		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_LOCALFILE, FileChunkObject->m_sLocalFile );
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_TEMPHASH, FileChunkObject->m_stHash );
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_HASH, FileChunkObject->m_sHash );
		xmlNewChild( node, 0, (const xmlChar*)XML_SIZE,(const xmlChar*) CString().setNum(FileChunkObject->m_nSize).Data());
		xmlNewChild( node, 0, (const xmlChar*)XML_SIZEDONE,(const xmlChar*) CString().setNum(FileChunkObject->m_nSizeDone).Data());
		xmlNewChild( node, 0, (const xmlChar*)XML_REFCOUNT,(const xmlChar*) CString().setNum(FileChunkObject->m_nReferenceCount).Data());
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_MULTI, FileChunkObject->m_bMulti );

		ChunkObject = 0;

		while( (ChunkObject=FileChunkObject->m_Chunks.Next(ChunkObject)) != 0 )
		{
			node1 = xmlNewChild( node, 0, (const xmlChar*)XML_CHUNK, 0 );
			xmlNewChild( node1, 0, (const xmlChar*)XML_START,(const xmlChar*) CString().setNum(ChunkObject->m_nStart).Data());
			xmlNewChild( node1, 0, (const xmlChar*)XML_END,(const xmlChar*) CString().setNum(ChunkObject->m_nEnd).Data());
		}
	}

	s = sConfigPath + DCTRA_CONFIG;

	if ( SaveConfigXmlViaTemp(s,doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);
	delete xml;

	return err;
}

/** */
CString CConfig::ParseVersion( CString s )
{
	CString release;
	xmlDocPtr doc;
	xmlNodePtr node,n1,n2;
	xmlChar * c;

	release = "";

	doc = xmlParseMemory(s.Data(),s.Length());

	if ( doc == 0 )
	{
		return "";
	}
	else
	{
		for(node=doc->children;node!=0;node=node->next)
		{
			if ( !xmlStrcmp( node->name, (const xmlChar*)XML_DC ) )
			{
				for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
				{
					if ( !xmlStrcmp( n1->name, (const xmlChar*)XML_VERSION ) )
					{
						for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
						{
							if ( !xmlStrcmp( n2->name, (const xmlChar*)XML_RELEASE ) )
							{
								if ( (c = xmlNodeGetContent(n2)) != 0 )
								{
									release = (const char*)c;
									xmlFree(c);
								}
							}
						}
					}
				}
			}
		}

		xmlFreeDoc(doc);
	}

	return release;
}

/** */
void CConfig::ParseDCHubConfig( xmlNodePtr node )
{
	CXml * xml;
	xmlNodePtr n1,n2,n3;
	bool reorder = FALSE;
	DCConfigHubItem * hubitem;
	CString xml_name;

	xml = new CXml();

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* parse server entrys */
		if ( xml->name(n1) == XML_SERVER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				// public hub list
				if ( xml->name(n2) == XML_PUBLIC )
				{
					hubitem = new DCConfigHubItem();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						xml_name = xml->name(n3);

						if ( xml_name == XML_ID )
							hubitem->m_nID = xml->content(n3).asULL();
						else if ( xml_name == XML_NAME )
							hubitem->m_sName = xml->content(n3);
						else if ( xml_name == XML_HOST )
							hubitem->m_sHost = xml->content(n3);
						else if ( xml_name == XML_PORT )
							hubitem->m_nPort = xml->content(n3).asUINT();
						else if ( xml_name == XML_DESCRIPTION )
							hubitem->m_sDescription = xml->content(n3);
						else if ( xml_name == XML_USERCOUNT )
							hubitem->m_sUserCount = xml->content(n3);
					}

					if ( hubitem->m_nID == 0 )
					{
						reorder = TRUE;
					}

					else if ( hubitem->m_nID > m_nPublicHubID )
					{
						m_nPublicHubID = hubitem->m_nID;
					}

					// remove spaces
					hubitem->m_sHost = hubitem->m_sHost.Replace(" ","");
					
					// no port found
					if ( hubitem->m_sHost.Find(':') == -1 )
					{
						// add default port
						hubitem->m_sHost += ":411";
					}
					
					pPublicHubList->Add(hubitem->m_sName.ToUpper(),hubitem);
					pPublicHubList_HostIndex->Add(hubitem->m_sHost.ToUpper(),new CString(hubitem->m_sName));
				}
			}
		}
	}

	delete xml;

	if ( reorder == TRUE )
	{
		hubitem = 0;

		while ( pPublicHubList->Next( (CObject*&)hubitem) != 0 )
		{
			if ( hubitem->m_nID == 0 )
			{
				m_nPublicHubID++;
				hubitem->m_nID = m_nPublicHubID;
			}
		}

		SaveDCPublicHub();
	}
}

/** */
void CConfig::ParseDCBookHubConfig( xmlNodePtr node )
{
	CXml * xml;
	xmlNodePtr n1,n2,n3;
	bool reorder = FALSE;
	DCConfigHubItem * hubitem;
	CString xml_name;

	xml = new CXml();

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* parse server entrys */
		if ( xml->name(n1) == XML_SERVER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				// bookmark hub list
				if ( xml->name(n2) == XML_PUBLIC )
				{
					hubitem = new DCConfigHubItem();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						xml_name = xml->name(n3);

						if ( xml_name == XML_ID )
							hubitem->m_nID = xml->content(n3).asULL();
						else if ( xml_name == XML_NAME )
							hubitem->m_sName = xml->content(n3);
						else if ( xml_name == XML_HOST )
							hubitem->m_sHost = xml->content(n3);
						else if ( xml_name == XML_PORT )
							hubitem->m_nPort = xml->content(n3).asUINT();
						else if ( xml_name == XML_DESCRIPTION )
							hubitem->m_sDescription = xml->content(n3);
						else if ( xml_name == XML_PROFILE_NAME )
							hubitem->m_sProfile = xml->content(n3);
					}

					if ( hubitem->m_nID == 0 )
					{
						reorder = TRUE;
					}

					else if ( hubitem->m_nID > m_nBookHubID )
					{
						m_nBookHubID = hubitem->m_nID;
					}

					// remove spaces
					hubitem->m_sHost = hubitem->m_sHost.Replace(" ","");
					
					// no port found
					if ( hubitem->m_sHost.Find(':') == -1 )
					{
						// add default port
						hubitem->m_sHost += ":411";
					}
					
					pBookmarkHubList->Add(hubitem->m_sName,hubitem);
					pBookmarkHubList_HostIndex->Add(hubitem->m_sHost.ToUpper(),new CString(hubitem->m_sName));
				}
			}
		}
	}

	delete xml;

	if ( reorder == TRUE )
	{
		hubitem = 0;

		while ( pBookmarkHubList->Next( (CObject*&)hubitem) != 0 )
		{
			if ( hubitem->m_nID == 0 )
			{
				m_nBookHubID++;
				hubitem->m_nID = m_nBookHubID;
			}
		}

		SaveDCBookHub();
	}
}

/** */
void CConfig::ParseDCLibConfig( xmlNodePtr node )
{
	CXml * xml;
	xmlNodePtr n1,n2,n3;
	CString xml_name1, xml_name2;

	xml = new CXml();

	for(n1=node;n1!=0;n1=n1->next)
	{
		xml_name1 = xml->name(n1);
		/* parse identify entrys */
		if ( xml_name1 == XML_IDENTIFY )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				xml_name2 = xml->name(n2);

				if ( xml_name2 == XML_NICK )
					sNick = xml->content(n2);
				else if ( xml_name2 == XML_SEARCHNICK )
					sSearchNick = xml->content(n2);
				else if ( xml_name2 == XML_AWAYMESSAGE )
					sAwayMessage = xml->content(n2);
				else if ( xml_name2 == XML_EMAIL )
					sEMail = xml->content(n2);
				else if ( xml_name2 == XML_ANTISPAM )
					bAntiSpam = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_DESCRIPTION )
					sDescription = xml->content(n2);
				else if ( xml_name2 == XML_AWAY_PREFIX )
					sAwayPrefix = xml->content(n2);
				else if ( xml_name2 == XML_DESCRIPTION_TAG )
					bDescriptionTag = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_SPEED )
					sSpeed = xml->content(n2);
				else if ( xml_name2 == XML_EXTENDED_HUB_COUNT )
					m_bUseExtendedHubCount = xml->getBoolChild(n2);
			}
		}
		/* parse logfile entry */
		else if ( xml_name1 == XML_LOGFILE )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				xml_name2 = xml->name(n2);

				if ( xml_name2 == XML_LOGFILENAME )
					sLogFile = xml->content(n2);
				else if ( xml_name2 == XML_LOGFILEON )
					bLogFile = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_LOGDOWNLOADS )
					bLogFinishedDownloads = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_LOGUPLOADS )
					bLogFinishedUploads = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_LOGDETAILS )
					bLogDetails = xml->getBoolChild(n2);
			}
		}
		else if ( xml_name1 == XML_SECURITY )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml->name(n2) == XML_FLOODOPKICKMESSAGE )
					sFloodOpKickMessage = xml->content(n2);
			}
		
		}
		/* parse transfer entrys */
		else if ( xml_name1 == XML_TRANSFER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				xml_name2 = xml->name(n2);

				if ( xml_name2 == XML_DOWNLOADFOLDER )
					sDownloadFolder = xml->content(n2);
				else if ( xml_name2 == XML_DOWNLOADFINISHEDFOLDER )
					sDownloadFinishedFolder = xml->content(n2);
				else if ( xml_name2 == XML_TRANSFER_AUTOSEARCH )
					bTransferAutoSearch = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_SHAREDFOLDER )
				{
					DCConfigShareFolder * csf = new DCConfigShareFolder();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						if ( xml->name(n3) == XML_PATH )
						 	csf->m_sPath = xml->content(n3);
						else if ( xml->name(n3) == XML_ALIAS )
							csf->m_sAlias = xml->content(n3);
					}

					if ( csf->m_sPath.IsEmpty() || csf->m_sAlias.IsEmpty() )
						delete csf;
					else
						SharedFolders.Add( csf );
				}
				else if ( xml_name2 == XML_AUTORECREATESHARELIST )
					bAutoRecreateShareList = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_RECREATE_SHARELIST_TIME )
					m_nRecreateShareListTime = xml->content(n2).asINT();
				else if ( xml_name2 == XML_MAXUPLOAD )
					iMaxUpload = xml->content(n2).asINT();
				else if ( xml_name2 == XML_USER_UPLOAD_SLOTS )
					iUserUploadSlots = xml->content(n2).asINT();
				else if ( xml_name2 == XML_MAXUPLOADRATE )
					lMaxUploadRate = xml->content(n2).asULL();
				else if ( xml_name2 == XML_MAXDOWNLOADRATE )
					lMaxDownloadRate = xml->content(n2).asULL();
				else if ( xml_name2 == XML_DOWNLOADQUEUETIME )
					iDownloadQueueTime = xml->content(n2).asINT();
				else if ( xml_name2 == XML_DYNAMICUPLOADRATE )
					bDynamicUploadRate = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_TRANSFER_CERT )
					m_sTransferCert = xml->content(n2);
				else if ( xml_name2 == XML_TRANSFER_KEY )
					m_sTransferKey = xml->content(n2);
				else if ( xml_name2 == XML_HUBOFFLINE_TRANSFERCLOSE )
					eHubOfflineTransferClose = (eCloseType)xml->content(n2).asINT();
				else if ( xml_name2 == XML_TRAFFIC_RX )
					CSocket::m_Traffic.AddTraffic( ettRX, xml->content(n2).asULL() );
				else if ( xml_name2 == XML_TRAFFIC_TX )
					CSocket::m_Traffic.AddTraffic( ettTX, xml->content(n2).asULL() );
				else if ( xml_name2 == XML_TRAFFIC_DATA_RX )
					CSocket::m_Traffic.AddTraffic( ettDATARX, xml->content(n2).asULL() );
				else if ( xml_name2 == XML_TRAFFIC_DATA_TX )
					CSocket::m_Traffic.AddTraffic( ettDATATX, xml->content(n2).asULL() );
				else if ( xml_name2 == XML_TRAFFIC_CONTROL_RX )
					CSocket::m_Traffic.AddTraffic( ettCONTROLRX, xml->content(n2).asULL() );
				else if ( xml_name2 == XML_TRAFFIC_CONTROL_TX )
					CSocket::m_Traffic.AddTraffic( ettCONTROLTX, xml->content(n2).asULL() );
			}
		}
		/* parse connection entrys */
		else if ( xml_name1 == XML_CONNECTION )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				xml_name2 = xml->name(n2);

				if ( xml_name2 == XML_MODE )
				{
					if ( xml->content(n2) == XML_MODE_PASSIVE )
						eMode = ecmPASSIVE;
					else
						eMode = ecmACTIVE;
				}
				else if ( xml_name2 == XML_TCPLISTENPORT )
					iTCPListenPort = xml->content(n2).asINT();
				else if ( xml_name2 == XML_UDPLISTENPORT )
					iUDPListenPort = xml->content(n2).asINT();
				else if ( xml_name2 == XML_IP )
					m_sHost = xml->content(n2);
				else if ( xml_name2 == XML_LISTENHOST )
					m_sListenHost = xml->content(n2);
				else if ( xml_name2 == XML_EXTERNALIP )
					m_bExternalIP = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_SENDMESSAGEONACTIVEMODEREQUEST )
					bSendMessageOnActiveModeRequest = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_CHECKPRIVATEADDRESSSPACE )
					bCheckPrivateAddressSpace = xml->getBoolChild(n2);
			}
		}
		/* other entrys */
		else if ( xml_name1 == XML_OTHER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				xml_name2 = xml->name(n2);

				if ( xml_name2 == XML_HUBLISTSTORELOCAL )
					bHubListStoreLocal = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_RECONNECTCOUNT )
					iReconnectCount = xml->content(n2).asINT();
				else if ( xml_name2 == XML_RECONNECTTIMEOUT )
					iReconnectTimeout = xml->content(n2).asINT();
				else if ( xml_name2 == XML_TRANSFERRESPONSETIMEOUT )
					iTransferResponseTimeout = xml->content(n2).asINT();
				else if ( xml_name2 == XML_TRANSFERRESENDTIMEOUT )
					iTransferResendTimeout = xml->content(n2).asINT();
				else if ( xml_name2 == XML_FORCEMOVEENABLED )
					bForceMoveEnabled = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_DCLIB_DATAPATH )
					m_sDCLibDataPath = xml->content(n2);
				else if ( xml_name2 == XML_CHATSENDOFFLINEMESSAGES )
					bChatSendOfflineMessages = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_CHATRECVOFFLINEMESSAGES )
					bChatRecvOfflineMessages = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_RELOAD_HUBLIST_TIME )
					m_nReloadHubListTime = xml->content(n2).asINT();
				else if ( xml_name2 == XML_DISABLEHASHLIST )
					m_bDisableHashList = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_COMPRESSEDTRANSFERS )
					m_bCompressedTransfers = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_AUTOSEARCHINTERVAL )
					m_nAutoSearchInterval = xml->content(n2).asLONG();
				else if ( xml_name2 == XML_SMALLFILESIZE )
					m_nSmallFileSize = xml->content(n2).asULL();
				else if ( xml_name2 == XML_DONTSHAREDOTFILES )
					m_bDontShareDotFiles = xml->getBoolChild(n2);
				else if ( xml_name2 == XML_REMOTE_ENCODING )
					m_sRemoteEncoding = xml->content(n2);
			}
		}
		/* parse server entrys */
		else if ( xml_name1 == XML_HUBLISTURL )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml->name(n2) == XML_URL )
				{
					DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						xml_name2 = xml->name(n3);
						if ( xml_name2 == XML_NAME )
							hublisturl->sUrl = xml->content(n3);
						else if ( xml_name2 == XML_ENABLED )
							hublisturl->bEnabled = xml->getBoolChild(n3);
					}

					if ( hublisturl->sUrl.ToUpper() != "" )
					{
						pHubListUrlList.Add(hublisturl);
					}
					else
					{
						delete hublisturl;
					}
				}
			}
		}
		/* parse search history */
		else if ( xml_name1 == XML_SEARCH_HISTORY )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml->name(n2) == XML_NAME )
					pSearchHistory->Add( new CString(xml->content(n2)) );
			}
		}
	}

	delete xml;
}

/** */
CString CConfig::GetEMail( bool raw )
{
	Thread.Lock();

	CString s;

	s = sEMail;

	if ( (raw == FALSE) && (bAntiSpam==TRUE) )
	{
		s = s.Replace( '@', " [at] " );
		s = s.Replace( '.', " [dot] " );
	}

	Thread.UnLock();

	return s;
}

/** */
CString CConfig::GetDescription( bool raw, CString hubname, CString hubhost )
{
	DCConfigHubProfile pConfigHubProfile;	
	CString s = "";
	bool tag = FALSE;
	bool prof = FALSE;
	bool extHubCount = TRUE;
	enum eClientMode mode;
	long normalHubs = 0;
	long regHubs = 0;
	long opHubs = 0;
	long totalHubs = 0;
	
	// check profile
	if ( (hubname != "") || (hubhost != "") )
	{
		if ( CConfig::Instance()->GetBookmarkHubProfile( hubname, hubhost, &pConfigHubProfile ) == TRUE )
		{
			prof = TRUE;
		}
	}

	mode = GetMode();
	
	Thread.Lock();
	
	if ( (GetAwayMode() == euamAWAY) && (raw == FALSE) )
	{
		s += sAwayPrefix;
	}

	// set tag
	if ( prof == TRUE )
	{
		tag = pConfigHubProfile.m_bTag;
		extHubCount = pConfigHubProfile.m_bExtHubCount;
	}
	else
	{
		tag = bDescriptionTag;
		extHubCount = m_bUseExtendedHubCount;
	}
	
	// set description
	if ( (prof == TRUE) && (pConfigHubProfile.m_bComment) )
	{
		s += pConfigHubProfile.m_sComment;
	}
	else
	{
		s += sDescription;
	}
	
	// Fake share bug fix :)
	s = s.Replace( '$', "_" );
	s = s.Replace( '|', "_" );

	// all bots need to check start AND end tag
	if ( (s.Find("<") != -1) && (s.Find(">") != -1) )
	{
		s = s.Replace( '<', "_" );
		s = s.Replace( '>', "_" );
	}

	if ( (tag == TRUE) && (raw == FALSE) )
	{
		s += "<DCGUI V:";
		s += VERSION;
		s += ",M:";

		switch (mode)
		{
			case ecmACTIVE:
				s += "A";
				break;
			case ecmPASSIVE:
				s += "P";
				break;
			default:
				s += "U";
				break;
		}

		s += ",H:";
		
		if (extHubCount) // long H:3/2/1 DC++ format
		{
			if ( CConnectionManager::Instance() && (CConnectionManager::Instance()->GetConnectedHubCount(FALSE) > 0))
			{
				totalHubs = CConnectionManager::Instance()->GetConnectedHubCount(FALSE);
				opHubs = totalHubs - CConnectionManager::Instance()->GetConnectedHubCount(TRUE);
				regHubs = CConnectionManager::Instance()->GetConnectedHubPasswordCount() - opHubs;
				normalHubs = totalHubs - (opHubs + regHubs);
				
				/* printf("Debug GetConnectedHubCount(FALSE): %d\n", CConnectionManager::Instance()->GetConnectedHubCount(FALSE));
				 * printf("Debug GetConnectedHubCount(TRUE): %d\n", CConnectionManager::Instance()->GetConnectedHubCount(TRUE));
				 * printf("Debug GetConnectedHubPasswordCount(): %d\n", CConnectionManager::Instance()->GetConnectedHubPasswordCount());
			 	* printf("Debug total hub count: %d\n", totalHubs);
			 	* printf("Debug OP hub count: %d\n", opHubs);
			 	* printf("Debug reg hub count: %d\n", regHubs);
			 	* printf("Debug normal hub count: %d\n", normalHubs);
			 	*/
				
				// extra sanity check
				if (normalHubs < 0)
				{
					printf("Warning! normal user hub count < 0, setting to 0\n");
					normalHubs = 0;
				}
				
				if (regHubs < 0)
				{
					printf("Warning! registered user hub count < 0, setting to 0\n");
					regHubs = 0;
				}
				
				if (opHubs < 0)
				{
					printf("Warning! operator hub count < 0, setting to 0\n");
					opHubs = 0;
				}
				
				// cannot be on zero hubs!
				// this sometimes happens when logging on to a hub
				// and the tag hasn't updated yet)
				if ( (normalHubs == 0) && (regHubs == 0) && (opHubs == 0) )
				{
					normalHubs = 1;
				}
				
				s += CString().setNum(normalHubs);
				s += "/";
				s += CString().setNum(regHubs);
				s += "/";
				s += CString().setNum(opHubs);
			}
			else
			{
				s += "1/0/0";
			}
		}
		else // short H:6 original valknut format
		{
			if ( CConnectionManager::Instance() && (CConnectionManager::Instance()->GetConnectedHubCount(TRUE) > 0) )
			{
				s += CString().setNum(CConnectionManager::Instance()->GetConnectedHubCount(TRUE));
			}
			else
			{
				s += "1";
			}
		}

		s += ",S:";

		if ( (iMaxUpload == 0) || (!CDownloadManager::Instance()) )
		{
			s += "*";
		}
		else
		{
			/* total # of slots open
			   more Hub Script DC++ Tag Checking friendly */
			s += CString().setNum(iMaxUpload);
		}

		if ( lMaxUploadRate > 0 )
		{
			s += ",L:";
			
			CString ratelimit = CString().setNum(lMaxUploadRate*1.0/1024,1);
			
			// remove trailing zero
			// in case decimal separator is ","
			if (ratelimit.Right(1) == "0")
			{
				ratelimit = ratelimit.Left(ratelimit.Length() - 2);
			}
			
			s += ratelimit;
		}

		s += ">";
	}

	Thread.UnLock();

	return s;
}

/** */
void CConfig::SetSharedFolders( CList<DCConfigShareFolder> * list )
{
	DCConfigShareFolder * csf = 0, *csf1;

	if (!list)
	{
		return;
	}

	SharedFolders.Clear();

	while ( (csf=list->Next(csf)) != 0 )
	{
		csf1 = new DCConfigShareFolder();
		csf1->m_sPath  = csf->m_sPath;
		csf1->m_sAlias = csf->m_sAlias;
		SharedFolders.Add( csf1 );
	}

	return;
}

/** */
long CConfig::GetSharedFolders( CList<DCConfigShareFolder> * list )
{
	DCConfigShareFolder * csf = 0, *csf1;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	while ( (csf=SharedFolders.Next(csf)) != 0 )
	{
		csf1 = new DCConfigShareFolder();
		csf1->m_sPath  = csf->m_sPath;
		csf1->m_sAlias = csf->m_sAlias;

		list->Add( csf1 );
	}

	return list->Count();
}

/** */
bool CConfig::RemoveBookmarkHub( CString name, CString /*host*/, CString /*description*/ )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		pBookmarkHubList_HostIndex->Del(hubitem->m_sHost.ToUpper());
		pBookmarkHubList->Del(hubitem->m_sName);
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::AddBookmarkHub( CString name, CString host, CString description )
{
	Thread.Lock();

	bool err = TRUE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	// remove spaces
	host = host.Replace(" ","");
					
	// no port found
	if ( host.Find(':') == -1 )
	{
		// add default port
		host += ":411";
	}
					
	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		// update
		hubitem->m_sHost        = host;
		hubitem->m_sDescription = description;
		hubitem->m_sDescription = description;
		err = FALSE;
	}

	if ( err == TRUE )
	{
		hubitem = new DCConfigHubItem();

		hubitem->m_nID = (++m_nBookHubID);
		hubitem->m_sName = name;
		hubitem->m_sHost = host;
		hubitem->m_sDescription = description;
		pBookmarkHubList->Add(name,hubitem);
		pBookmarkHubList_HostIndex->Add(hubitem->m_sHost.ToUpper(),new CString(hubitem->m_sName));
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::UpdateBookmarkHub( CString name, CString host, CString description )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		// remove spaces
		host = host.Replace(" ","");
					
		// no port found
		if ( host.Find(':') == -1 )
		{
			// add default port
			host += ":411";
		}

		// update
		hubitem->m_sHost        = host;
		hubitem->m_sDescription = description;
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
void CConfig::ClearPublicHubList()
{
	Thread.Lock();
	m_nPublicHubID = 0;
	pPublicHubList->Clear();
	pPublicHubList_HostIndex->Clear();
	Thread.UnLock();
}

/** */
bool CConfig::RemovePublicHub( CString name, CString /*host*/, CString /*description*/ )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	if ( pPublicHubList->Get(name.ToUpper(),(CObject*&)hubitem) == 0 )
	{
		pPublicHubList_HostIndex->Del(hubitem->m_sHost);
		pPublicHubList->Del(hubitem->m_sName.ToUpper());
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::AddPublicHub( const CString & name, const CString & host, const CString & description, const CString usercount )
{
	if ( (name == "") || (host == "") )
	{
		return FALSE;
	}

	Thread.Lock();

	bool badd = TRUE;
	DCConfigHubItem * hubitem;
	CString *ps;
	CString sname,shost,thost;
	int ucount;

	// remove spaces
	thost = host.Replace(" ","");
					
	// no port found
	if ( thost.Find(':') == -1 )
	{
		// add default port
		thost += ":411";
	}
	
	sname = name;
	sname = sname.ToUpper();
	shost = thost;
	shost = shost.ToUpper();

	hubitem = 0;

	// check for neg. usercount
	if ( (ucount = usercount.asINT()) < 0 )
	{
		ucount = 0;
	}

	if ( pPublicHubList->Get(sname,(CObject*&)hubitem) == 0 )
	{
		// hub found by name

		// remove from host index
		pPublicHubList_HostIndex->Del(hubitem->m_sHost.ToUpper());

		// if another hub with the new ip present ?
		if ( pPublicHubList_HostIndex->Get(shost,(CObject*&)ps) == 0 )
		{
			printf("double found: '%s'\n",shost.Data());

			if ( ps->ToUpper() != sname )
				pPublicHubList->Del(ps->ToUpper());

			pPublicHubList_HostIndex->Del(shost);
		}

		// remove hub from hublist
		pPublicHubList->Del(sname);
	}
	else
	{
		// hub not found, check if hub exists in the host index
		if ( pPublicHubList_HostIndex->Get(shost,(CObject*&)ps) == 0 )
		{
			// hub by host found
			if ( pPublicHubList->Get(ps->ToUpper(),(CObject*&)hubitem) == 0 )
			{
				printf("double found: '%s'\n",shost.Data());

				pPublicHubList->Del(ps->ToUpper());
				pPublicHubList_HostIndex->Del(shost);
			}
			else
			{
				printf("warning public hub list inconsistent !\n");
			}
		}
	}

	if ( badd == TRUE )
	{
		hubitem = new DCConfigHubItem();
		CIconv * ciconv = new CIconv( m_sRemoteEncoding, "UTF-8" );

		hubitem->m_nID	        = (++m_nPublicHubID);
		hubitem->m_sName        = ciconv->encode(name);
		hubitem->m_sHost        = ciconv->encode(thost);
		hubitem->m_sDescription = ciconv->encode(description);
		hubitem->m_sUserCount   = CString().setNum(ucount);
		pPublicHubList->Add(sname,hubitem);
		pPublicHubList_HostIndex->Add(shost,new CString(name));
		
		delete ciconv;
	}

	Thread.UnLock();

	return badd;
}

/** */
CString CConfig::GetListenHostString()
{
	Thread.Lock();

	CSocket Socket;
	CString s = "";

	if ( m_sListenHost != "" )
	{
		s = CSocket::GetHostByName(m_sListenHost.Replace(' ',""));
	}

	Thread.UnLock();

	return s;
}

/** */
CString CConfig::GetTCPHostString( bool addport )
{
	CSocket Socket;
	CString s = "";
	unsigned int n = 0;
	
	// get current port from listenmanager
	if ( CListenManager::Instance() )
	{
		n = CListenManager::Instance()->GetListenPort();
	}

	Thread.Lock();
	
	if ( m_sHost != "" )
	{
		if ( m_bExternalIP == TRUE )
		{
			// first we check for a cache update
			if ( (m_sHostCache == "") ||
		     	     ((time(0)-m_tHostTimeout) > 60) )
			{
				m_sHostCache   = CSocket::GetHostByName(m_sHost.Replace(' ',""));
				m_tHostTimeout = time(0);
			}

			s = m_sHostCache;
		}
		else
		{
			s = Socket.GetInterfaceIP( m_sHost.Data() );
		}
	}
	
	if ( (s != "") && (addport == TRUE) )
	{
		if ( n != 0 )
		{
			s = s + ":" + CString().setNum(n);
		}
		else
		{
			s = "";
		}
	}

	Thread.UnLock();

	return s;
}

/** */
CString CConfig::GetUDPHostString( bool addport )
{
	Thread.Lock();

	CSocket Socket;
	CString s = "";

	if ( m_sHost != "" )
	{
		if ( m_bExternalIP == TRUE )
		{
			// first we check for a cache update
			if ( (m_sHostCache == "") ||
		     	     ((time(0)-m_tHostTimeout) > 60) )
			{
				m_sHostCache   = CSocket::GetHostByName(m_sHost.Replace(' ',""));
				m_tHostTimeout = time(0);
			}

			s = m_sHostCache;
		}
		else
		{
			s = Socket.GetInterfaceIP( m_sHost.Data() );
		}
	}

	if ( (s != "") && (addport == TRUE) )
	{
		s = s + ":" + CString().setNum(iUDPListenPort);
	}

	Thread.UnLock();

	return s;
}

/**
 * check if we can resolve the ip in active mode
*/
eClientMode CConfig::GetMode( bool setting )
{
	if ( !setting && (eMode == ecmACTIVE) )
	{
		if ( GetTCPHostString() == "" )
		{
			return ecmPASSIVE;
		}
	}

	return eMode;
}

/** */
long CConfig::GetBookmarkHubList( CList<DCConfigHubItem> * list )
{
	DCConfigHubItem * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	Thread.Lock();

	while ( pBookmarkHubList->Next((CObject*&)item) != 0 )
	{
		newitem = new DCConfigHubItem( item );
		list->Add(newitem);
	}

	Thread.UnLock();

	return list->Count();
}

/** */
long CConfig::GetPublicHubList( CList<DCConfigHubItem> * list )
{
	DCConfigHubItem * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	Thread.Lock();

	while ( pPublicHubList->Next((CObject*&)item) != 0 )
	{
		newitem = new DCConfigHubItem( item );
		list->Add(newitem);
	}

	Thread.UnLock();

	return list->Count();
}

/** */
CStringList * CConfig::GetPublicHubServerList()
{
	DCConfigHubItem * item = 0;
	CStringList * StringList = 0;
	CObject * object;

	Thread.Lock();

	if ( pPublicHubList->Count() > 0 )
	{
		StringList = new CStringList();
		
		while ( pPublicHubList->Next((CObject*&)item) != 0 )
		{
			if ( StringList->Get( item->m_sHost, (CObject *&)object ) != 0 )
			{
				StringList->Add(item->m_sHost, new CString(item->m_sHost));
			}
		}
	}
	
	Thread.UnLock();

	return StringList;
}

/** */
CStringList * CConfig::GetBookmarkHubServerList()
{
	DCConfigHubItem * item = 0;
	CStringList * StringList = 0;
	CObject * object;

	Thread.Lock();

	if ( pBookmarkHubList->Count() > 0 )
	{
		StringList = new CStringList();
		
		while ( pBookmarkHubList->Next((CObject*&)item) != 0 )
		{
			if ( StringList->Get( item->m_sHost, (CObject *&)object ) != 0 )
			{
				StringList->Add(item->m_sHost, new CString(item->m_sHost));
			}
		}
	}
	
	Thread.UnLock();

	return StringList;
}

/** */
bool CConfig::GetBookmarkHub( CString name, DCConfigHubItem * hubitem )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem1;

	if ( !hubitem )
	{
		return err;
	}

	hubitem1 = 0;

	Thread.Lock();

	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem1) == 0 )
	{
		// update
		hubitem->m_sName        = hubitem1->m_sName;
		hubitem->m_sHost        = hubitem1->m_sHost;
		hubitem->m_sDescription = hubitem1->m_sDescription;
		hubitem->m_sUserCount   = hubitem1->m_sUserCount;
		hubitem->m_sProfile     = hubitem1->m_sProfile;
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::GetBookmarkHub( ulonglong id, DCConfigHubItem * hubitem )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem1;

	if ( !hubitem )
	{
		return err;
	}

	hubitem1 = 0;

	Thread.Lock();

	while ( (pBookmarkHubList->Next((CObject*&)hubitem1)) == 1 )
	{
		if ( hubitem1->m_nID == id )
		{
			hubitem->m_sName        = hubitem1->m_sName;
			hubitem->m_sHost        = hubitem1->m_sHost;
			hubitem->m_sDescription = hubitem1->m_sDescription;
			hubitem->m_sUserCount   = hubitem1->m_sUserCount;
			hubitem->m_sProfile     = hubitem1->m_sProfile;
			err = TRUE;
			break;
		}
	}

	Thread.UnLock();

	return err;
}

/** */
CString CConfig::GetNick( CString hubname, CString hubhost )
{
	DCConfigHubItem * hubitem;
	DCConfigHubProfile * profile;
	CString * ps = 0;
	CString s;

	hubitem = 0;

	Thread.Lock();

	if ( pBookmarkHubList_HostIndex->Get( hubhost.ToUpper(), (CObject*&)ps ) == 0 )
	{
		hubname = *ps;
	}

	if ( pBookmarkHubList->Get(hubname,(CObject*&)hubitem) == 0 )
	{
		if ( hubitem->m_sProfile != "" )
		{
			if ( pHubProfileList->Get( hubitem->m_sProfile, (CObject*&)profile ) == 0 )
			{
				if ( profile->m_sNick != "" )
				{
					Thread.UnLock();
					return profile->m_sNick.Replace(' ',"\xa0");
				}
			}
		}
	}

	s = CConnectionManager::Instance()->GetNick(hubname,hubhost);
	
	if ( s != "" )
	{
		Thread.UnLock();
		return s;
	}

	Thread.UnLock();

	return GetNick();
}

/** */
bool CConfig::SetBookmarkHubProfile( CString name, CString profile )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem;

	Thread.Lock();

	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		// update
		hubitem->m_sProfile = profile;

		err = TRUE;
	}

	Thread.UnLock();

	// save bookmark list
	if ( err == TRUE )
	{
		SaveDCBookHub();
	}

	return err;
}

/** */
bool CConfig::GetBookmarkHubProfile( CString name, CString host, DCConfigHubProfile * p )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem;
	DCConfigHubProfile * ConfigHubProfile;

	Thread.Lock();

	if ( host != "" )
	{
		// remove spaces
		host = host.Replace(" ","");
					
		// no port found
		if ( host.Find(':') == -1 )
		{
			// add default port
			host += ":411";
		}
	
		if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) != 0 )
		{
			CString * ps;
			if ( pBookmarkHubList_HostIndex->Get(host.ToUpper(),(CObject*&)ps) == 0 )
			{
				name = *ps;
			}
		}
	}

	if ( pBookmarkHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		if ( hubitem->m_sProfile != "" )
		{
			if ( pHubProfileList->Get( hubitem->m_sProfile, (CObject*&)ConfigHubProfile ) == 0 )
			{
				*p = ConfigHubProfile;
				err = TRUE;
			}
		}
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::GetPublicHub( CString name, DCConfigHubItem * hubitem )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem1;

	if ( !hubitem )
	{
		return err;
	}

	hubitem1 = 0;

	Thread.Lock();

	if ( pPublicHubList->Get(name.ToUpper(),(CObject*&)hubitem1) == 0 )
	{
		// update
		hubitem->m_sName        = hubitem1->m_sName;
		hubitem->m_sHost        = hubitem1->m_sHost;
		hubitem->m_sDescription = hubitem1->m_sDescription;
		hubitem->m_sUserCount   = hubitem1->m_sUserCount;
		hubitem->m_sProfile     = hubitem1->m_sProfile;
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::GetPublicHub( ulonglong id, DCConfigHubItem * hubitem )
{
	bool err = FALSE;
	DCConfigHubItem * hubitem1;

	if ( !hubitem )
	{
		return err;
	}

	hubitem1 = 0;

	Thread.Lock();

	while ( (pPublicHubList->Next((CObject*&)hubitem1)) == 1 )
	{
		if ( hubitem1->m_nID == id )
		{
			hubitem->m_sName        = hubitem1->m_sName;
			hubitem->m_sHost        = hubitem1->m_sHost;
			hubitem->m_sDescription = hubitem1->m_sDescription;
			hubitem->m_sUserCount   = hubitem1->m_sUserCount;
			hubitem->m_sProfile     = hubitem1->m_sProfile;
			err = TRUE;
			break;
		}
	}

	Thread.UnLock();

	return err;
}

/** */
long CConfig::GetHubListUrlList( CList<DCConfigHubListUrl> * list )
{
	DCConfigHubListUrl * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	Thread.Lock();

	while ( (item=pHubListUrlList.Next(item)) != 0 )
	{
		newitem = new DCConfigHubListUrl();

		newitem->bEnabled = item->bEnabled;
		newitem->sUrl     = item->sUrl;

		list->Add(newitem);
	}

	Thread.UnLock();

	return list->Count();
}

/** */
void CConfig::SetHubListUrlList( CList<DCConfigHubListUrl> * list )
{
	DCConfigHubListUrl * item = 0, *newitem;

	pHubListUrlList.Clear();

	if (!list)
	{
		return;
	}

	Thread.Lock();

	while ( (item=list->Next(item)) != 0 )
	{
		newitem = new DCConfigHubListUrl();

		newitem->bEnabled = item->bEnabled;
		newitem->sUrl     = item->sUrl;

		pHubListUrlList.Add(newitem);
	}

	Thread.UnLock();

	return;
}

/** */
bool CConfig::AddHubProfile( DCConfigHubProfile * p )
{
	bool err = FALSE;
	DCConfigHubProfile * pConfigHubProfile;

	if ( !p )
	{
		return err;
	}

	Thread.Lock();

	pConfigHubProfile = 0;

	if ( pHubProfileList->Get( p->m_sName, (CObject*&)pConfigHubProfile ) == 0 )
	{
		// update
		*pConfigHubProfile = *p;
		err = TRUE;
	}
	else
	{
		// create new entry
		pConfigHubProfile = new DCConfigHubProfile(p);
		pHubProfileList->Add(p->m_sName,pConfigHubProfile);
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::DelHubProfile( CString name )
{
	Thread.Lock();

	pHubProfileList->Del(name);

	Thread.UnLock();

	return TRUE;
}

/** */
bool CConfig::GetHubProfile( CString name, DCConfigHubProfile * p )
{
	bool err = FALSE;
	DCConfigHubProfile * pConfigHubProfile;

	Thread.Lock();

	if ( pHubProfileList->Get( name, (CObject*&)pConfigHubProfile ) == 0 )
	{
		*p = *pConfigHubProfile;
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::GetHubProfileList( CStringList * list )
{
	DCConfigHubProfile * pConfigHubProfile, *p;
	bool err = FALSE;

	if ( !list )
	{
		return err;
	}

	Thread.Lock();

	err = TRUE;

	pConfigHubProfile = 0;
	while( pHubProfileList->Next((CObject*&)pConfigHubProfile) )
	{
		p = new DCConfigHubProfile(pConfigHubProfile);

		list->Add(p->m_sName,p);
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::SaveHubProfile()
{
	bool err = FALSE;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node;
	CObject * Object;
	DCConfigHubProfile * pConfigHubProfile;
	CXml * xml;

	Thread.Lock();

	xml = new CXml();
	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCPROF_CONFIG,0);

	Object = 0;
	while(pHubProfileList->Next((CObject*&)Object))
	{
		pConfigHubProfile = (DCConfigHubProfile*)Object;

		node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_PROFILE, 0 );

		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_NAME, pConfigHubProfile->m_sName);
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_NICK, pConfigHubProfile->m_sNick);
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_PASSWORD, pConfigHubProfile->m_sPassword);
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_EMAIL, pConfigHubProfile->m_sEMail);
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_EMAIL_ENABLED, pConfigHubProfile->m_bEMail );
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_DESCRIPTION, pConfigHubProfile->m_sComment);	
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DESCRIPTION_ENABLED, pConfigHubProfile->m_bComment );
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_AUTO_CONNECT, pConfigHubProfile->m_bAutoConnect );
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_SSL, pConfigHubProfile->m_bSSL );
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_DESCRIPTION_TAG, pConfigHubProfile->m_bTag );
		xml->xmlNewBoolChild( node, 0, (const xmlChar*)XML_EXTENDED_HUB_COUNT, pConfigHubProfile->m_bExtHubCount );
		xml->xmlNewStringChild( node, 0, (const xmlChar*)XML_SUPPRESSED_NICKS, pConfigHubProfile->m_sSuppressedNicks );
	}

	s = sConfigPath + DCPROF_CONFIG;

	if ( ! (SaveConfigXmlViaTemp(s,doc) == -1) )
	{
		err = TRUE;
	}

	xmlFreeDoc(doc);
	delete xml;

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::LoadHubProfile()
{
	bool err = TRUE;
	CString s, xml_name;
	DCConfigHubProfile * pConfigHubProfile;
	CXml *xml;
	xmlNodePtr n1,n2,node;

	Thread.Lock();

	xml = new CXml();

	s = sConfigPath + DCPROF_CONFIG;

	if ( xml->ParseFile(s) == TRUE )
	{
		for(node=xml->doc()->children;node!=0;node=node->next)
		{
			if ( xml->name(node) == XML_DCPROF_CONFIG )
			{
				for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
				{
					if ( xml->name(n1) == XML_PROFILE )
					{
						pConfigHubProfile = new DCConfigHubProfile();

						for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
						{
							xml_name = xml->name(n2);
							if ( xml_name == XML_NAME )
								pConfigHubProfile->m_sName = xml->content(n2);
							else if ( xml_name == XML_NICK )
								pConfigHubProfile->m_sNick = xml->content(n2);
							else if ( xml_name == XML_PASSWORD )
								pConfigHubProfile->m_sPassword = xml->content(n2);
							else if ( xml_name == XML_EMAIL )
								pConfigHubProfile->m_sEMail = xml->content(n2);
							else if ( xml_name == XML_DESCRIPTION )
								pConfigHubProfile->m_sComment = xml->content(n2);
							else if ( xml_name == XML_AUTO_CONNECT )
								pConfigHubProfile->m_bAutoConnect = xml->getBoolChild(n2);
							else if ( xml_name == XML_SSL )
								pConfigHubProfile->m_bSSL = xml->getBoolChild(n2);
							else if ( xml_name == XML_DESCRIPTION_TAG )
								pConfigHubProfile->m_bTag = xml->getBoolChild(n2);
							else if ( xml_name == XML_DESCRIPTION_ENABLED )
								pConfigHubProfile->m_bComment = xml->getBoolChild(n2);
							else if ( xml_name == XML_EMAIL_ENABLED )
								pConfigHubProfile->m_bEMail = xml->getBoolChild(n2);
							else if ( xml_name == XML_EXTENDED_HUB_COUNT )
								pConfigHubProfile->m_bExtHubCount = xml->getBoolChild(n2);
							else if ( xml_name == XML_SUPPRESSED_NICKS )
								pConfigHubProfile->m_sSuppressedNicks = xml->content(n2);
						}

						if ( pConfigHubProfile->m_sName != "" )
							pHubProfileList->Add(pConfigHubProfile->m_sName,pConfigHubProfile);
						else
							delete pConfigHubProfile;
					}
				}
			}
		}
	}

	delete xml;

	Thread.UnLock();

	return err;
}

/** */
void CConfig::GetSearchHistory( CList<CString> * list )
{
	CString *ps;

	if ( !list )
	{
		return;
	}

	Thread.Lock();

	ps = 0;

	while ( (ps=pSearchHistory->Next(ps)) != 0 )
	{
		list->Add( new CString(*ps) );
	}

	Thread.UnLock();
}

/** */
void CConfig::AddSearchHistory( CString s )
{
	CString *ps;

	if ( s == "" )
	{
		return;
	}

	Thread.Lock();

	ps = 0;

	while ( (ps=pSearchHistory->Next(ps)) != 0 )
	{
		if ( *ps == s )
		{
			pSearchHistory->Del(ps);
			ps = 0;
			break;
		}
	}

	// not found
	if ( ps == 0 )
	{
		if ( pSearchHistory->Count() == 10 )
		{
			// delete first entry
			ps = pSearchHistory->Next(0);
			pSearchHistory->Del(ps);
		}

		pSearchHistory->Add( new CString(s) );
	}

	Thread.UnLock();

	SaveDCLib();
}

/** */
CString CConfig::AliasToPath( CString file )
{
	int i;
	CString s,s1,sfile,sdir;
	DCConfigShareFolder * csf;
	CDir dir;

	Thread.Lock();

	if ( SharedFolders.Count() <= 0 )
	{
		Thread.UnLock();
		return "";
	}

	// simple filename
	sfile = dir.SimplePath(file);

	if ( sfile == "" )
	{
		Thread.UnLock();
		return "";
	}

	// get the first directory
	i = sfile.Find(DIRSEPARATOR);

	if ( i == -1 )
	{
		sdir  = sfile;
		sfile = "";

		// get directory ...
		Thread.UnLock();
		return "";
	}
	else
	{
		sdir  = sfile.Left(i);
		sfile = sfile.Mid(i+1,sfile.Length()-1-i);
	}

	if ( sfile == "" )
	{
		// get directory ...
		Thread.UnLock();
		return "";
	}

	csf = 0;
	while( (csf=SharedFolders.Next(csf)) != 0 )
	{
		// check for correct alias
		if ( csf->m_sAlias != sdir )
		{
			continue;
		}

		// set correct path
		s = csf->m_sPath;

		// is valid ?
		if ( dir.cd(s) == TRUE )
		{
			s1 = DIRSEPARATOR + sfile;

			if ( dir.IsFile(s1) == TRUE )
			{
				// check filesize
				if ( dir.getFileSize(s1) > 0 )
				{
					s += DIRSEPARATOR + sfile;
					s = dir.SimplePath(s);
					Thread.UnLock();
					return s;
				}
			}
		}
	}

	Thread.UnLock();

	return "";
}

/** */
int CConfig::SaveConfigXmlViaTemp(CString filename, xmlDocPtr doc)
{
	int ret1, ret2, ret3;
	ret1 = xmlSaveFormatFileEnc( (filename+".tmp").Data(), doc, "utf-8", 1 );
	
	if (ret1 == -1)
	{
		printf("Error saving %s\n", (filename+".tmp").Data());
		return -1;
	}
	else
	{
		// check that the file exists before trying to delete it
		// this is so valknut will work when first run
		CFile configfile;
		if ( configfile.Open(filename, IO_READONLY) == TRUE )
		{
			configfile.Close();
			ret2 = remove(filename.Data());
			if (ret2 == -1)
			{
				perror(("Removing " + filename + " failed").Data());
				return -1;
			}
		}
		else
		{
			printf("No existing config file %s to remove\n", filename.Data());
		}
		
		ret3 = rename( (filename+".tmp").Data(), filename.Data() );
		if (ret3 == -1)
		{
			perror(("Renaming temp to " + filename + " failed").Data());
			return -1;
		}
		else
		{
			// all operations successful
			return ret1;
		}
	}
}
