/***************************************************************************
                          cmessagehandler.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <dclib/dcos.h>
#include <dclib/cencrypt.h>
#include <dclib/dcobject.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/cbase64.h>

#include "cmessagehandler.h"

// parsed messages
#define DC_S_MESSAGE_CHAT 		"<"
#define DC_S_MESSAGE_SEARCH 		"$Search "
#define DC_S_MESSAGE_MYINFO 		"$MyINFO "
#define DC_S_MESSAGE_HELLO 		"$Hello "
#define DC_S_MESSAGE_QUIT 		"$Quit "
#define DC_S_MESSAGE_NICKLIST 		"$NickList "
#define DC_S_MESSAGE_OPLIST 		"$OpList "
#define DC_S_MESSAGE_CONNECTTOME 	"$ConnectToMe "
#define DC_S_MESSAGE_KEY 		"$Key "
#define DC_S_MESSAGE_HUBNAME 		"$HubName "
#define DC_S_MESSAGE_LOCK 		"$Lock "
#define DC_S_MESSAGE_TO 		"$To: "
#define DC_S_MESSAGE_FORCEMOVE 		"$ForceMove "
#define DC_S_MESSAGE_REVCONNECTTOME 	"$RevConnectToMe "
#define DC_S_MESSAGE_SR 		"$SR "
#define DC_S_MESSAGE_MYNICK 		"$MyNick "
#define DC_S_MESSAGE_DIRECTION 		"$Direction "
#define DC_S_MESSAGE_MAXEDOUT 		"$MaxedOut"	// no free slots
#define DC_S_MESSAGE_FILELENGTH 	"$FileLength "	// recv. file
#define DC_S_MESSAGE_GET 		"$Get "
#define DC_S_MESSAGE_ERROR		"$Error "
#define DC_S_MESSAGE_GETLISTLEN		"$GetListLen"
#define DC_S_MESSAGE_VALIDATEDENIDE 	"$ValidateDenide"  //hub login failed ...
#define DC_S_MESSAGE_HUBISFULL 		"$HubIsFull"
#define DC_S_MESSAGE_LISTLEN		"$ListLen "
#define DC_S_MESSAGE_SEND		"$Send"
#define DC_S_MESSAGE_GETINFO 		"$GetINFO "
#define DC_S_MESSAGE_PING 		"$Ping"
#define DC_S_MESSAGE_GETPASS 		"$GetPass"
#define DC_S_MESSAGE_BADPASS 		"$BadPass"
#define DC_S_MESSAGE_LOGEDIN		"$LogedIn"
#define DC_S_MESSAGE_CANCEL		"$Cancel"
#define DC_S_MESSAGE_CANCELED		"$Canceled"
#define DC_S_MESSAGE_SUPPORTS		"$Supports "
#define DC_S_MESSAGE_CAPABILITIES	"$Capabilities "
#define DC_S_MESSAGE_HUB_TOPIC		"$HubTopic "
#define DC_S_MESSAGE_GET_NET_INFO	"$GetNetInfo"
#define DC_S_MESSGAE_USER_IP		"$UserIP "
// ignored messages
#define DC_S_MESSAGE_MULTISEARCH	"$MultiSearch "
#define DC_S_MESSAGE_USER_COMMAND	"$UserCommand "

// todo: parse
#define DC_S_MESSAGE_AGE 		"age="		// age=NEWS ... ???
#define DC_S_EXTRA_DCPLUS		"$DCPlus "
#define DC_S_YOUR_IP			"$YourIP "
#define DC_S_USER_COMMAND		"$UserCommand " // ??? ( $UserCommand 0 / $UserCommand 1 Read Help$<%[mynick]> +help&#124;<%[mynick]> -help&#124; )

CMessageHandler::CMessageHandler()
{
}

CMessageHandler::~CMessageHandler()
{
}

int CMessageHandler::GetContent( const CString sMessage, const CString * sData, CString & sContent )
{
	if ( sMessage == sData->Left(sMessage.Length()))
	{
		sContent = sData->Mid(sMessage.Length(),sData->Length()-sMessage.Length());
		return 0;
	}

	return -1;
}

/** */
eDCMessage CMessageHandler::Parse( const CString * sMessage, int & pointer, CObject *& Object  )
{
	CString t;
	CString sContent;
	int old_index,index;

	old_index = index = pointer;

	Object = 0;

	index = sMessage->Find('|',index);

	if ( index >= 0 )
	{
		pointer = index+1;

		t = sMessage->Mid(old_index,index-old_index);

		if ( "" == t )
		{
			if ( old_index != index )
			{
				printf("!!!!!!! PARSER ERROR index: %d %d\n",old_index,index);
				printf("%s\n",sMessage->Data());
			}
			return DC_MESSAGE_UNKNOWN;
		}

		// check chat
		if ( GetContent(DC_S_MESSAGE_CHAT,&t,sContent) != -1 )
		{
			sContent = t;

			Object  = ParseChat(sContent);

			return DC_MESSAGE_CHAT;
		}
		// check another chat
		else if ( t.Data()[0] != '$' )
		{
			sContent = t;

			Object  = ParseChat(sContent);

			return DC_MESSAGE_CHAT;
		}
		else if ( GetContent(DC_S_MESSAGE_SEARCH,&t,sContent) != -1 )
		{
			Object = ParseSearch(sContent);

			return DC_MESSAGE_SEARCH;
		}
		else if ( GetContent(DC_S_MESSAGE_MYINFO,&t,sContent) != -1 )
		{
			Object  = ParseMyInfo(sContent);

			return DC_MESSAGE_MYINFO;
		}
		else if ( GetContent(DC_S_MESSAGE_HELLO,&t,sContent) != -1 )
		{
			Object  = ParseHello(sContent);

			return DC_MESSAGE_HELLO;
		}
		else if ( GetContent(DC_S_MESSAGE_QUIT,&t,sContent) != -1 )
		{
			Object  = ParseQuit(sContent);

			return DC_MESSAGE_QUIT;
		}
		else if ( GetContent(DC_S_MESSAGE_NICKLIST,&t,sContent) != -1 )
		{
			Object = ParseNickList(sContent);

			return DC_MESSAGE_NICKLIST;
		}
		else if ( GetContent(DC_S_MESSAGE_OPLIST,&t,sContent) != -1 )
		{
			Object = ParseOpList(sContent);

			return DC_MESSAGE_OPLIST;
		}
		else if ( GetContent(DC_S_MESSAGE_CONNECTTOME,&t,sContent) != -1 )
		{
			Object  = ParseConnectToMe(sContent);

			return DC_MESSAGE_CONNECTTOME;
		}
		else if ( GetContent(DC_S_MESSAGE_KEY,&t,sContent) != -1 )
		{
			Object = new CMessageKey();

			return DC_MESSAGE_KEY;
		}
		else if ( GetContent(DC_S_MESSAGE_HUBNAME,&t,sContent) != -1 )
		{
			Object  = ParseHubName(sContent);

			return DC_MESSAGE_HUBNAME;
		}
		else if ( GetContent(DC_S_MESSAGE_LOCK,&t,sContent) != -1 )
		{
			Object  = ParseLock(sContent);

			return DC_MESSAGE_LOCK;
		}
		else if ( GetContent(DC_S_MESSAGE_TO,&t,sContent) != -1 )
		{
			Object  = ParsePrivateChat(sContent);

			return DC_MESSAGE_PRIVATECHAT;
		}
		else if ( GetContent(DC_S_MESSAGE_FORCEMOVE,&t,sContent) != -1 )
		{
			Object  = ParseForceMove(sContent);

			return DC_MESSAGE_FORCEMOVE;
		}
		else if ( GetContent(DC_S_MESSAGE_REVCONNECTTOME,&t,sContent) != -1 )
		{
			Object  = ParseRevConnectToMe(sContent);

			return DC_MESSAGE_REVCONNECTTOME;
		}
		else if ( GetContent(DC_S_MESSAGE_SR,&t,sContent) != -1 )
		{
			Object = ParseSearchResult(sContent);

			return DC_MESSAGE_SEARCHRESULT;
		}
		else if ( GetContent(DC_S_MESSAGE_MYNICK,&t,sContent) != -1 )
		{
			Object  = ParseMyNick(sContent);

			return DC_MESSAGE_MYNICK;
		}
		else if ( GetContent(DC_S_MESSAGE_DIRECTION,&t,sContent) != -1 )
		{
			Object = ParseDirection(sContent);

			return DC_MESSAGE_DIRECTION;
		}
		else if ( GetContent(DC_S_MESSAGE_FILELENGTH,&t,sContent) != -1 )
		{
			Object = ParseFileLength(sContent);

			return DC_MESSAGE_FILELENGTH;
		}
		else if ( GetContent(DC_S_MESSAGE_LISTLEN,&t,sContent) != -1 )
		{
			Object = ParseFileLength(sContent);

			return DC_MESSAGE_LISTLEN;
		}
		else if ( GetContent(DC_S_MESSAGE_GET,&t,sContent) != -1 )
		{
			Object = ParseGet(sContent);

			return DC_MESSAGE_GET;
		}
		else if ( GetContent(DC_S_MESSAGE_ERROR,&t,sContent) != -1 )
		{
			Object = ParseError(sContent);

			return DC_MESSAGE_ERROR;
		}
		else if ( GetContent(DC_S_MESSAGE_GETINFO,&t,sContent) != -1 )
		{
			Object = ParseGetInfo(sContent);

			return DC_MESSAGE_GETINFO;
		}
		else if ( GetContent(DC_S_MESSAGE_MAXEDOUT,&t,sContent) != -1 )
		{
			Object = new CMessageMaxedOut();

			return DC_MESSAGE_MAXEDOUT;
		}
		else if ( GetContent(DC_S_MESSAGE_CANCEL,&t,sContent) != -1 )
		{
			Object = new CMessageCancel();

			return DC_MESSAGE_CANCEL;
		}
		else if ( GetContent(DC_S_MESSAGE_CANCELED,&t,sContent) != -1 )
		{
			Object = new CMessageCanceled();

			return DC_MESSAGE_CANCELED;
		}
		else if ( GetContent(DC_S_MESSAGE_SEND,&t,sContent) != -1 )
		{
			Object = new CMessageSend();

			return DC_MESSAGE_SEND;
		}
		else if ( GetContent(DC_S_MESSAGE_GETLISTLEN,&t,sContent) != -1 )
		{
			Object = new CMessageGetListLen();

			return DC_MESSAGE_GETLISTLEN;
		}
		else if ( GetContent(DC_S_MESSAGE_VALIDATEDENIDE,&t,sContent) != -1 )
		{
			Object = new CMessageValidateDenide();

			return DC_MESSAGE_VALIDATEDENIDE;
		}
		else if ( GetContent(DC_S_MESSAGE_HUBISFULL,&t,sContent) != -1 )
		{
			Object = new CMessageHubIsFull();

			return DC_MESSAGE_HUBISFULL;
		}
		else if ( GetContent(DC_S_MESSAGE_PING,&t,sContent) != -1 )
		{
			Object = new CMessagePing();

			return DC_MESSAGE_PING;
		}
		else if ( GetContent(DC_S_MESSAGE_GETPASS,&t,sContent) != -1 )
		{
			Object = new CMessageGetPass();

			return DC_MESSAGE_GETPASS;
		}
		else if ( GetContent(DC_S_MESSAGE_BADPASS,&t,sContent) != -1 )
		{
			Object = new CMessageBadPass();

			return DC_MESSAGE_BADPASS;
		}
		else if ( GetContent(DC_S_MESSAGE_LOGEDIN,&t,sContent) != -1 )
		{
			Object = ParseLogedIn(sContent);

			return DC_MESSAGE_LOGEDIN;
		}
		else if ( GetContent(DC_S_MESSAGE_SUPPORTS,&t,sContent) != -1 )
		{
			Object = ParseSupports(sContent);

			return DC_MESSAGE_SUPPORTS;
		}
		else if ( GetContent(DC_S_MESSAGE_CAPABILITIES,&t,sContent) != -1 )
		{
			Object = ParseCapabilities(sContent);

			return DC_MESSAGE_CAPABILITIES;
		}
		else if ( GetContent(DC_S_MESSAGE_HUB_TOPIC,&t,sContent) != -1 )
		{
			Object = ParseHubTopic(sContent);

			return DC_MESSAGE_HUB_TOPIC;
		}
		else if ( GetContent(DC_S_MESSAGE_GET_NET_INFO,&t,sContent) != -1 )
		{
			Object = new CMessageGetNetInfo();

			return DC_MESSAGE_GET_NET_INFO;
		}
		else if ( GetContent(DC_S_MESSAGE_USER_COMMAND,&t,sContent) != -1 )
		{
			Object = ParseUserCommand(sContent);

			return DC_MESSAGE_USER_COMMAND;
		}
		else
		{
			printf("!!!!!!!!!!!!!! unknown start ");
			printf("index: %d %d!!!!!!!!!!!!!!\n",old_index,index);
			printf("%s\n",t.Data());
			printf("!!!!!!!!!!!!!! unknown end !!!!!!!!!!!!!!\n");
			return DC_MESSAGE_UNKNOWN;
		}
	}
	else
	{
//		printf("%s\n",sMessage.Data());
	}

	return DC_MESSAGE_PARSE_ERROR;
}

/** */
CObject * CMessageHandler::ParseLock( CString sContent )
{
	CBase64 base64;
	CMessageLock * msg=0;
	CByteArray out;
	CString s;

	int i,i1;

	i = sContent.Find(' ');

	if ( (msg = new CMessageLock()) != 0 )
	{
		// lock without pk
		if ( i < 0 )
		{
			msg->m_sData = sContent;
			msg->m_sPK   = "";
		}
		else
		{
			msg->m_sData = sContent.Left(i);
			msg->m_sPK   = sContent.Mid(i+4,sContent.Length()-i-4);
		}

//		printf("TR: '%s' '%s'\n",msg->m_sData.Data(),msg->m_sPK.Data());

		if ( msg->m_sData.Find("EXTENDEDPROTOCOL") == 0)
		{
			msg->m_bExtProtocol = TRUE;
		}

		// DC++ client
		if ( (i1=msg->m_sPK.Find("DCPLUSPLUS")) == 0 )
		{
			msg->m_eClientVersion = eucvDCPP;

			if ( (i = msg->m_sPK.Find("ABC")) != -1 )
			{
				msg->m_sVersionString = msg->m_sPK.Mid(i1+10,i-10);
			}
		}
		// DC++H Hub
		else if ( (i1=msg->m_sPK.Find("DCHUBPLUSPLUS")) == 0 )
		{
			msg->m_eClientVersion = eucvDCHPP;

			if ( (i = msg->m_sPK.Find("ABC")) != -1 )
			{
				msg->m_sVersionString = msg->m_sPK.Mid(i1+13,i-13);
			}
		}
		// PtokaX Hub
		else if ( (i1=msg->m_sPK.Find("PTOKAX")) == 0 )
		{
			msg->m_eClientVersion = eucvPTOKAX;
		}
		// ZPoc Hub
		else if ( (i1=msg->m_sPK.Find("ZPOCCHRISITAN")) == 0 )
		{
			msg->m_eClientVersion = eucvZPOC;
		}
		// opendcd Hub
		else if ( (i1=msg->m_sPK.Find("opendcd")) == 0 )
		{
			msg->m_eClientVersion = eucvOPENDCD;
		}
		// DCGUI client
		else if ( (i1=msg->m_sPK.Find("DCGUI")) == 0 )
		{
			msg->m_eClientVersion = eucvDCGUI;
		}

		if ( msg->m_sVersionString != "" )
		{
			if ( (i=msg->m_sVersionString.Find('.')) != -1 )
			{
				msg->m_nVersionMajor = msg->m_sVersionString.Mid(0,i).asINT();
				i++;
				if ( (i1=msg->m_sVersionString.Find('.',i)) != -1 )
				{
					msg->m_nVersionMinor = msg->m_sVersionString.Mid(i,msg->m_sVersionString.Length()-i1).asINT();
					i=i1+1;
					msg->m_nVersionPatch = msg->m_sVersionString.Mid(i,msg->m_sVersionString.Length()-i).asINT();
				}
				else
				{
					msg->m_nVersionMinor = msg->m_sVersionString.Mid(i,msg->m_sVersionString.Length()-i).asINT();
				}
			}
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseHello( CString sContent )
{
	CMessageHello * msg=0;

	if ( (msg = new CMessageHello()) != 0 )
	{
		msg->m_sNick = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseMyNick( CString sContent )
{
	CMessageMyNick * msg=0;

	if ( (msg = new CMessageMyNick()) != 0 )
	{
		msg->m_sNick = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseChat( CString sContent )
{
	CMessageChat * msg=0;

	int i=-1,i1=-1;

	if ( (i=sContent.Find('<')) != -1 )
		i1 = sContent.Find('>',i+1);

	if ( (msg = new CMessageChat()) != 0 )
	{
		if ( (i != -1) && (i1 != -1) )
		{
			msg->m_sNick    = sContent.Mid(i+1,i1-1);
			// check if after the '>' a space
			if ( sContent.Data()[i1+1] == ' ' )
				i1++;

			msg->m_sMessage = sContent.Mid(i1+1,sContent.Length()-i1-1);
		}
		else
		{
			// no < nick > found ... use complete message
			msg->m_sMessage = sContent;
		}

		// reconvert dcproto chars
		msg->m_sMessage = msg->m_sMessage.Replace( "&#36;", "$" );
		msg->m_sMessage = msg->m_sMessage.Replace( "&#124;", "|" );
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseMyInfo( CString sContent )
{
	CMessageMyInfo * msg=0;
	CString s;
	int i,i1,i2,i3,i4,i5,i6;
	char c;

	// dest e.g. $ALL
	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(' ',i+1)) < 0 )
		return 0;

	if ( (i2=sContent.Find('$',i1+1)) < 0 )
		return 0;

	if ( (i3=sContent.Find('$',i2+1)) < 0 )
		return 0;

	if ( (i4=sContent.Find('$',i3+1)) < 0 )
		return 0;

	if ( (i5=sContent.Find('$',i4+1)) < 0 )
		return 0;

	if ( (i6=sContent.Find('$',i5+1)) < 0 )
		return 0;

	if ( (msg = new CMessageMyInfo()) != 0 )
	{
		msg->m_sNick    = sContent.Mid(i +1,i1-i -1);
		msg->m_sUnknown = sContent.Mid(i2+1,i3-i2-1);

		c = 1;

		// check user mode
		if ( (i4-i3-1) > 0 )
		{
			c = sContent.Data()[i4-1];

			switch(c)
			{
				case 1:
					c = 2;
					msg->m_eAwayMode = euamNORMAL;
					break;
				case 2:
				case 3:
					c = 2;
					msg->m_eAwayMode = euamAWAY;
					break;
				case 4:
				case 5:
					c = 2;
					msg->m_eAwayMode = euamNORMAL;
					break;
				case 6:
				case 7:
					c = 2;
					msg->m_eAwayMode = euamAWAY;
					break;
				case 8:
				case 9:
					c = 2;
					msg->m_eAwayMode = euamNORMAL;
					break;
				case 10:
				case 12:
					c = 2;
					msg->m_eAwayMode = euamAWAY;
					break;
				case 11:
				case 15:
					c = 2;
					msg->m_eAwayMode = euamNORMAL;
					break;
				default:
					c = 1;
					msg->m_eAwayMode = euamNORMAL;
					break;
			}
		}

		s = sContent.Mid(i3+1,i4-i3-c);

		if ( s == "28.8Kbps" )
			msg->m_eUserSpeed = eus288KBPS;
		else if ( s == "33.6Kbps" )
			msg->m_eUserSpeed = eus288KBPS;
		else if ( s == "56Kbps" )
			msg->m_eUserSpeed = eus56KBPS;
		else if ( s == "ISDN" )
			msg->m_eUserSpeed = eusISDN;
		else if ( s == "DSL" )
			msg->m_eUserSpeed = eusDSL;
		else if ( s == "Satellite" )
			msg->m_eUserSpeed = eusSATELLITE;
		else if ( s == "Cable" )
			msg->m_eUserSpeed = eusCABLE;
		else if ( s == "LAN(T1)" )
			msg->m_eUserSpeed = eusLANT1;
		else if ( s == "LAN(T3)" )
			msg->m_eUserSpeed = eusLANT3;
		else if ( s == "Wireless" )
			msg->m_eUserSpeed = eusWIRELESS;
		else if ( s == "Microwave" )
			msg->m_eUserSpeed = eusMICROWAVE;
		else
			msg->m_eUserSpeed = eusUNKNOWN;

		msg->m_sUserSpeed = s;
		msg->m_sEMail = sContent.Mid(i4+1,i5-i4-1);

		s = sContent.Mid(i5+1,i6-i5-1);
		msg->m_nShared = s.asULL();

		// parse comment
		s = sContent.Mid(i1+1,i2-i1-1);

		// find version start tag
		if ( (i=s.FindRev("<++ ")) != -1 )
			msg->m_eClientVersion = eucvDCPP;
		else if ( (i=s.FindRev("<DCGUI ")) != -1 )
			msg->m_eClientVersion = eucvDCGUI;
		else if ( (i=s.FindRev("<DCTC ")) != -1 )
			msg->m_eClientVersion = eucvDCTC;
		else if ( (i=s.FindRev("<DC ")) != -1 )
			msg->m_eClientVersion = eucvNMDC;
		else if ( (i=s.FindRev("<QuickDC ")) != -1 )
			msg->m_eClientVersion = eucvQUICKDC;
		else if ( (i=s.FindRev("<oDC ")) != -1 )
			msg->m_eClientVersion = eucvOPERADC;
		else if ( (i=s.FindRev("<SdDC++ ")) != -1 )
			msg->m_eClientVersion = eucvSDDC;
		else if ( (i=s.FindRev("<StrgDC++ ")) != -1 )
			msg->m_eClientVersion = eucvSTRGDCPP;
		else if ( (i=s.FindRev("<RMDC++ ")) != -1 )
			msg->m_eClientVersion = eucvRMDC;
		else if ( (i=s.FindRev("<DC:PRO ")) != -1 )
			msg->m_eClientVersion = eucvDCPRO;
		else if ( (i=s.FindRev("<iDC")) != -1 )
			msg->m_eClientVersion = eucvIDC;

		msg->m_eClientMode = ecmPASSIVE;

		// find version end tag
		if ( (i!=-1) && ((i1=s.Find('>',i)) != -1) )
		{
			msg->m_sComment    = s.Left(i);
			msg->m_sVerComment = s.Mid(i,i1-i+1);

			// search for the active tag
			// A: active, P: passive 5: socks5
			if ( msg->m_sVerComment.Find("M:A") != -1 )
			{
				msg->m_eClientMode = ecmACTIVE;
			}
		}
		else
		{
			msg->m_sComment       = s;
			msg->m_eClientVersion = eucvNONE;
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseConnectToMe( CString sContent )
{
	CMessageConnectToMe * msg=0;
	CString s;

	int i,i1;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (i1=sContent.Find(':',i+1)) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageConnectToMe()) != 0 )
	{
		msg->m_sNick = sContent.Mid(0,i);
		msg->m_sHost = sContent.Mid(i+1,i1-i-1);

		s = sContent.Mid(i1+1,sContent.Length()-i1-1);

		if ( s == "" )
		{
			msg->m_nPort = 411;
		}
		else
		{
			msg->m_nPort = s.asINT();
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseRevConnectToMe( CString sContent )
{
	CMessageRevConnectToMe * msg=0;

	int i;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageRevConnectToMe()) != 0 )
	{
		msg->m_sDstNick = sContent.Mid(0,i);
		msg->m_sNick    = sContent.Mid(i+1,sContent.Length()-i-1);
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseNickList( CString sContent )
{
	CMessageNickList * msg=0;
	int i,i1;

	i = i1 = 0;

	msg = new CMessageNickList();

	while ( (i=sContent.Find('$',i)) >= 0 )
	{
		CString s;

		s = sContent.Mid(i1,i-i1);

		msg->m_NickList.Add(new CString(s));

		i+=2;
		i1=i;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseOpList( CString sContent )
{
	CMessageNickList * msg=0;
	int i,i1;

	i = i1 = 0;

	msg = new CMessageNickList();

	while ( (i=sContent.Find('$',i)) >= 0 )
	{
		CString s;

		s = sContent.Mid(i1,i-i1);

		msg->m_NickList.Add(new CString(s));

		i+=2;
		i1=i;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseQuit( CString sContent )
{
	CMessageQuit * msg= new CMessageQuit();

	msg->m_sNick = sContent;

	return msg;
}

/** */
CObject * CMessageHandler::ParseSearch( CString sContent )
{
	CMessageSearch * msg=0;

	CString s,s1;
	int t,i,i1,i2,i3,i4,i5,i6;

//	printf("Entering PARSESEARCH\n");
	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find('?',i+1)) < 0 )
		return 0;

	if ( (i2=sContent.Find('?',i1+1)) < 0 )
		return 0;

	if ( (i3=sContent.Find('?',i2+1)) < 0 )
		return 0;

	if ( (i4=sContent.Find('?',i3+1)) < 0 )
		return 0;

	s = sContent.Left(i);

	if ( (i5 = s.Find(':')) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageSearch()) != 0 )
	{
		s1 = s.Left(i5+1);

		if ( s1 == "Hub:" )
		{
			msg->m_bLocal  = TRUE;
			msg->m_sSource = s.Mid(i5+1,s.Length()-i5-1);
		}
		else
		{
			// parse the host string
			msg->m_bLocal  = FALSE;

			i6 = s.Find(':');

			if ( i6 > 0 )
			{
				s1 = s.Mid(i6+1,s.Length()-i6-1);
			}
			else
			{
				s1 = "";
			}

			if ( (i6 < 0) || (s1 == "") )
			{
				msg->m_sSource = s;
				msg->m_nPort   = 411;
			}
			else
			{
				msg->m_sSource = s.Mid(0,i6);
				msg->m_nPort   = s1.asINT();
			}
		}

		// sizelimit
		if ( sContent.Mid(i+1,i1-i-1) == "F" )
			msg->m_bSizeLimit = FALSE;
		else
			msg->m_bSizeLimit = TRUE;

		// at most or at least
		if ( sContent.Mid(i1+1,i2-i1-1) == "F" )
			msg->m_bSizeAtMost = FALSE;
		else
			msg->m_bSizeAtMost = TRUE;

		// size
		s1 = sContent.Mid(i2+1,i3-i2-1);
		msg->m_nSize = s1.asULL();

		// type
		s1 = sContent.Mid(i3+1,i4-i3-1);
		t = s1.asINT();

		switch(t)
		{
			case 1:
				msg->m_eFileType = eftALL;
				break;
			case 2:
				msg->m_eFileType = eftMP3;
				break;
			case 3:
				msg->m_eFileType = eftARCHIVE;
				break;
			case 4:
				msg->m_eFileType = eftDOCUMENT;
				break;
			case 5:
				msg->m_eFileType = eftAPPLICATION;
				break;
			case 6:
				msg->m_eFileType = eftPICTURE;
				break;
			case 7:
				msg->m_eFileType = eftVIDEO;
				break;
			case 8:
				msg->m_eFileType = eftFOLDER;
				break;
			default:
				msg->m_eFileType = eftUNKNOWN;
				break;
		}

		// the search string
		s = sContent.Mid(i4+1,sContent.Length()-i4-1);

		// check if ext proto
		/*
			STRING: EXT<BASE64>
			BASE64: XYEXT:<PROTO>
			X     : PADDING TO EVEN LENGTH
			Y     : UNSIGNED CHAR <> 0
		*/
		msg->m_bExtended = FALSE;

		if ( (i=s.Find("EXT")) == 0 )
		{
			CBase64 base64;
			CByteArray in,out;

			s1 = s.Mid(i+3,s.Length()-i-3);

			in.SetSize(0);
			in.Append( (unsigned char*)s1.Data(), s1.Length()+1 );
			i = base64.Decode(&out,&in);
			if ( i > 5 )
			{
				s1.Set( (char*)out.Data(), out.Size() );
				i=s1.Find("EXT:");
				if ( (i == 1) || (i==2) )
				{
					printf("Found ext decode: '%s'\n",s1.Data());
					s = s1.Mid(i+4,s1.Length()-i-4);
					msg->m_bExtended = TRUE;
				}
			}
		}

		msg->m_sString = s.Replace('$'," ");
	}
//	printf("Quitting PARSESEARCH\n");

	return msg;
}

/** */
CObject * CMessageHandler::ParseSearchResult( CString sContent )
{
	CMessageSearchResult * msg=0;
	CString s;
	int i,i1,i2,i3;

/*	for(i=0;i<sContent.Length();i++)
		printf("%02X ",sContent.Data()[i]);
	printf("\n");*/

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(0x05,i+1)) < 0 )
		return 0;

	if ( (i2=sContent.Find(' ',i1+1)) < 0 )
		return 0;

	if ( (i3=sContent.Find(0x05,i2+1)) < 0 )
		return 0;

	if ( (msg = new CMessageSearchResult()) != 0 )
	{
		msg->m_sNick = sContent.Mid(0,i);
		msg->m_sFile = sContent.Mid(i+1,i1-i-1);
		s = sContent.Mid(i1+1,i2-i1-1);
		msg->m_nSize = s.asULL();

		// parse the user slots
		s = sContent.Mid(i2+1,i3-i2-1);
		msg->m_nFreeSlot = 0;
		msg->m_nMaxSlot  = 0;

		if ( (i1 = s.Find('/')) != -1 )
		{
			msg->m_nFreeSlot = s.Mid(0,i1).asUINT();
			msg->m_nMaxSlot  = s.Mid(i1+1,s.Length()-i1-1).asUINT();
		}

		msg->m_sHubName = "";
		msg->m_sHubHost = "";

		s = sContent.Mid(i3+1,sContent.Length()-i3-1);

		if ( s != "" )
		{
			if ( (i1 = s.FindRev(')')) != -1 )
			{
				if ( (i2 = s.FindRev('('),i1-1) != -1 )
				{
					if ( i2 > 0 ) i2--; // remove space " ("
					msg->m_sHubName = s.Mid(0,i2);
					msg->m_sHubHost = s.Mid(i2+2,i1-i2-2);
				}
			}
		}

		// parse special content in hubname
		if ( msg->m_sHubName.Left(4) == "TTH:" )
		{
			// tiger tree hash
			msg->m_sHash = msg->m_sHubName;
			// set dummy hubname
			msg->m_sHubName = msg->m_sHubHost;
		}

/*		printf("%s\n%s | %s | %s | %s | %s | %s\n",\
			sContent.Data(),
			msg->sNick.Data(),
			msg->sFile.Data(),
			msg->sSize.Data(),
			msg->sSlot.Data(),
			msg->sHubName.Data(),
			msg->sHubHost.Data() );*/
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParsePrivateChat( CString sContent )
{
	CEncrypt Encrypt;
	CMessagePrivateChat * msg=0;
	CString s;

	int i,i1,/*i2,*/i3;

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(' ',i+1)) < 0 )
		return 0;

//	if ( (i2=sContent.Find(' ',i1+1)) < 0 )
//		return 0;

	if ( (i3=sContent.Find('$',i1+1)) < 0 )
		return 0;

	if ( (msg = new CMessagePrivateChat()) != 0 )
	{
		msg->m_sDstNick = sContent.Mid(0,i);
		msg->m_sSrcNick = sContent.Mid(i1+1,i3-1-i1-1);

		s = Encrypt.Decode(sContent.Mid(i3+1,sContent.Length()-i3-1));

		i  = s.Find('<');
		i1 = s.Find('>',i+1);

		msg->m_sMultiSrcNick = "";

		if ( (i==-1) || (i1==-1) )
		{
			msg->m_sMessage = s;
		}
		else
		{
			if ( s.Data()[i1+1] == ' ' )
				i1++;
			msg->m_sMessage      = s.Mid(i1+1,s.Length()-i1-1);
			msg->m_sMultiSrcNick = s.Mid(i+1,i1-2);
		}

		// reconvert dcproto chars
		msg->m_sMessage = msg->m_sMessage.Replace( "&#36;", "$" );
		msg->m_sMessage = msg->m_sMessage.Replace( "&#124;", "|" );

/*
		printf("%s\n%s\n%s\n%s\n",\
			sContent.Data(),
			msg->sNick.Data(),
			msg->sFrom.Data(),
			msg->sString.Data() );
*/
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseForceMove( CString sContent )
{
	int i;
	CString s;
	CMessageForceMove * msg=0;

	if ( "" == sContent )
	{
		return msg;
	}

	i = sContent.Find(':');

	if ( (msg = new CMessageForceMove()) != 0 )
	{
		if ( i > 0 )
		{
			s = sContent.Mid(i+1,sContent.Length()-i-1);
		}
		else
		{
			s = "";
		}

		if ( (i < 0) || (s == "") )
		{
			msg->m_sHost = sContent;
			msg->m_nPort   = 411;
		}
		else
		{
			msg->m_sHost = sContent.Mid(0,i);
			msg->m_nPort = s.asINT();
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseDirection( CString sContent )
{
	int i;
	CString s;
	CMessageDirection * msg=0;

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (msg = new CMessageDirection()) != 0 )
	{
		s = sContent.Mid(0,i);

		if ( "Upload" == s )
			msg->m_eDirection = edUPLOAD;
		else if ( "Download" == s )
			msg->m_eDirection = edDOWNLOAD;
		else
			msg->m_eDirection = edNONE;

		s = sContent.Mid(i+1,sContent.Length()-i-1);
		if(s!="")
			msg->m_nLevel = s.asINT();
		else
			msg->m_nLevel = 0;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseFileLength( CString sContent )
{
	CMessageFileLength * msg=0;

	if ( (msg = new CMessageFileLength()) != 0 )
	{
		if ( "" != sContent )
			msg->m_nFileLength = sContent.asULL();
		else
			msg->m_nFileLength = 0;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseGet( CString sContent )
{
	int i;
	CString s,s1;
	CMessageGet * msg=0;

	if ( (i=sContent.Find('$')) < 0 )
		return 0;

	if ( (msg = new CMessageGet()) != 0 )
	{
		msg->m_sFilename = sContent.Mid(0,i);

		s = sContent.Mid(i+1,sContent.Length()-i-1);

		// check if special get message "POS$SIZE"
		if ( (i=s.Find('$')) < 0 )
		{
			msg->m_nPos = s.asULL();
		}
		else
		{
			s1 = s.Mid(0,i);
			msg->m_nPos = s1.asULL();
			s1 = s.Mid(i+1,s.Length()-i-1);
			msg->m_nSize = s1.asULL();
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseError( CString sContent )
{
	CMessageError * msg=0;

	if ( (msg = new CMessageError()) != 0 )
	{
		msg->m_sError = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseHubName( CString sContent )
{
	CMessageHubName * msg=0;

	if ( (msg = new CMessageHubName()) != 0 )
	{
		msg->m_sHubName = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseGetInfo( CString sContent )
{
	CMessageGetInfo * msg=0;
	int i;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageGetInfo()) != 0 )
	{
		msg->m_sDstNick = sContent.Mid(0,i);
		msg->m_sSrcNick = sContent.Mid(i+1,sContent.Length()-i-1);
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseLogedIn( CString sContent )
{
	CMessageLogedIn * msg=0;

	if ( (msg = new CMessageLogedIn()) != 0 )
	{
		// remove the space
		if ( sContent.Left(1) == ' ' )
		{
			sContent = sContent.Mid(1,sContent.Length()-1);
		}

		msg->m_sNick = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseSupports( CString sContent )
{
	CMessageSupports * msg=0;
	int i,i1;
	CString s;

	if ( (msg = new CMessageSupports()) != 0 )
	{
		i = i1 = 0;

		while( (i1=sContent.Find(' ',i)) != -1 )
		{
			i1++;

			s = sContent.Mid(i,i1-i);

			if ( s == "BZList " )
			{
				msg->m_bBZList = TRUE;
			}
			else if ( s == "SSL " )
			{
				msg->m_bSSL = TRUE;
			}
			else if ( s == "CHUNK " )
			{
				msg->m_bChunk = TRUE;
			}
			else if ( s == "MiniSlots " )
			{
				msg->m_bMiniSlots = TRUE;
			}			
			else if ( s == "XmlBZList " )
			{
				msg->m_bXMLBZList = TRUE;
			}
			else if ( s == "GetTestZBlock " )
			{
				// nothing ...
			}
			else if ( s == "GetZBlock " )
			{
				msg->m_bZBlock = TRUE;
			}
			else if ( s == "UserCommand " )
			{
				// TODO
			}
			else if ( s == "NoGetINFO " )
			{
				// TODO
			}
			else if ( s == "UserIP2 " )
			{
				// TODO
			}
			else if ( s == "XRules " )
			{
				// TODO
			}
			else
			{
				printf("Wrong support tag: '%s'\n",s.Data());
			}

			i = i1;
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseCapabilities( CString sContent )
{
	CMessageCapabilities * msg=0;
	int i,i1;
	CString s;

	if ( (msg = new CMessageCapabilities()) != 0 )
	{
		i = i1 = 0;

		// fix content string for better search ;-)
		sContent += "$";

		while( (i1=sContent.Find('$',i)) != -1 )
		{
			s = sContent.Mid(i,i1-i);

			if ( s == "UniSearch" )
			{
				msg->m_bUniSearch = TRUE;
			}
			else if ( s == "XSearch" )
			{
				msg->m_bXSearch = TRUE;
			}
			else if ( s == "MD4x" )
			{
				msg->m_bMD4x = TRUE;
			}

			i = i1+1;
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseHubTopic( CString sContent )
{
	CMessageHubTopic * msg=0;

	if ( (msg = new CMessageHubTopic()) != 0 )
	{
		msg->m_sTopic = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseUserCommand( CString sContent )
{
	return 0;
}
