/***************************************************************************
                           clogfile.cpp  -  description
                             -------------------
    begin                : Sat Dec 14 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>
#include <stdio.h>

#ifndef WIN32
#include <stdarg.h>
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "clogfile.h"

/** */
static CThread LogfileThread;

/** */
CLogFile::CLogFile()
{
}

/** */
CLogFile::~CLogFile()
{
}

/** */
bool CLogFile::Write( CString file, eLogType type, char * message, ... )
{
	va_list args;
	char msg_buff[32768];
	int i;

	LogfileThread.Lock();

#ifdef WIN32
	va_start( args, message );
	i = _vsnprintf(msg_buff, 32768, message, args);
#else
	va_start( args, message );
	i = vsnprintf(msg_buff, 32768, message, args);
#endif

	va_end(args);

	if ( i > 32767 )
	{
		msg_buff[0] = 0;
		i = 0;
	}

	LogfileThread.UnLock();

	return Write( file, type, CString(msg_buff) );
}

/** */
bool CLogFile::Write( CString file, eLogType /*type*/, CString message )
{
	bool res = FALSE;
	CString timestamp;
	struct tm * t;
	time_t ti;
	FILE * logfile;

	LogfileThread.Lock();

	ti = time(0);
	t  = localtime(&ti);

	timestamp = "[" + CString().setNum(t->tm_hour) + ":" +
			CString().setNum(t->tm_min) + ":" +
			CString().setNum(t->tm_sec) + "] ";

	// TODO: fix logfiles and add option to set logpath ...
/*
	if ( CConfig::Instance() )
	{
		file = CConfig:Instance()->GetLogPath() + file;
	}
*/
	if ( (logfile = fopen(file.Data(),"a")) != 0 )
	{
		fwrite(timestamp.Data(),timestamp.Length(),1,logfile);
		fwrite(message.Data(),message.Length(),1,logfile);
		timestamp = "\n";
		fwrite(timestamp.Data(),timestamp.Length(),1,logfile);
		fclose(logfile);
		res = TRUE;
	}

	LogfileThread.UnLock();

	return res;
}
