/***************************************************************************
                           cpluginmanager.h  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPLUGINMANAGER_H
#define CPLUGINMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cplugin.h>
#include <dclib/core/clist.h>
#include <dclib/core/csingleton.h>

class CPluginManager;
class CPluginObject;

#ifdef WIN32
template class DLL_EXPORT CList<CPlugin>;
template class DLL_EXPORT CSingleton<CPluginManager>;
template class DLL_EXPORT CList<CPluginObject>;
#endif

class DLL_EXPORT CPluginObject : public CObject {
public:
	/** */
	CPluginObject() {};
	/** */
	virtual ~CPluginObject() {};

	/** */
	ePluginStruct * m_ePluginStruct;
	/** */
#ifndef WIN32
	void * m_Handle;
#else
	HINSTANCE m_Handle;
#endif
};

class DLL_EXPORT CPluginManager : public CSingleton<CPluginManager>, public CObject {
public:
	/** */
	CPluginManager();
	/** */
	virtual ~CPluginManager();

	/** */
	void Load();
	/** */
	void InitPlugins();
	/** */
	void DeInitPlugins();
	/** */
	virtual bool Init( CPluginObject * plugin );

private:
	/** */
	friend class CSingleton<CPluginManager>;

	/** */
	CList<CPluginObject> * m_pPluginList;
	/** */
	CPluginInstance * m_pPluginInstance;
};

#endif
