/***************************************************************************
                           cfilemanager.cpp  -  description
                             -------------------
    begin                : Mon May 14 2003
    copyright            : (C) 2003-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <unistd.h>
#include <stdlib.h>
#endif

#include <string.h>

#include <dclib/dcos.h>
#include <dclib/core/cbytearray.h>
#include <dclib/cconfig.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cstringlist.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cfile.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/dclib.h>
#include <dclib/core/cmanager.h>
#include <dclib/core/cbz.h>
#include <dclib/core/che3.h>
#include <dclib/cfilemanager.h>

#include "csearchindex.h"

/** */
CSearchIndex::CSearchIndex()
{
	m_pBaseArray       = new CByteArray();
	m_pFileBaseArray   = new CByteArray();
	m_pPathBaseArray   = new CByteArray();
	m_pSearchIndex     = new CByteArray();
	m_pSearchFileIndex = new CByteArray();
	m_pSearchBase      = new CByteArray();

	memset(m_pSearchArray,0,sizeof(m_pSearchArray));

	m_nSearchFileIndex = 0;

	LoadIndex();
}

/** */
CSearchIndex::~CSearchIndex()
{
	delete m_pBaseArray;
	delete m_pFileBaseArray;
	delete m_pPathBaseArray;
	delete m_pSearchIndex;
	delete m_pSearchFileIndex;
	delete m_pSearchBase;
}

void CSearchIndex::Reset()
{
	m_pBaseArray->SetSize(0);
	m_pFileBaseArray->SetSize(0);
	m_pPathBaseArray->SetSize(0);

	ResetIndex();
}

void CSearchIndex::ResetIndex()
{
	m_pSearchIndex->SetSize(0);
	m_pSearchFileIndex->SetSize(0);
	m_pSearchBase->SetSize(0);

	memset(m_pSearchArray,0,sizeof(m_pSearchArray));

	m_nSearchFileIndex = 0;
}

/** */
CStringList * CSearchIndex::Search( CString s )
{
	CString *ps;
	CStringList *sl=0;
	struct fileindexobject *pfio;
	struct searchindexobject * psio;

	if ( (psio = SearchIndex(s) ) != 0 )
	{
		sl = new CStringList();

		pfio = (struct fileindexobject*) (m_pSearchIndex->Data()+psio->m_nFileIndex);

		while(pfio)
		{
			ps = new CString( CString().setNum(pfio->m_nFileBaseIndex));
			sl->Add( *ps, ps );

			if ( pfio->m_nNext == 0 )
			{
				pfio = 0;
			}
			else
			{
				pfio = (struct fileindexobject*) (m_pSearchIndex->Data()+pfio->m_nNext);
			}
		}
	}

	return sl;
}

/** */
bool CSearchIndex::GetFileBaseObject( CString id, struct filebaseobject * fbo, CString & filename )
{
	bool res = FALSE;
	ulonglong index;

	index = id.asULL();

	if ( (index*sizeof(struct filebaseobject)) < m_pBaseArray->Size() )
	{
		memcpy( fbo, m_pBaseArray->Data()+(index*sizeof(struct filebaseobject)), sizeof(struct filebaseobject) );

		if ( m_pPathBaseArray->Size() > fbo->m_nPathIndex )
		{
			filename = (char*)m_pPathBaseArray->Data()+fbo->m_nPathIndex;

			if ( filename != "" )
			{
				filename += DIRSEPARATOR;
			}
		}

		if ( m_pFileBaseArray->Size() > fbo->m_nFileIndex )
		{
			filename += (char*)m_pFileBaseArray->Data()+fbo->m_nFileIndex;
		}

		res = TRUE;
	}

	return res;
}

/** */
bool CSearchIndex::LoadIndex()
{
	bool err = FALSE;
	CDir d;
	ulonglong filesize;

	// sanity check
	filesize = d.getFileSize(CConfig::Instance()->GetConfigPath()+"database.bin",FALSE);

	if ( (filesize%sizeof(struct filebaseobject)) != 0 )
	{
		err = TRUE;
	}

	// load the filelist
	if ( err == FALSE )
	{
		if ( m_pBaseArray->LoadFromFile(CConfig::Instance()->GetConfigPath()+"database.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err == FALSE )
	{
		if ( m_pFileBaseArray->LoadFromFile(CConfig::Instance()->GetConfigPath()+"filebase.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err == FALSE )
	{
		if ( m_pPathBaseArray->LoadFromFile(CConfig::Instance()->GetConfigPath()+"pathbase.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err )
	{
		m_pBaseArray->SetSize(0);
		m_pFileBaseArray->SetSize(0);
		m_pPathBaseArray->SetSize(0);
	}

	if ( err == FALSE )
	{
		if ( m_pSearchBase->LoadFromFile(CConfig::Instance()->GetConfigPath()+"searchbase.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err == FALSE )
	{
		if ( m_pSearchIndex->LoadFromFile(CConfig::Instance()->GetConfigPath()+"searchindex.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err == FALSE )
	{
		if ( m_pSearchFileIndex->LoadFromFile(CConfig::Instance()->GetConfigPath()+"searchfileindex.bin") == FALSE )
		{
			err = TRUE;
		}
	}

	if ( err )
	{
		m_pSearchBase->SetSize(0);
		m_pSearchIndex->SetSize(0);
		m_pSearchFileIndex->SetSize(0);
		m_nSearchFileIndex = 0;

		// TODO: recreate index
	}
	else
	{
		m_nSearchFileIndex = (struct long_s*)m_pSearchFileIndex->Data();
	}

	return !err;
}

/** */
void CSearchIndex::SaveIndex()
{
	m_pSearchBase->SaveToFile(CConfig::Instance()->GetConfigPath()+"searchbase.bin");
	m_pSearchIndex->SaveToFile(CConfig::Instance()->GetConfigPath()+"searchindex.bin");
	m_pSearchFileIndex->SaveToFile(CConfig::Instance()->GetConfigPath()+"searchfileindex.bin");
	m_pBaseArray->SaveToFile(CConfig::Instance()->GetConfigPath()+"database.bin");
	m_pFileBaseArray->SaveToFile(CConfig::Instance()->GetConfigPath()+"filebase.bin");
	m_pPathBaseArray->SaveToFile(CConfig::Instance()->GetConfigPath()+"pathbase.bin");
}

/** */
unsigned long CSearchIndex::IndexCount()
{
	unsigned long i = 0;

	if ( m_pBaseArray )
	{
		i = m_pBaseArray->Size()/sizeof(struct filebaseobject);
	}

	return i;
}

/** */
void CSearchIndex::AddIndex( CFileInfo *fileinfo, CString path, eFileTypes filetype )
{
	struct filebaseobject fbo;

	fbo.m_eFileType  = filetype;
	fbo.m_nFileIndex = m_pFileBaseArray->Size();
	fbo.m_nPathIndex = m_pPathBaseArray->Size();
	fbo.m_nHashIndex = (unsigned long)-1;
	fbo.m_nSize      = fileinfo->size;
	fbo.m_tModTime   = fileinfo->st_m_time;

	m_pBaseArray->Append( (const char*)&fbo, sizeof(struct filebaseobject) );
	m_pFileBaseArray->Append( fileinfo->name.Data(), fileinfo->name.Length()+1 );
	m_pPathBaseArray->Append( path.Data(), path.Length()+1 );
}

/** */
void CSearchIndex::InitIndex()
{
	int i;

	// init array
	m_pSearchFileIndex->SetSize(sizeof(struct long_s)*0x100);

	for(i=0;i<=0xFF;i++)
	{
		m_nSearchFileIndex = (struct long_s*)m_pSearchFileIndex->Data();

		m_nSearchFileIndex[i].n = 0;

		if ( m_pSearchArray[i] != 0 )
		{
			m_nSearchFileIndex[i].n = m_pSearchFileIndex->Size();
			m_pSearchFileIndex->Append(m_pSearchArray[i]->Data(),m_pSearchArray[i]->Size());
			delete m_pSearchArray[i];
		}
	}
}

/** */
CString CSearchIndex::GetFileName( ulonglong i )
{
	CString s = "";
	struct filebaseobject * fbo;

	if ( (i*sizeof(struct filebaseobject)) < m_pBaseArray->Size() )
	{
		fbo = (struct filebaseobject *) (m_pBaseArray->Data()+(i*sizeof(struct filebaseobject)));

		s = (char*) (m_pFileBaseArray->Data()+fbo->m_nFileIndex);
	}

	return s;
}

struct searchindexobject * CSearchIndex::SearchIndex( CString & s )
{
	unsigned long i,is,ie;
	unsigned int in = s.Data()[0]&0xFF;
	struct searchindexobject * psio = 0;

	if ( (!m_nSearchFileIndex) || (m_nSearchFileIndex[in].n == 0) )
	{
		return 0;
	}

	// set start
	is = m_nSearchFileIndex[in].n;

	// find end
	for(ie=0,i=in+1;i<=0xFF;i++)
	{
		if ( m_nSearchFileIndex[i].n != 0 )
		{
			ie = m_nSearchFileIndex[i].n;
			break;
		}
	}

	if ( ie == 0 )
	{
		ie = m_pSearchFileIndex->Size();
	}

	i = 0;

	while( (is+(i*sizeof(struct searchindexobject))) < ie )
	{
		psio = (struct searchindexobject *) (m_pSearchFileIndex->Data()+(is+(i*sizeof(struct searchindexobject))));

		if ( s == (char*)(m_pSearchBase->Data()+psio->m_nIndex) )
		{
			break;
		}

		i++;
		psio = 0;
	}

	return psio;
}

struct searchindexobject * CSearchIndex::FindIndex( CString & s )
{
	long i=0;
	unsigned int in = s.Data()[0]&0xFF;
	struct searchindexobject * psio = 0;

	if ( m_pSearchArray[in] == 0 )
	{
		return 0;
	}

	while( (i*sizeof(struct searchindexobject)) < m_pSearchArray[in]->Size() )
	{
		psio = (struct searchindexobject *) (m_pSearchArray[in]->Data()+(i*sizeof(struct searchindexobject)));

		if ( s == (char*)(m_pSearchBase->Data()+psio->m_nIndex) )
		{
			break;
		}

		i++;
		psio = 0;
	}

	return psio;
}

void CSearchIndex::AddIndex( CString & s, ulonglong filebaseindex )
{
	unsigned int in;
	struct searchindexobject sio, *psio;
	struct fileindexobject fio, *pfio;

	in = s.Data()[0]&0xFF;
			
	if ( m_pSearchArray[in] == 0 )
	{
		m_pSearchArray[in] = new CByteArray();
	}
			
	if ( (psio = FindIndex(s) ) != 0 )
	{
		pfio = (struct fileindexobject*) (m_pSearchIndex->Data()+psio->m_nFileIndex);

		while(pfio->m_nNext!=0)
		{
			pfio = (struct fileindexobject*) (m_pSearchIndex->Data()+pfio->m_nNext);
		}

		pfio->m_nNext = m_pSearchIndex->Size();
	}
	else
	{
		sio.m_nIndex     = m_pSearchBase->Size();
		sio.m_nFileIndex = m_pSearchIndex->Size();

		m_pSearchBase->Append(s.Data(),s.Length()+1);
		m_pSearchArray[in]->Append( (const char*)&sio, sizeof(struct searchindexobject) );
	}

	fio.m_nFileBaseIndex = filebaseindex;
	fio.m_nNext          = 0;

	m_pSearchIndex->Append( (const char*)&fio, sizeof(struct fileindexobject) );
}
