/***************************************************************************
                          csearchmanager.h  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHMANAGER_H
#define CSEARCHMANAGER_H

/**
  *@author Mathias Kster
  */

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/csingleton.h>

class CSearchManager;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CSearchManager>;
#endif

/** search modes */
typedef enum eSearchMode {
	esmCONNECTEDSINGLE = 0,
	esmCONNECTEDALL,
	esmPUBLIC,
	esmBOOKMARK
} eSearchMode;

typedef enum eSearchState {
	esNONE = 0,
} eSearchState;

/** */
typedef enum eSearchError {
	eseNONE = 0
} eSearchError;

/** */
typedef enum eSearchType {
	estSINGLE = 0,
	estMULTI
} eSearchType;

class DLL_EXPORT CSearchManager : public CSingleton<CSearchManager>, public CConnection {
public:
	/** */
	CSearchManager();
	/** */
	virtual ~CSearchManager();

	/** */
	eSearchError StartSearch( eSearchMode mode, eSearchType type, CList<CObject> * querylist, CStringList * serverlist );

protected:

private:
	/** starttime */
	time_t m_tStartTime;
	/** search type */
	enum eSearchType m_eSearchType;
	/** search state */
	enum eSearchState m_eSearchState;
};

#endif
