/***************************************************************************
                           csharelisr.h  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSHARELIST_H
#define CSHARELIST_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cobject.h>
#include <dclib/core/types.h>

typedef enum eShareBufferType {
	esbtNONE=0,
	esbtHE3,
	esbtBZ,
	esbtXMLBZ
} eShareBufferType;

class CByteArray;

class DLL_EXPORT CShareList : public CObject {

public:
	/** */
	CShareList();
	/** */
	virtual ~CShareList();

	/** */
	bool Load();
	/** */
	void Save();

	/** */
	void SetShareBuffer( CString sharebuffer, ulonglong size );
	/** */
	ulonglong GetShareSize() const;
	/** */
	unsigned long GetShareBufferSize( eShareBufferType type );
	/** */
	int GetShareBuffer( eShareBufferType type, CByteArray * sharebuffer );

private:
	/** */
	ulonglong m_nShareSize;
	/** */
	CByteArray * m_pHE3ShareBuffer;
	/** */
	CByteArray * m_pBZShareBuffer;
	/** */
	CMutex m_MutexShareList;
};

#endif
