/***************************************************************************
                          cutils.cpp  -  description
                             -------------------
    begin                : Fri May 16 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/chttp.h>

#include "cutils.h"

/** */
CUtils::CUtils()
{
}

/** */
CUtils::~CUtils()
{
}

/** */
CString CUtils::GetSizeString( const ulonglong size, eUnit unit )
{
	CString s, suffix;
	double f;

	if ( (size > (1.0*1024*1024*1024*1024)) && (unit == euAUTO) )
	{
		suffix = "TB";
#ifndef WIN32
		f = (size*1.0)/(1.0*1024*1024*1024*1024);
#else
		f = ((longlong)size*1.0)/(1.0*1024*1024*1024*1024);
#endif
	}
	else if ( ((size > (1024*1024*1024)) && (unit == euAUTO)) || (unit == euGBYTE) )
	{
		suffix = "GB";
#ifndef WIN32
		f = (size*1.0)/(1024*1024*1024);
#else
		f = ((longlong)size*1.0)/(1024*1024*1024);
#endif
	}
	else if ( ((size > (1024*1024)) && (unit == euAUTO)) || (unit == euMBYTE) )
	{
		suffix = "MB";
#ifndef WIN32
		f = (size*1.0)/(1024*1024);
#else
		f = ((longlong)size*1.0)/(1024*1024);
#endif
	}
	else if ( ((size > 1024) && (unit == euAUTO)) || (unit == euKBYTE) )
	{
		suffix = "KB";
#ifndef WIN32
		f = (size*1.0)/1024;
#else
		f = ((longlong)size*1.0)/1024;
#endif
	}
	else if  ( (unit == euAUTO) || (unit == euBYTE) )
	{
		suffix = "B";
		f = 0;
	}
	else
	{
		suffix = "";
		f = 0;
	}

	if ( f != 0 )
	{
		s = CString().setNum(f,2);
	}
	else
	{
		s = s.setNum(size);
	}

	s += " " + suffix;

	return s;
}


/* This will Convert Total Secs to how much time is
 * remaining X Days + X Hrs + X Mins + X Secs */
CString CUtils::GetTimeString( const ulonglong sec )
{
	CString s,r;
	ulonglong rate;

	rate = sec;

	r = " S";
	s = "";

	if ( rate >= (60*60*24) )
	{
		s+= CString().setNum(rate/(60*60*24)) +" D ";
		rate %= (60*60*24);
	}
	if ( rate >= (60*60) )
	{
		s+= CString().setNum(rate/(60*60)).RightJustify(2,'0')+":";
		rate %= (60*60);
	}
	else
	{
		s+= "00:";
	}

	if ( rate >= 60 )
	{
		s += CString().setNum(rate/60).RightJustify(2,'0')+":";
		rate %= 60;
	}
	else
	{
		s+= "00:";
	}

	s += CString().setNum(rate).RightJustify(2,'0');

	return s;
}

/** */
CString CUtils::GetTransferString( const ulonglong rate )
{
	CString s;
	ulonglong r;
	double f;

	r = rate;

	if ( r >= (1024*1024) )
	{
		s = "MB/s";
		f = (r*1.0)/(1024*1024);
	}
	else if ( r >= 1024 )
	{
		s  = "KB/s";
		f = (r*1.0)/(1024);
	}
	else
	{
		s = "B/s";
		f = (r*1.0);
	}

	s = CString().setNum(f,2) + " " + s;

	return s;
}

/** */
bool CUtils::ConvertDCLink( CString link, CString & hubhost, CString & hubname, CString & nick, ulonglong & size, CString & file )
{
	bool res = FALSE;
	long i,i1,i2,i3,i4,i5;
	CString s;
	CString tag;

	//printf("'%s'\n",link.Data());

	if ( link.FindCase("DCFILE://") != 0 )
	{
		return res;
	}

	link = link.Right( link.Length()-9 );

	if ( (i=link.Find('?')) == -1 )
	{
		return res;
	}

	hubhost = link.Left(i);
	link = "&" + link.Right( link.Length()-i-1 );

	while( link != "" )
	{
		i1 = link.Find('&');
		i  = link.Find('&',i1+1);
		
		if ( i1 == -1 )
		{
			break;
		}
		 
		if ( i == -1 )
		{
			i = link.Length();
		}
		
		s = link.Left(i);
		link = link.Right( link.Length()-i );

		if ( s.FindCase("&FILE=") == 0 )
			file = CHttp::Decode(s.Right( s.Length()-6 ));
		else if ( s.FindCase("&NICK=") == 0 )
			nick = CHttp::Decode(s.Right( s.Length()-6 ));
		else if ( s.FindCase("&HUB=") == 0 )
			hubname = CHttp::Decode(s.Right( s.Length()-5 ));
		else if ( s.FindCase("&SIZE=") == 0 )
			size = CHttp::Decode(s.Right( s.Length()-6 )).asULL();
	}

	//printf("'%s'\n",hubhost.Data());
	//printf("'%s'\n",hubname.Data());
	//printf("'%s'\n",nick.Data());
	//printf("'%lld'\n",size);
	//printf("'%s'\n",file.Data());

	if ( (hubhost != "") &&
	     (hubname != "") &&
	     (nick != "") &&
	     (file != "") )
	{
		res = TRUE;
	}

	return res;
}
