/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief Command declarations for servers
 */

#ifndef __DRIZZLE_COMMAND_SERVER_H
#define __DRIZZLE_COMMAND_SERVER_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup drizzle_command_server Command Functions for Servers
 * @ingroup drizzle_server
 * These functions allow you to read comands on a connection.
 * @{
 */

/**
 * Read command without buffering.
 */
DRIZZLE_API
uint8_t *drizzle_command_read(drizzle_con_st *con, drizzle_command_t *command,
                              size_t *offset, size_t *size, size_t *total,
                              drizzle_return_t *ret_ptr);

/**
 * Read command and buffer it.
 */
DRIZZLE_API
uint8_t *drizzle_command_buffer(drizzle_con_st *con, drizzle_command_t *command,
                                size_t *total, drizzle_return_t *ret_ptr);

/** @} */

#ifdef __cplusplus
}
#endif

#endif /* __DRIZZLE_COMMAND_SERVER_H */
