/*
   Simple helper function to replace - without source changes - all calls to 
   pow by calls to the much faster (but less accurate) powr function defined 
   in the libffm library.
   
   Link with your files before referencing the math library, i.e. change for 
   example:
   
   > gcc/g77 myapp.x sub1.x sub2.x ... -o myapp ... -lf2c -lm

   	to
   
   > gcc/g77 myapp.x sub1.x sub2.x ... pow.o -o myapp ... -lf2c -lffm -lm
*/

double powr(double, double);

double pow(double x, double y)
{
    return powr(x, y);
}
