/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"


void comm_enqueue_to(COMM *c, TT *queue, TT *block, u16 trans, u16 flags)
{
  TT *elem;
  u16 flags_null = 0;

  elem = tt_new_with_data(&trans, sizeof(u16));
  tt_add_as_last_child(queue, elem);
  if (flags) elem = tt_new_with_parent_and_data(elem, &flags, sizeof(u16));
  else elem = tt_new_with_parent_and_data(elem, &flags_null, sizeof(u16));
  tt_add(elem, block);
}


TT *comm_dequeue_from(COMM *c, TT *queue, u16 *trans, u16 *flags)
{
  TT *elem0, *elem1, *block;

  elem0 = tt_get_first_child(queue);
  if (!elem0) return(0);

  if (trans) tt_data_get_bytes(elem0, trans, 0, sizeof(u16));
  elem1 = tt_get_first_child(elem0);
  if (flags) tt_data_get_bytes(elem1, flags, 0, sizeof(u16));
  
  block = tt_get_first_child(elem1);
  tt_detach(block);
  tt_del(elem0);
  
  return(block);
}
