#!/bin/sh

util/test/test

echo -n "Looking for mail dispatcher... "

if which mail 2>/dev/null; then
  echo
	echo "Mailing your report to the package maintainer, whether the tests were"
	echo "successful or not, is strongly encouraged. It will help him build a"
	echo "database of known working configurations (and confirm his belief that"
	echo "he's doing the Right Thing), as well as fix existing problems."
	echo
  echo -n "Mail this report to the Flux maintainer (hpj@styx.net) [y|n]? "
  read report

  if test $report = y; then
	  echo
    echo "Please wait, generating and mailing report..."

    util/test/test >report.txt 2>&1
  	mail -s "Build report: Flux 0.3.0" hpj@styx.net <report.txt
  	rm -f report.txt

    echo "Thank you for your contribution. Have another day."
  else
	  echo
		echo "If you for some reason should reconsider, please run \"test.sh\" from"
    echo "the package root."
  fi
else
  echo "none found"
	echo
  echo "No mail dispatcher found. This means that if you want to mail your report"
	echo "to the maintainer, you have to do it manually, by cut/pasting the above."
fi
