/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "test.h"
#include "flux.h"
#include <stdio.h>
#include <sys/time.h>


int test_mt_size()
{
  MT *mt0;
  int mts;

  mt0 = mt_new(MT_SPAN);
  mt_set_name_str(mt0, "test");
  
  mts = (tt_count_children_all(mt0) + 1) * sizeof(MT);
  if (mts == 32 * 3 || mts == 56 * 3) return(mts);
  return(-mts);
}


int test_mt_allocation()
{
  MT *tt0, *tt1, *tt2;
  int i, j;

  for (i = 0; i < 32; i++)  /* Repeat to promote heap corruption */
  {
    for (j = MT_DATA; j < MT_TYPES_NUM; j++)
    {
      if (!(tt0 = mt_new(j))) return(-1);
      if (!(tt1 = mt_dup(tt0))) return(-1);
      if (!(tt2 = mt_dup(tt1))) return(-1);
      mt_del(tt0);
      mt_del(tt1);
      mt_del(tt2);
    }
  }

  return(0);
}


int test_mt_navigation()
{
  MT *tt0, *tt1, *tt2;
  int i, j;

  for (j = 0; j < 32; j++)  /* Repeat to promote heap corruption */
  {
    tt0 = mt_new(MT_SPAN);  /* root */

    for (i = 0; i < 32; i++)
    {
      tt1 = mt_new(MT_SPAN);
      mt_add_as_last_child(tt0, tt1);
    }

    for (i = 0; i < 32; i++)
    {
      tt2 = mt_new(MT_SPAN);
      mt_add_as_first_sibling(tt1, tt2);
    }

    /* Force creation of new root node */

    for (i = 0; i < 31; i++)
    {
      tt1 = mt_new(MT_SPAN);
      mt_add_as_last_sibling(tt0, tt1);
    }

    if (!(tt0 = mt_get_parent(tt0))) return(-1);

    /* Check the resulting structure */

    if (mt_count_children(tt0) != 32) return(-1);
    if (mt_count_siblings(mt_get_first_child(tt0)) != 32) return(-1);
    if (mt_count_children(mt_get_first_child(tt0)) != 64) return(-1);
    if (mt_count_children_all(tt0) != 96) return(-1);
    if (mt_count_siblings(tt0) != 1) return(-1);
    if (mt_count_children(mt_get_next(mt_get_first_child(tt0)))) return(-1);

    /* Free all */
  
    mt_del(tt0);
  }

  return(0);
}


int test_mt_xml_simple()
{
  MT *mt0, *mt1;
  FILE *f;
  int i;

  for (i = 0; i < 32; i++)
  {
    f = fopen("temporary_mt_test", "w+t");
    if (!f) return(-1);
  
    mt0 = mt_new(MT_SPAN);
    mt_set_name_str(mt0, "document");
  
    mt1 = mt_new(MT_SPAN);
    mt_set_name_str(mt1, "thing");
    mt_add(mt0, mt1);
  
    mt1 = mt_new(MT_DATA);
    mt_data_set_str(mt1, "text");
    mt_add(mt0, mt1);

    mt1 = mt_new(MT_DATA);
    mt_data_set_str(mt1, "text");
    mt_add(mt0, mt1);

    mt_print_to_xml_file(mt0, f);
    rewind(f);
  
    mt_del(mt0);
  
    if (!(mt0 = mt_scan_from_xml_file(f, 0))) return(-1);
    fclose(f);
    remove("temporary_mt_test");

    if (mt_get_type(mt0) != MT_SPAN ||
        !mt_get_first_child(mt0) ||
        mt_get_type(mt_get_first_child(mt0)) != MT_SPAN ||
        !mt_get_next(mt_get_first_child(mt0)) ||
        mt_get_type(mt_get_next(mt_get_first_child(mt0))) != MT_DATA)
    {
      mt_del(mt0);
      return(-1);
    }
  
    mt_del(mt0);
  }

  return(0);
}
