/**
 * @file check-libgalago.c Unit tests
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <check.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>


/**************************************************************************
 * Hashtable tests
 **************************************************************************/
START_TEST(test_hashtable_replace)
{
	GalagoHashTable *table;

	table = galago_hash_table_new_full(galago_str_hash, galago_str_equal,
									   free, free);
	galago_hash_table_insert(table, strdup("key"), strdup("foo"));

	galago_hash_table_replace(table, strdup("key"), strdup("bar"));

	fail_unless(!strcmp((char *)galago_hash_table_lookup(table, "key"), "bar"),
				"New hashtable item 'bar' wasn't found after "
				"galago_hash_table_replace");
}
END_TEST


/**************************************************************************
 * libgalago tests
 **************************************************************************/
START_TEST(test_init_reinit)
{
	fail_unless(galago_init("check-libgalago", FALSE),
				"Unable to initialize libgalago");

	galago_uninit();

	fail_unless(galago_init("check-libgalago", FALSE),
				"Unable to re-initialize libgalago");
}
END_TEST


/**************************************************************************
 * Object tests
 **************************************************************************/
START_TEST(test_object_abstract)
{
	galago_log_set_enabled(GALAGO_LOG_ERROR, FALSE);

	fail_unless(galago_object_new(GALAGO_CLASS_IMAGE) == NULL,
				"Created abstract object. This shouldn't happen!");

	galago_log_set_enabled(GALAGO_LOG_ERROR, TRUE);
}
END_TEST


/**************************************************************************
 * Core tests
 **************************************************************************/
START_TEST(test_core)
{
	fail_unless(1 == 1, "core test suite");
}
END_TEST

#define ADD_TCASE(name, func) \
	tc = tcase_create(name); \
	tcase_add_test(tc, (func)); \
	suite_add_tcase(s, tc)

static Suite *
make_libgalago_suite(void)
{
	Suite *s;
	TCase *tc;

	s = suite_create("libgalago");

	/* Core test */
	ADD_TCASE("core", test_core);

	/* hashtable tests*/
	ADD_TCASE("hashtable_replace", test_hashtable_replace);

	/* libgalago tests */
	ADD_TCASE("init_reinit", test_init_reinit);

	/* object tests */
	ADD_TCASE("object_abstract", test_object_abstract);

	return s;
}

static void
error_handler(GalagoLogLevel level, const char *fmt, va_list args,
			  void *user_data)
{
	char buf[BUFSIZ];

	vsnprintf(buf, sizeof(buf), fmt, args);
	fail(buf);
}

int
main(int argc, char **argv)
{
	Suite *s;
	SRunner *sr;
	int nf;

	galago_log_set_handler(GALAGO_LOG_WARNING, error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_ERROR,   error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_FATAL,   error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_ASSERT,  error_handler, NULL);

	s = make_libgalago_suite();
	sr = srunner_create(s);

	srunner_set_log(sr, "check-libgalago.log");
	srunner_run_all(sr, CK_NORMAL);

	nf = srunner_ntests_failed(sr);

	srunner_free(sr);

	return (nf == 0 ? EXIT_SUCCESS : EXIT_FAILURE);
}
