/**
 * @file list-services.c Displays a list of services.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int
main(int argc, char **argv)
{
	GList *l;

	if (!galago_init("list-services-test", GALAGO_INIT_CLIENT) ||
		!galago_is_connected())
	{
		fprintf(stderr, "Unable to connect to the Galago service.\n");
		exit(1);
	}

	for (l = galago_get_services(GALAGO_REMOTE, TRUE);
		 l != NULL;
		 l = l->next)
	{
		GalagoService *service = (GalagoService *)l->data;

		printf("%-10s - %s\n",
			   galago_service_get_id(service),
			   galago_service_get_name(service));
	}

	return 0;
}
