#line 59 "../noweb/o_box_basic.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/o_box_basic.nw"
/* DO NOT read or edit this file ! Use ../noweb/o_box_basic.nw instead */

#line 81 "../noweb/o_box_basic.nw"
#include <config.h>
#include <math.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <guile/gh.h>

#ifdef HAS_LIBGDGEDA
#include <gdgeda/gd.h>
#endif

#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "o_types.h"
#include "colors.h"
#include "funcs.h"

#include "../include/prototype.h"

#line 104 "../noweb/o_box_basic.nw"
/* Kazu on July 16, 1999 - Added these macros to simplify the code */
#define GET_BOX_WIDTH(w)                        \
        abs((w)->last_x - (w)->start_x)
#define GET_BOX_HEIGHT(w)                       \
	        abs((w)->last_y - (w)->start_y)
#define GET_BOX_LEFT(w)                         \
	        min((w)->start_x, (w)->last_x);
#define GET_BOX_TOP(w)                          \
		min((w)->start_y, (w)->last_y);




#line 135 "../noweb/o_box_basic.nw"
OBJECT *o_box_add(TOPLEVEL * w_current, OBJECT * object_list,
		  char type, int color, int x1, int y1, int x2, int y2)
{
  OBJECT *new_node;
  BOX *box;


#line 158 "../noweb/o_box_basic.nw"
/* create the object */
  new_node = s_basic_init_object("box");
  new_node->type = type;
  new_node->color = color;

  box = (BOX *) malloc(sizeof(BOX));
  new_node->box = box;


#line 145 "../noweb/o_box_basic.nw"

#line 170 "../noweb/o_box_basic.nw"
/* describe the box with its upper left and lower right corner */
  box->upper_x = x1;
  box->upper_y = y1;
  box->lower_x = x2;
  box->lower_y = y2;

/* line type and filling initialized to default */
  o_set_line_options(w_current, new_node, END_NONE, TYPE_SOLID, 0, -1, -1);
  o_set_fill_options(w_current, new_node,
		     FILLING_HOLLOW, -1, -1, -1, -1, -1);

/* TODO: questionable cast */
  new_node->draw_func = (void *) box_draw_func;
/* TODO: questionable cast */
  new_node->sel_func = (void *) select_func;


#line 147 "../noweb/o_box_basic.nw"

#line 191 "../noweb/o_box_basic.nw"
/* compute the bounding box */
  o_box_recalc(w_current, new_node);


#line 149 "../noweb/o_box_basic.nw"

#line 198 "../noweb/o_box_basic.nw"
/* add the object to the list */
  object_list = (OBJECT *) s_basic_link_object(new_node, object_list);


#line 151 "../noweb/o_box_basic.nw"
  return (object_list);
}


#line 213 "../noweb/o_box_basic.nw"
OBJECT *o_box_copy(TOPLEVEL * w_current, OBJECT * list_tail,
		   OBJECT * o_current)
{
  OBJECT *new_obj;
  ATTRIB *a_current;
  int color;

  if (o_current->saved_color == -1) {
    color = o_current->color;
  } else {
    color = o_current->saved_color;
  }


#line 242 "../noweb/o_box_basic.nw"
/* create and link a new box object */
  new_obj = o_box_add(w_current, list_tail, OBJ_BOX, color, 0, 0, 0, 0);


#line 228 "../noweb/o_box_basic.nw"

#line 255 "../noweb/o_box_basic.nw"
/* modifying */
/* pb20011002 - have to check if o_current is a box object */
  new_obj->box->upper_x = o_current->box->upper_x;
  new_obj->box->upper_y = o_current->box->upper_y;
  new_obj->box->lower_x = o_current->box->lower_x;
  new_obj->box->lower_y = o_current->box->lower_y;

  o_set_line_options(w_current, new_obj, o_current->line_end,
		     o_current->line_type, o_current->line_width,
		     o_current->line_length, o_current->line_space);
  o_set_fill_options(w_current, new_obj,
		     o_current->fill_type, o_current->fill_width,
		     o_current->fill_pitch1, o_current->fill_angle1,
		     o_current->fill_pitch2, o_current->fill_angle2);

  o_box_recalc(w_current, new_obj);


#line 230 "../noweb/o_box_basic.nw"

#line 276 "../noweb/o_box_basic.nw"
/*	new_obj->attribute = 0;*/
  a_current = o_current->attribs;
  if (a_current) {
    while (a_current) {

      /* head attrib node has prev = NULL */
      if (a_current->prev != NULL) {
	a_current->copied_to = new_obj;
      }
      a_current = a_current->next;
    }
  }

#line 232 "../noweb/o_box_basic.nw"
  /* return the new tail of the object list */
  return (new_obj);
}


#line 301 "../noweb/o_box_basic.nw"
/* pb20011002 - rewritten : old one did not used x, y and whichone */
void
o_box_modify(TOPLEVEL * w_current, OBJECT * object,
	     int x, int y, int whichone)
{
  int tmp;

  /* change the position of the selected corner */
  switch (whichone) {
  case BOX_UPPER_LEFT:
    object->box->upper_x = x;
    object->box->upper_y = y;
    break;

  case BOX_LOWER_LEFT:
    object->box->upper_x = x;
    object->box->lower_y = y;
    break;

  case BOX_UPPER_RIGHT:
    object->box->lower_x = x;
    object->box->upper_y = y;
    break;

  case BOX_LOWER_RIGHT:
    object->box->lower_x = x;
    object->box->lower_y = y;
    break;

  default:
    return;
  }

  /* need to update the upper left and lower right corners */
  if (object->box->upper_x > object->box->lower_x) {
    tmp = object->box->upper_x;
    object->box->upper_x = object->box->lower_x;
    object->box->lower_x = tmp;
  }

  if (object->box->upper_y < object->box->lower_y) {
    tmp = object->box->upper_y;
    object->box->upper_y = object->box->lower_y;
    object->box->lower_y = tmp;
  }

  /* recalculate the screen coords and the boundings */
  o_box_recalc(w_current, object);

}


#line 371 "../noweb/o_box_basic.nw"
OBJECT *o_box_read(TOPLEVEL * w_current, OBJECT * object_list, char buf[],
		   unsigned int release_ver, unsigned int fileformat_ver)
{
  char type;
  int x1, y1;
  int width, height;
  int d_x1, d_y1;
  int d_x2, d_y2;
  int color;
  int box_width, box_space, box_length;
  int fill_width, angle1, pitch1, angle2, pitch2;
  int box_end;
  int box_type;
  int box_filling;

  if (release_ver <= VERSION_20000704) {

#line 408 "../noweb/o_box_basic.nw"
    sscanf(buf, "%c %d %d %d %d %d\n",
	   &type, &x1, &y1, &width, &height, &color);

    box_width = 0;
    box_end = END_NONE;
    box_type = TYPE_SOLID;
    box_length = -1;
    box_space = -1;

    box_filling = FILLING_HOLLOW;
    fill_width = 0;
    angle1 = -1;
    pitch1 = -1;
    angle2 = -1;
    pitch2 = -1;

#line 389 "../noweb/o_box_basic.nw"

  } else {

#line 430 "../noweb/o_box_basic.nw"
    sscanf(buf, "%c %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
	   &type, &x1, &y1, &width, &height, &color,
	   &box_width, &box_end, &box_type, &box_length,
	   &box_space, &box_filling,
	   &fill_width, &angle1, &pitch1, &angle2, &pitch2);

#line 392 "../noweb/o_box_basic.nw"

  }


#line 440 "../noweb/o_box_basic.nw"
  if (width == 0 || height == 0) {
    fprintf(stderr,
	    "Found a zero width/height box [ %c %d %d %d %d %d ]\n", type,
	    x1, y1, width, height, color);
    s_log_message("Found a zero width/height box [ %c %d %d %d %d %d ]\n",
		  type, x1, y1, width, height, color);
  }

  if (color < 0 || color > MAX_COLORS) {
    fprintf(stderr, "Found an invalid color [ %s ]\n", buf);
    s_log_message("Found an invalid color [ %s ]\n", buf);
    s_log_message("Setting color to WHITE\n");
    color = WHITE;
  }

#line 397 "../noweb/o_box_basic.nw"

#line 462 "../noweb/o_box_basic.nw"
/* upper left corner of the box */
  d_x1 = x1;
  d_y1 = y1 + height;		/* move box origin to top left */

/* lower right corner of the box */
  d_x2 = x1 + width;		/* end points of the box */
  d_y2 = y1;

/* create and add the box to the list */
  object_list = (OBJECT *) o_box_add(w_current, object_list,
				     type, color, d_x1, d_y1, d_x2, d_y2);
/* set its line options */
  o_set_line_options(w_current, object_list,
		     box_end, box_type, box_width, box_length, box_space);
/* set its fill options */
  o_set_fill_options(w_current, object_list,
		     box_filling, fill_width,
		     pitch1, angle1, pitch2, angle2);


#line 399 "../noweb/o_box_basic.nw"
  return (object_list);
}

#line 496 "../noweb/o_box_basic.nw"
char *o_box_save(OBJECT * object)
{
  int x1, y1;
  int width, height;
  int color;
  int box_width, box_space, box_length;
  int fill_width, angle1, pitch1, angle2, pitch2;
  OBJECT_END box_end;
  OBJECT_TYPE box_type;
  OBJECT_FILLING box_fill;
  char *buf;


#line 522 "../noweb/o_box_basic.nw"
/* calculate the width and height of the box */
  width = abs(object->box->lower_x - object->box->upper_x);
  height = abs(object->box->upper_y - object->box->lower_y);

/* calculate the lower left corner of the box */
  x1 = object->box->upper_x;
  y1 = object->box->upper_y - height;	/* move the origin to 0, 0 */

#if DEBUG
  printf("box: %d %d %d %d\n", x1, y1, width, height);
#endif

/* description of the line type for the outline */
  box_end = object->line_end;
  box_width = object->line_width;
  box_type = object->line_type;
  box_length = object->line_length;
  box_space = object->line_space;

/* description of the filling of the box */
  box_fill = object->fill_type;
  fill_width = object->fill_width;
  angle1 = object->fill_angle1;
  pitch1 = object->fill_pitch1;
  angle2 = object->fill_angle2;
  pitch2 = object->fill_pitch2;

/* Use the right color */
  if (object->saved_color == -1) {
    color = object->color;
  } else {
    color = object->saved_color;
  }


#line 511 "../noweb/o_box_basic.nw"

#line 560 "../noweb/o_box_basic.nw"
  buf =
      g_strdup_printf("%c %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
		      object->type, x1, y1, width, height, color,
		      box_width, box_end, box_type, box_length, box_space,
		      box_fill, fill_width, angle1, pitch1, angle2,
		      pitch2);

#line 512 "../noweb/o_box_basic.nw"

  return (buf);
}


#line 579 "../noweb/o_box_basic.nw"
void o_box_translate(TOPLEVEL * w_current, int dx, int dy, OBJECT * object)
{
  int world_dx, world_dy;

  if (object == NULL)
    printf("bt NO!\n");

  /* convert the translation vector in world unit */
  world_dx = SCREENabs(w_current, dx);
  world_dy = SCREENabs(w_current, dy);

  /* translate the box */
  o_box_translate_world(w_current, world_dx, world_dy, object);

  /* screen coords and boundings are updated by _translate_world */

}

#line 607 "../noweb/o_box_basic.nw"
void
o_box_translate_world(TOPLEVEL * w_current, int x1, int y1,
		      OBJECT * object)
{
  if (object == NULL)
    printf("btw NO!\n");


#line 622 "../noweb/o_box_basic.nw"
/* Do world coords */
  object->box->upper_x = object->box->upper_x + x1;
  object->box->upper_y = object->box->upper_y + y1;
  object->box->lower_x = object->box->lower_x + x1;
  object->box->lower_y = object->box->lower_y + y1;


#line 614 "../noweb/o_box_basic.nw"

#line 632 "../noweb/o_box_basic.nw"
/* recalc the screen coords and the bounding box */
  o_box_recalc(w_current, object);

#line 615 "../noweb/o_box_basic.nw"

}


#line 649 "../noweb/o_box_basic.nw"
/* takes in screen coordinates for the centerx,y, and then does the rotate 
 * in world space */
/* also ignores angle argument... for now, rotate only in 90 degree 
 * increments */
/* fixed to 90 degrees... it's *not* general now */
void
o_box_rotate(TOPLEVEL * w_current,
	     int centerx, int centery, int angle, OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the center of rotation to world unit */
  SCREENtoWORLD(w_current,
		centerx, centery, &world_centerx, &world_centery);

  /* rotate the box */
  /* the check of the rotation angle is in o_box_rotate_world() */
  o_box_rotate_world(w_current,
		     world_centerx, world_centery, angle, object);

  /* screen coords and boundings are updated by _rotate_world() */

}

#line 687 "../noweb/o_box_basic.nw"
void
o_box_rotate_world(TOPLEVEL * w_current,
		   int world_centerx, int world_centery, int angle,
		   OBJECT * object)
{
  int newx1, newy1;
  int newx2, newy2;


#line 709 "../noweb/o_box_basic.nw"
/* angle must be positive */
  if (angle < 0)
    angle = -angle;
/* angle must be a 90 multiple or no rotation performed */
  if ((angle % 90) != 0)
    return;


#line 697 "../noweb/o_box_basic.nw"

#line 720 "../noweb/o_box_basic.nw"
/* translate object to origin */
  object->box->upper_x -= world_centerx;
  object->box->upper_y -= world_centery;
  object->box->lower_x -= world_centerx;
  object->box->lower_y -= world_centery;

/* rotate the upper left corner of the box */
  rotate_point_90(object->box->upper_x, object->box->upper_y, angle,
		  &newx1, &newy1);

/* rotate the lower left corner of the box */
  rotate_point_90(object->box->lower_x, object->box->lower_y, angle,
		  &newx2, &newy2);

/* reorder the corners after rotation */
  object->box->upper_x = min(newx1, newx2);
  object->box->upper_y = max(newy1, newy2);
  object->box->lower_x = max(newx1, newx2);
  object->box->lower_y = min(newy1, newy2);

/* translate object back to normal position */
  object->box->upper_x += world_centerx;
  object->box->upper_y += world_centery;
  object->box->lower_x += world_centerx;
  object->box->lower_y += world_centery;


#line 699 "../noweb/o_box_basic.nw"

#line 750 "../noweb/o_box_basic.nw"
/* recalc boundings and screen coords */
  o_box_recalc(w_current, object);

#line 700 "../noweb/o_box_basic.nw"

}


#line 765 "../noweb/o_box_basic.nw"
void
o_box_mirror(TOPLEVEL * w_current,
	     int centerx, int centery, OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the origin of mirror */
  SCREENtoWORLD(w_current, centerx, centery,
		&world_centerx, &world_centery);

  /* apply the mirror in world coords */
  o_box_mirror_world(w_current, world_centerx, world_centery, object);

  /* screen coords and boundings are updated by _mirror_world() */

}

#line 798 "../noweb/o_box_basic.nw"
void
o_box_mirror_world(TOPLEVEL * w_current,
		   int world_centerx, int world_centery, OBJECT * object)
{
  int newx1, newy1;
  int newx2, newy2;

  /* translate object to origin */
  object->box->upper_x -= world_centerx;
  object->box->upper_y -= world_centery;
  object->box->lower_x -= world_centerx;
  object->box->lower_y -= world_centery;

  /* mirror the corners */
  newx1 = -object->box->upper_x;
  newy1 = object->box->upper_y;
  newx2 = -object->box->lower_x;
  newy2 = object->box->lower_y;

  /* reorder the corners */
  object->box->upper_x = min(newx1, newx2);
  object->box->upper_y = max(newy1, newy2);
  object->box->lower_x = max(newx1, newx2);
  object->box->lower_y = min(newy1, newy2);

  /* translate back in position */
  object->box->upper_x += world_centerx;
  object->box->upper_y += world_centery;
  object->box->lower_x += world_centerx;
  object->box->lower_y += world_centery;

  /* recalc boundings and screen coords */
  o_box_recalc(w_current, object);

}


#line 847 "../noweb/o_box_basic.nw"
void o_box_recalc(TOPLEVEL * w_current, OBJECT * o_current)
{
  int left, top, right, bottom;
  int screen_x1, screen_y1;
  int screen_x2, screen_y2;

  if (o_current->box == NULL) {
    return;
  }

#line 870 "../noweb/o_box_basic.nw"
/* update the screen coords of the upper left corner of the box */
  WORLDtoSCREEN(w_current,
		o_current->box->upper_x, o_current->box->upper_y,
		&screen_x1, &screen_y1);
  o_current->box->screen_upper_x = screen_x1;
  o_current->box->screen_upper_y = screen_y1;

/* update the screen coords of the lower right corner of the box */
  WORLDtoSCREEN(w_current,
		o_current->box->lower_x, o_current->box->lower_y,
		&screen_x2, &screen_y2);
  o_current->box->screen_lower_x = screen_x2;
  o_current->box->screen_lower_y = screen_y2;


#line 860 "../noweb/o_box_basic.nw"

#line 888 "../noweb/o_box_basic.nw"
/* update the bounding box - screen unit */
  get_box_bounds(w_current, o_current->box, &left, &top, &right, &bottom);
  o_current->left = left;
  o_current->top = top;
  o_current->right = right;
  o_current->bottom = bottom;


#line 862 "../noweb/o_box_basic.nw"

#line 899 "../noweb/o_box_basic.nw"
/* recalc OBJECT specific parameters */
  o_object_recalc(w_current, o_current);

#line 863 "../noweb/o_box_basic.nw"

}


#line 912 "../noweb/o_box_basic.nw"
void
get_box_bounds(TOPLEVEL * w_current, BOX * box,
	       int *left, int *top, int *right, int *bottom)
{
  *left = box->screen_upper_x;
  *top = box->screen_upper_y;
  *right = box->screen_lower_x;
  *bottom = box->screen_lower_y;

  /* PB : bounding box has to take into account the width of the line */
  /* PB : but line width is unknown here */

  *left = *left - 4;
  *top = *top - 4;
  *right = *right + 4;
  *bottom = *bottom + 4;
}

#line 940 "../noweb/o_box_basic.nw"
void
world_get_box_bounds(TOPLEVEL * w_current, BOX * box,
		     int *left, int *top, int *right, int *bottom)
{
  /* pb20011002 - why using min and max here and not above ? */
  *left = min(box->upper_x, box->lower_x);
  *top = min(box->upper_y, box->lower_y);
  *right = max(box->upper_x, box->lower_x);
  *bottom = max(box->upper_y, box->lower_y);

  /* PB : same as above here for width of edges */

#if DEBUG
  printf("box: %d %d %d %d\n", *left, *top, *right, *bottom);
#endif

}


#line 975 "../noweb/o_box_basic.nw"
void
o_box_print(TOPLEVEL * w_current, FILE * fp, OBJECT * o_current,
	    int origin_x, int origin_y)
{
  int x, y, width, height;
  int color;
  int line_width, length, space;
  int fill_width, angle1, pitch1, angle2, pitch2;
  void (*outl_func) () = NULL;
  void (*fill_func) () = NULL;

  if (o_current == NULL) {
    printf("got null in o_box_print\n");
    return;
  }

  x = o_current->box->upper_x;
  y = o_current->box->upper_y;
  width = abs(o_current->box->lower_x - o_current->box->upper_x);
  height = abs(o_current->box->lower_y - o_current->box->upper_y);
  color = o_current->color;


#line 1011 "../noweb/o_box_basic.nw"
  line_width = o_current->line_width;
  length = o_current->line_length;
  space = o_current->line_space;

  switch (o_current->line_type) {
  case (TYPE_SOLID):
    length = -1;
    space = -1;
    outl_func = (void *) o_box_print_solid;
    break;

  case (TYPE_DOTTED):
    length = -1;
    outl_func = (void *) o_box_print_dotted;
    break;

  case (TYPE_DASHED):
    outl_func = (void *) o_box_print_dashed;
    break;

  case (TYPE_CENTER):
    outl_func = (void *) o_box_print_center;
    break;

  case (TYPE_PHANTOM):
    outl_func = (void *) o_box_print_phantom;
    break;

  case (TYPE_ERASE):
    /* Unused for now, print it solid */
    length = -1;
    space = -1;
    outl_func = (void *) o_box_print_solid;
    break;
  }

  if ((length == 0) || (space == 0)) {
    length = -1;
    space = -1;
    outl_func = (void *) o_box_print_solid;
  }

  (*outl_func) (w_current, fp,
		x, y, width, height,
		color, line_width, length, space, origin_x, origin_y);

#line 998 "../noweb/o_box_basic.nw"

#line 1065 "../noweb/o_box_basic.nw"
  if (o_current->fill_type != FILLING_HOLLOW) {
    fill_width = o_current->fill_width;
    angle1 = o_current->fill_angle1;
    pitch1 = o_current->fill_pitch1;
    angle2 = o_current->fill_angle2;
    pitch2 = o_current->fill_pitch2;

    switch (o_current->fill_type) {
    case (FILLING_FILL):
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_width = -1;
      fill_func = (void *) o_box_print_filled;
      break;

    case (FILLING_MESH):
      fill_func = (void *) o_box_print_mesh;
      break;

    case (FILLING_HATCH):
      angle2 = -1;
      pitch2 = 1;
      fill_func = (void *) o_box_print_hatch;
      break;

    case (FILLING_VOID):
      /* Unused for now, print it filled */
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_width = -1;
      fill_func = (void *) o_box_print_filled;
      break;
    case (FILLING_HOLLOW):
      /* nop */
      break;

    }

    if ((pitch1 <= 0) || (pitch2 <= 0)) {
      angle1 = -1;
      pitch1 = 1;
      angle2 = -1;
      pitch2 = 1;
      fill_func = (void *) o_box_print_filled;
    }

    (*fill_func) (w_current, fp,
		  x, y, width, height,
		  color,
		  fill_width,
		  angle1, pitch1, angle2, pitch2, origin_x, origin_y);
  }

#line 1000 "../noweb/o_box_basic.nw"
}

#line 1132 "../noweb/o_box_basic.nw"
/* PB : parameter filled removed */
void
o_box_print_solid(TOPLEVEL * w_current, FILE * fp,
		  int x, int y,
		  int width, int height,
		  int color,
		  int line_width, int length, int space,
		  int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  o_line_print_solid(w_current, fp,
		     x1, y1, x1 + width, y1,
		     color, line_width, length, space, origin_x, origin_y);
  o_line_print_solid(w_current, fp,
		     x1 + width, y1, x1 + width, y1 + height,
		     color, line_width, length, space, origin_x, origin_y);
  o_line_print_solid(w_current, fp,
		     x1 + width, y1 + height, x1, y1 + height,
		     color, line_width, length, space, origin_x, origin_y);
  o_line_print_solid(w_current, fp,
		     x1, y1 + height, x1, y1,
		     color, line_width, length, space, origin_x, origin_y);
  fprintf(fp, "grestore\n");

}

#line 1193 "../noweb/o_box_basic.nw"
/* PB : parameter filled removed */
/* PB : parameter o_current removed */
void
o_box_print_dotted(TOPLEVEL * w_current, FILE * fp,
		   int x, int y,
		   int width, int height,
		   int color,
		   int line_width, int length, int space,
		   int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  o_line_print_dotted(w_current, fp,
		      x1, y1, x1 + width, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dotted(w_current, fp,
		      x1 + width, y1, x1 + width, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dotted(w_current, fp,
		      x1 + width, y1 + height, x1, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dotted(w_current, fp,
		      x1, y1 + height, x1, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  fprintf(fp, "grestore\n");

}

#line 1254 "../noweb/o_box_basic.nw"
/* PB : parameter filled removed */
/* PB : parameter o_current removed */
void
o_box_print_dashed(TOPLEVEL * w_current, FILE * fp,
		   int x, int y,
		   int width, int height,
		   int color,
		   int line_width, int length, int space,
		   int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  o_line_print_dashed(w_current, fp,
		      x1, y1, x1 + width, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dashed(w_current, fp,
		      x1 + width, y1, x1 + width, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dashed(w_current, fp,
		      x1 + width, y1 + height, x1, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_dashed(w_current, fp,
		      x1, y1 + height, x1, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  fprintf(fp, "grestore\n");

}

#line 1315 "../noweb/o_box_basic.nw"
/* PB : parameter filled removed */
/* PB : parameter o_current removed */
void
o_box_print_center(TOPLEVEL * w_current, FILE * fp,
		   int x, int y,
		   int width, int height,
		   int color,
		   int line_width, int length, int space,
		   int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  o_line_print_center(w_current, fp,
		      x1, y1, x1 + width, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_center(w_current, fp,
		      x1 + width, y1, x1 + width, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_center(w_current, fp,
		      x1 + width, y1 + height, x1, y1 + height,
		      color,
		      line_width, length, space, origin_x, origin_y);
  o_line_print_center(w_current, fp,
		      x1, y1 + height, x1, y1,
		      color,
		      line_width, length, space, origin_x, origin_y);
  fprintf(fp, "grestore\n");

}

#line 1376 "../noweb/o_box_basic.nw"
/* PB : parameter filled removed */
/* PB : parameter o_current removed */
void
o_box_print_phantom(TOPLEVEL * w_current, FILE * fp,
		    int x, int y,
		    int width, int height,
		    int color,
		    int line_width, int length, int space,
		    int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  o_line_print_phantom(w_current, fp,
		       x1, y1, x1 + width, y1,
		       color,
		       line_width, length, space, origin_x, origin_y);
  o_line_print_phantom(w_current, fp,
		       x1 + width, y1, x1 + width, y1 + height,
		       color,
		       line_width, length, space, origin_x, origin_y);
  o_line_print_phantom(w_current, fp,
		       x1 + width, y1 + height, x1, y1 + height,
		       color,
		       line_width, length, space, origin_x, origin_y);
  o_line_print_phantom(w_current, fp,
		       x1, y1 + height, x1, y1,
		       color,
		       line_width, length, space, origin_x, origin_y);
  fprintf(fp, "grestore\n");
}

#line 1442 "../noweb/o_box_basic.nw"
void
o_box_print_filled(TOPLEVEL * w_current, FILE * fp,
		   int x, int y,
		   int width, int height,
		   int color,
		   int fill_width,
		   int angle1, int pitch1,
		   int angle2, int pitch2, int origin_x, int origin_y)
{
  int x1, y1;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, 1);

  x1 = x;
  y1 = y - height;		/* move the origin to 0, 0 */

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils moveto\n", x1 - origin_x, y1 - origin_y);
  fprintf(fp, "%d mils %d mils fbox\n", width, height);
  fprintf(fp, "grestore\n");

}

#line 1487 "../noweb/o_box_basic.nw"
void
o_box_print_mesh(TOPLEVEL * w_current, FILE * fp,
		 int x, int y,
		 int width, int height,
		 int color,
		 int fill_width,
		 int angle1, int pitch1,
		 int angle2, int pitch2, int origin_x, int origin_y)
{
  o_box_print_hatch(w_current, fp,
		    x, y, width, height,
		    color,
		    fill_width,
		    angle1, pitch1, -1, -1, origin_x, origin_y);
  o_box_print_hatch(w_current, fp,
		    x, y, width, height,
		    color,
		    fill_width,
		    angle2, pitch2, -1, -1, origin_x, origin_y);

}

#line 1528 "../noweb/o_box_basic.nw"
void
o_box_print_hatch(TOPLEVEL * w_current, FILE * fp,
		  int x, int y,
		  int width, int height,
		  int color,
		  int fill_width,
		  int angle1, int pitch1,
		  int angle2, int pitch2, int origin_x, int origin_y)
{
  int x3, y3, x4, y4;
  double cos_a_, sin_a_;
  double x0, y0, r;
  double x1, y1, x2, y2;
  double amin, amax, a[4], min1, min2, max1, max2;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, fill_width);

#line 1556 "../noweb/o_box_basic.nw"
  cos_a_ = cos(((double) angle1) * M_PI / 180);
  sin_a_ = sin(((double) angle1) * M_PI / 180);

#line 1564 "../noweb/o_box_basic.nw"
  r = sqrt((double) (pow(width, 2) + pow(height, 2))) / 2;


#line 1578 "../noweb/o_box_basic.nw"
  y0 = 0;
  while (y0 < r) {
    x0 = pow(r, 2) - pow(y0, 2);
    x0 = sqrt(x0);

    x1 = (x0 * cos_a_ - y0 * sin_a_);
    y1 = (x0 * sin_a_ + y0 * cos_a_);
    x2 = ((-x0) * cos_a_ - y0 * sin_a_);
    y2 = ((-x0) * sin_a_ + y0 * cos_a_);


#line 1594 "../noweb/o_box_basic.nw"

    if ((int) (x2 - x1) != 0) {
      a[0] = ((-width / 2) - x1) / (x2 - x1);
      a[1] = ((width / 2) - x1) / (x2 - x1);
    } else {
      a[0] = 0;
      a[1] = 1;
    }

    if ((int) (y2 - y1) != 0) {
      a[2] = ((-height / 2) - y1) / (y2 - y1);
      a[3] = ((height / 2) - y1) / (y2 - y1);
    } else {
      a[2] = 0;
      a[3] = 1;
    }
#line 1613 "../noweb/o_box_basic.nw"
    if (a[0] < a[1]) {
      min1 = a[0];
      max1 = a[1];
    } else {
      min1 = a[1];
      max1 = a[0];
    }

    if (a[2] < a[3]) {
      min2 = a[2];
      max2 = a[3];
    } else {
      min2 = a[3];
      max2 = a[2];
    }

    amin = (min1 < min2) ? min2 : min1;
    amin = (amin < 0) ? 0 : amin;

    amax = (max1 < max2) ? max1 : max2;
    amax = (amax < 1) ? amax : 1;

#line 1638 "../noweb/o_box_basic.nw"
    if ((amax > amin) && (amax != 1) && (amin != 0)) {
      /* There is intersection between the line and the box edges */
      x3 = (int) (x1 + amin * (x2 - x1));
      y3 = (int) (y1 + amin * (y2 - y1));

      x4 = (int) (x1 + amax * (x2 - x1));
      y4 = (int) (y1 + amax * (y2 - y1));

      fprintf(fp, "newpath\n");
      fprintf(fp, "%d mils %d mils moveto\n",
	      x3 + (x + width / 2), y3 + (y - height / 2));
      fprintf(fp, "%d mils %d mils lineto\n",
	      x4 + (x + width / 2), y4 + (y - height / 2));

      fprintf(fp, "stroke\n");

      fprintf(fp, "newpath\n");
      fprintf(fp, "%d mils %d mils moveto\n",
	      -x3 + (x + width / 2), -y3 + (y - height / 2));
      fprintf(fp, "%d mils %d mils lineto\n",
	      -x4 + (x + width / 2), -y4 + (y - height / 2));
      fprintf(fp, "stroke\n");

    } else {
      break;
    }

    y0 = y0 + pitch1;
  }


#line 1568 "../noweb/o_box_basic.nw"
  fprintf(fp, "grestore\n");

}

#line 50 "../noweb/o_box_basic.nw"
#if 0				/* original way of printing box, no longer used */
#line 1678 "../noweb/o_box_basic.nw"
void
o_box_print_old(TOPLEVEL * w_current, FILE * fp,
		int origin_x, int origin_y)
{
  int width, height;
  int x1, y1;
  if (o_current == NULL) {
    printf("got null in o_box_print\n");
    return;
  }

  if (w_current->print_color) {
    f_print_set_color(fp, o_current->color);
  }


  width = abs(o_current->line_points->x2 - o_current->line_points->x1);
  height = abs(o_current->line_points->y1 - o_current->line_points->y2);

  x1 = o_current->line_points->x1;
  y1 = o_current->line_points->y1 - height;	/* move the origin to 0, 0 */

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils moveto\n", x1 - origin_x, y1 - origin_y);
  fprintf(fp, "%d mils %d mils box\n", width, height);

}

#line 52 "../noweb/o_box_basic.nw"
#endif

#line 1716 "../noweb/o_box_basic.nw"
void
o_box_image_write(TOPLEVEL * w_current, OBJECT * o_current,
		  int origin_x, int origin_y, int color_mode)
{
  int color;


  if (o_current == NULL) {
    printf("got null in o_box_image_write\n");
    return;
  }


  if (color_mode == TRUE) {
    color = o_image_geda2gd_color(o_current->color);
  } else {
    color = image_black;
  }

  /* assumes screen coords are already calculated correctly */
#ifdef HAS_LIBGDGEDA

  gdImageSetThickness(current_im_ptr, SCREENabs(w_current,
						o_current->line_width));

  gdImageRectangle(current_im_ptr,
		   o_current->box->screen_upper_x,
		   o_current->box->screen_upper_y,
		   o_current->box->screen_lower_x,
		   o_current->box->screen_lower_y, color);
#endif

}
