/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TEST_FIXTURE (test_fixture_get_type ())
#define TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_FIXTURE, TestFixture))
#define TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_FIXTURE, TestFixtureClass))
#define IS_TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_FIXTURE))
#define IS_TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_FIXTURE))
#define TEST_FIXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_FIXTURE, TestFixtureClass))

typedef struct _TestFixture TestFixture;
typedef struct _TestFixtureClass TestFixtureClass;
typedef struct _TestFixturePrivate TestFixturePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

struct _TestFixture {
	GObject parent_instance;
	TestFixturePrivate * priv;
};

struct _TestFixtureClass {
	GObjectClass parent_class;
	void (*setup) (TestFixture* self);
	void (*teardown) (TestFixture* self);
};

struct _CollectionTests {
	TestFixture parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* int_collection;
	GeeCollection* string_collection;
	GeeCollection* object_collection;
};

struct _CollectionTestsClass {
	TestFixtureClass parent_class;
};

typedef void (*TestFixtureTestMethod) (void* user_data);

static gpointer collection_tests_parent_class = NULL;

GType test_fixture_get_type (void);
GType collection_tests_get_type (void);
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
TestFixture* test_fixture_new (const char* name);
TestFixture* test_fixture_construct (GType object_type, const char* name);
void test_fixture_add_test (TestFixture* self, const char* name, TestFixtureTestMethod test, void* test_target);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_test_fixture_test_method (gpointer self);
CollectionTests* collection_tests_new (const char* name);
CollectionTests* collection_tests_construct (GType object_type, const char* name);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _collection_tests_test_to_array_test_fixture_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


CollectionTests* collection_tests_construct (GType object_type, const char* name) {
	CollectionTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CollectionTests*) test_fixture_construct (object_type, name);
	test_fixture_add_test ((TestFixture*) self, "Collection.to_array", (TestFixtureTestMethod) _collection_tests_test_to_array_test_fixture_test_method, self);
	return self;
}


CollectionTests* collection_tests_new (const char* name) {
	return collection_tests_construct (TYPE_COLLECTION_TESTS, name);
}


void collection_tests_test_to_array (CollectionTests* self) {
	char** _tmp1_;
	gint array_size;
	gint array_length1;
	gint _tmp0_;
	char** array;
	g_return_if_fail (self != NULL);
	gee_collection_add (self->string_collection, "42");
	gee_collection_add (self->string_collection, "43");
	gee_collection_add (self->string_collection, "44");
	_tmp1_ = NULL;
	array = (_tmp1_ = (char**) gee_collection_to_array (self->string_collection, &_tmp0_), array_length1 = _tmp0_, array_size = array_length1, _tmp1_);
	g_assert (_vala_strcmp0 (array[0], "42") == 0);
	g_assert (_vala_strcmp0 (array[1], "43") == 0);
	g_assert (_vala_strcmp0 (array[2], "44") == 0);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = COLLECTION_TESTS (obj);
	(self->int_collection == NULL) ? NULL : (self->int_collection = (g_object_unref (self->int_collection), NULL));
	(self->string_collection == NULL) ? NULL : (self->string_collection = (g_object_unref (self->string_collection), NULL));
	(self->object_collection == NULL) ? NULL : (self->object_collection = (g_object_unref (self->object_collection), NULL));
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static GType collection_tests_type_id = 0;
	if (collection_tests_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		collection_tests_type_id = g_type_register_static (TYPE_TEST_FIXTURE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return collection_tests_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




