=begin
  rmsgfmt.rb - Generate a .mo

  Copyright (C) 2003-2005 Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end

require 'optparse'
require 'fileutils'
require 'gettext'
require 'gettext/poparser'

module GetText
  GetText.bindtextdomain("rgettext")

  module RMsgfmt
    extend GetText

    VERSION = GetText::VERSION
    DATE = %w($Date: 2005/10/22 10:49:59 $)[1]
    
    module_function
    def run(targetfile = nil, output_path = nil)
      unless targetfile
	targetfile, output_path = check_options
      end
      unless targetfile
	raise ArgumentError, _("no input files")
      end
      unless output_path
	output_path = "messages.mo"
      end

      parser = PoParser.new
      data = MOFile.new
      parser.parse(File.open(targetfile).read, data)
      data.save_to_file(output_path)
    end

    def check_options
      output = nil

      opts = OptionParser.new
      opts.banner = _("Usage: %s input.po [-o output.mo]" % $0)
      opts.separator("")
      opts.separator(_("Generate binary message catalog from textual translation description."))
      opts.separator("")
      opts.separator(_("Specific options:"))

      opts.on("-o", "--output=FILE", _("write output to specified file")) do |out|
	output = out
      end

      opts.on_tail("--version", _("display version information and exit")) do
	puts "#{$0} #{VERSION} (#{DATE})"
	exit
      end
      opts.parse!(ARGV)

      if ARGV.size == 0
	puts opts.help
	exit 1
      end

      [ARGV[0], output]
    end
  end

  module_function
  def rmsgfmt(targetfile = nil, output_path = nil)
    RMsgfmt.run(targetfile, output_path)
  end

  def create_mofiles(verbose = false, 
		     podir = "./po", targetdir = "./data/locale", 
		     targetpath_rule = "%s/LC_MESSAGES")

    modir = File.join(targetdir, targetpath_rule)
    Dir.glob(File.join(podir, "*/*.po")) do |file|
      lang, basename = /\/([^\/]+?)\/(.*)\.po/.match(file[podir.size..-1]).to_a[1,2]
      outdir = modir % lang
      FileUtils.mkdir_p(outdir) unless File.directory?(outdir)
      rmsgfmt(file, File.join(outdir, "#{basename}.mo"))
      if verbose
	$stderr.puts %Q[#{file} -> #{File.join(outdir, "#{basename}.mo")}]
      end
    end
  end
end

if $0 == __FILE__ then
  GetText.rmsgfmt
end
