=begin
  utils.rb - Utility functions

  Copyright (C) 2005 Masao Mutoh

  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end

require 'gettext/rgettext'
require 'gettext/rmsgfmt'
require 'fileutils'

module GetText
  module_function
  def msgmerge(defpo, refpo, app_version)
    $stderr.puts defpo
    cmd = ENV["MSGMERGE_PATH"]
    cmd ||= "msgmerge"

    cont = ""
    if FileTest.exist? defpo
      cont = `#{cmd} #{defpo} #{refpo}`
    else
      File.open(refpo) do |io| 
	cont = io.read
      end
    end
    cont.sub!(/(Project-Id-Version\:).*$/, "\\1 #{app_version}\\n\"")
    File.open(defpo, "w") do |out| 
      out.write(cont)
    end
  end

  def msgmerge_all(textdomain, app_version, po_root = "po", refpot = "tmp.pot")
    FileUtils.mkdir_p(po_root) unless FileTest.exist? po_root
    msgmerge("#{po_root}/#{textdomain}.pot", refpot, app_version)
    
    Dir.glob("#{po_root}/*/#{textdomain}.po"){ |f|
      lang = /#{po_root}\/(.*)\//.match(f).to_a[1]
      msgmerge("#{po_root}/#{lang}/#{textdomain}.po", refpot, app_version)
    }
  end

  # updatepo("myapp", Dir.glob("lib/*.rb"), "myapp 1.0.0")
  def update_pofiles(textdomain, files, app_version, po_root = "po", refpot = "tmp.pot")
    rgettext(files, refpot)
    msgmerge_all(textdomain, app_version, po_root, refpot)
    File.delete(refpot)
  end
end

if __FILE__ == $0
  GetText.update_pofiles("foo", ARGV, "foo 1.1.0")
end
