# gettext_plugin.rb - a sample script for Ruby on Rails
#
# Copyright (C) 2005 Masao Mutoh
#
# This file is distributed under the same license as Ruby-GetText-Package.

require 'gettext/rails'

module LangHelper
  # If you need to bind yet another textdomain to your plugin/helper.
  # Separate the name space from ActionView::Base/ApplicationController.
  class YetanotherTextDomain
    include GetText::Rails

    def initialize
      # You need to call bindtextdomain in an instance of ActionView::Base.
      # The locale is used same values which define ApplicationController#init_gettext.
      bindtextdomain("gettext_plugin") 
    end

    def show_language(actionview)
      langs = ["en"] + Dir.glob(File.join(RAILS_ROOT,"locale/*")).collect{|item| File.basename(item)}
      langs.delete("CVS")
      langs.uniq!
      ret = "<h4>" + _("Select locale") + "</h4>"
      langs.sort.each_with_index do |lang, i|
	ret << actionview.link_to("[#{lang}]", :action => "cookie_locale", :lang => lang)
	if ((i + 1) % 6 == 0)
	  ret << "<br/>"
	end
      end
      ret
    end
 
    def cookie_locale(cookies, flash, params)
      cookies["lang"] = params["lang"]
      flash[:notice] = _('Cookie &quot;lang&quot; is set: %s') % params["lang"]
    end
  end

  # This function shows supported languages with link to set cookie 
  # action (cookie_locale).
  def show_language
    YetanotherTextDomain.new.show_language(self)
  end

  # This function is called when the language link is set.
  def cookie_locale
    YetanotherTextDomain.new.cookie_locale(cookies, flash, params)
    redirect_to :action => 'list'
  end
end
 
