require 'test/unit'
require 'gettext/cgi'

class TestGetTextCGI < Test::Unit::TestCase
  def test_locale_normalize
    assert_equal("ja_JP", Locale.normalize("ja_JP"))
    assert_equal("ja", Locale.normalize("ja,en-us;q=0.7,en;q=0.3"))
    assert_equal("en_US", Locale.normalize("en-us,ja;q=0.7,en;q=0.3"))
    assert_equal("ja_JP", Locale.normalize("ja-jp"))
    assert_equal("ja", Locale.normalize("ja"))
  end
end
